/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Lob;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.sql.Blob;
import java.util.Date;
import java.util.Objects;

@Entity
@Table(name="HFJ_BINARY_STORAGE_BLOB")
public class BinaryStorageEntity {
    @Id
    @Column(name="BLOB_ID", length=200, nullable=false)
    private String myContentId;
    @Column(name="RESOURCE_ID", length=100, nullable=false)
    private String myResourceId;
    @Column(name="BLOB_SIZE", nullable=false)
    private long mySize;
    @Column(name="CONTENT_TYPE", nullable=false, length=100)
    private String myContentType;
    @Deprecated(since="7.2.0")
    @Lob
    @Column(name="BLOB_DATA", nullable=true, insertable=true, updatable=false)
    private Blob myBlob;
    @Column(name="STORAGE_CONTENT_BIN", nullable=true, length=0x7FFFFFFF)
    private byte[] myStorageContentBin;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="PUBLISHED_DATE", nullable=false)
    private Date myPublished;
    @Column(name="BLOB_HASH", length=128, nullable=true)
    private String myHash;

    public Date getPublished() {
        return new Date(this.myPublished.getTime());
    }

    public void setPublished(Date thePublishedDate) {
        this.myPublished = thePublishedDate;
    }

    public String getHash() {
        return this.myHash;
    }

    public void setContentId(String theContentId) {
        this.myContentId = theContentId;
    }

    public void setResourceId(String theResourceId) {
        this.myResourceId = theResourceId;
    }

    public long getSize() {
        return this.mySize;
    }

    public String getContentType() {
        return this.myContentType;
    }

    public void setContentType(String theContentType) {
        this.myContentType = theContentType;
    }

    public Blob getBlob() {
        return this.myBlob;
    }

    public void setBlob(Blob theBlob) {
        this.myBlob = theBlob;
    }

    public String getContentId() {
        return this.myContentId;
    }

    public void setSize(long theSize) {
        this.mySize = theSize;
    }

    public void setHash(String theHash) {
        this.myHash = theHash;
    }

    public byte[] getStorageContentBin() {
        return this.myStorageContentBin;
    }

    public BinaryStorageEntity setStorageContentBin(byte[] theStorageContentBin) {
        this.myStorageContentBin = theStorageContentBin;
        return this;
    }

    public boolean hasStorageContent() {
        return Objects.nonNull(this.myStorageContentBin);
    }

    public boolean hasBlob() {
        return Objects.nonNull(this.myBlob);
    }
}

