/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndexedSearchParam;
import ca.uhn.fhir.jpa.model.entity.PartitionablePartitionId;
import ca.uhn.fhir.jpa.model.util.SearchParamHash;
import jakarta.persistence.Column;
import jakarta.persistence.MappedSuperclass;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.FullTextField;

@MappedSuperclass
public abstract class BaseResourceIndexedSearchParamQuantity
extends BaseResourceIndexedSearchParam {
    private static final int MAX_LENGTH = 200;
    private static final long serialVersionUID = 1L;
    @Column(name="SP_SYSTEM", nullable=true, length=200)
    @FullTextField
    public String mySystem;
    @Column(name="SP_UNITS", nullable=true, length=200)
    @FullTextField
    public String myUnits;
    @Column(name="HASH_IDENTITY_AND_UNITS", nullable=true)
    private Long myHashIdentityAndUnits;
    @Column(name="HASH_IDENTITY_SYS_UNITS", nullable=true)
    private Long myHashIdentitySystemAndUnits;

    @Override
    public void clearHashes() {
        this.myHashIdentity = null;
        this.myHashIdentityAndUnits = null;
        this.myHashIdentitySystemAndUnits = null;
    }

    @Override
    public void calculateHashes() {
        if (this.myHashIdentity != null || this.myHashIdentityAndUnits != null || this.myHashIdentitySystemAndUnits != null) {
            return;
        }
        String resourceType = this.getResourceType();
        String paramName = this.getParamName();
        String units = this.getUnits();
        String system = this.getSystem();
        this.setHashIdentity(BaseResourceIndexedSearchParamQuantity.calculateHashIdentity(this.getPartitionSettings(), this.getPartitionId(), resourceType, paramName));
        this.setHashIdentityAndUnits(BaseResourceIndexedSearchParamQuantity.calculateHashUnits(this.getPartitionSettings(), this.getPartitionId(), resourceType, paramName, units));
        this.setHashIdentitySystemAndUnits(BaseResourceIndexedSearchParamQuantity.calculateHashSystemAndUnits(this.getPartitionSettings(), this.getPartitionId(), resourceType, paramName, system, units));
    }

    public Long getHashIdentityAndUnits() {
        return this.myHashIdentityAndUnits;
    }

    public void setHashIdentityAndUnits(Long theHashIdentityAndUnits) {
        this.myHashIdentityAndUnits = theHashIdentityAndUnits;
    }

    public Long getHashIdentitySystemAndUnits() {
        return this.myHashIdentitySystemAndUnits;
    }

    public void setHashIdentitySystemAndUnits(Long theHashIdentitySystemAndUnits) {
        this.myHashIdentitySystemAndUnits = theHashIdentitySystemAndUnits;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public void setSystem(String theSystem) {
        this.mySystem = theSystem;
    }

    public String getUnits() {
        return this.myUnits;
    }

    public void setUnits(String theUnits) {
        this.myUnits = theUnits;
    }

    @Override
    public int hashCode() {
        HashCodeBuilder b = new HashCodeBuilder();
        b.append((Object)this.getHashIdentity());
        b.append((Object)this.getHashIdentityAndUnits());
        b.append((Object)this.getHashIdentitySystemAndUnits());
        return b.toHashCode();
    }

    public static long calculateHashSystemAndUnits(PartitionSettings thePartitionSettings, PartitionablePartitionId theRequestPartitionId, String theResourceType, String theParamName, String theSystem, String theUnits) {
        RequestPartitionId requestPartitionId = PartitionablePartitionId.toRequestPartitionId(theRequestPartitionId);
        return BaseResourceIndexedSearchParamQuantity.calculateHashSystemAndUnits(thePartitionSettings, requestPartitionId, theResourceType, theParamName, theSystem, theUnits);
    }

    public static long calculateHashSystemAndUnits(PartitionSettings thePartitionSettings, RequestPartitionId theRequestPartitionId, String theResourceType, String theParamName, String theSystem, String theUnits) {
        return SearchParamHash.hashSearchParam(thePartitionSettings, theRequestPartitionId, theResourceType, theParamName, theSystem, theUnits);
    }

    public static long calculateHashUnits(PartitionSettings thePartitionSettings, PartitionablePartitionId theRequestPartitionId, String theResourceType, String theParamName, String theUnits) {
        RequestPartitionId requestPartitionId = PartitionablePartitionId.toRequestPartitionId(theRequestPartitionId);
        return BaseResourceIndexedSearchParamQuantity.calculateHashUnits(thePartitionSettings, requestPartitionId, theResourceType, theParamName, theUnits);
    }

    public static long calculateHashUnits(PartitionSettings thePartitionSettings, RequestPartitionId theRequestPartitionId, String theResourceType, String theParamName, String theUnits) {
        return SearchParamHash.hashSearchParam(thePartitionSettings, theRequestPartitionId, theResourceType, theParamName, theUnits);
    }
}

