/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.jpa.model.cross.IBasePersistedResource;
import ca.uhn.fhir.jpa.model.dao.JpaPid;
import ca.uhn.fhir.jpa.model.entity.BaseTag;
import ca.uhn.fhir.jpa.model.entity.IBaseResourceEntity;
import ca.uhn.fhir.jpa.model.entity.TagDefinition;
import ca.uhn.fhir.model.primitive.InstantDt;
import jakarta.persistence.Column;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import org.hibernate.annotations.JdbcTypeCode;
import org.hibernate.annotations.OptimisticLock;

@MappedSuperclass
public abstract class BaseHasResource<T>
implements IBaseResourceEntity<T>,
IBasePersistedResource<JpaPid>,
Serializable {
    public static final String RES_PUBLISHED = "RES_PUBLISHED";
    public static final String RES_UPDATED = "RES_UPDATED";
    @Column(name="RES_DELETED_AT", nullable=true)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date myDeleted;
    @Column(name="RES_VERSION", nullable=true, length=7)
    @Enumerated(value=EnumType.STRING)
    @OptimisticLock(excluded=true)
    @JdbcTypeCode(value=12)
    private FhirVersionEnum myFhirVersion;
    @Column(name="HAS_TAGS", nullable=false)
    @OptimisticLock(excluded=true)
    private boolean myHasTags;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="RES_PUBLISHED", nullable=false)
    @OptimisticLock(excluded=true)
    private Date myPublished;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="RES_UPDATED", nullable=false)
    @OptimisticLock(excluded=true)
    private Date myUpdated;

    public abstract BaseTag addTag(TagDefinition var1);

    @Override
    public Date getDeleted() {
        return BaseHasResource.cloneDate(this.myDeleted);
    }

    @Override
    public FhirVersionEnum getFhirVersion() {
        return this.myFhirVersion;
    }

    public void setFhirVersion(FhirVersionEnum theFhirVersion) {
        this.myFhirVersion = theFhirVersion;
    }

    public void setDeleted(Date theDate) {
        this.myDeleted = theDate;
    }

    @Override
    public InstantDt getPublished() {
        if (this.myPublished != null) {
            return new InstantDt(this.getPublishedDate());
        }
        return null;
    }

    public Date getPublishedDate() {
        return BaseHasResource.cloneDate(this.myPublished);
    }

    public void setPublished(Date thePublished) {
        this.myPublished = thePublished;
    }

    public void setPublished(InstantDt thePublished) {
        this.myPublished = (Date)thePublished.getValue();
    }

    public abstract Collection<? extends BaseTag> getTags();

    @Override
    public InstantDt getUpdated() {
        return new InstantDt(this.getUpdatedDate());
    }

    @Override
    public Date getUpdatedDate() {
        return BaseHasResource.cloneDate(this.myUpdated);
    }

    public void setUpdated(Date theUpdated) {
        this.myUpdated = theUpdated;
    }

    @Override
    public boolean isHasTags() {
        return this.myHasTags;
    }

    public void setHasTags(boolean theHasTags) {
        this.myHasTags = theHasTags;
    }

    static Date cloneDate(Date theDate) {
        Date retVal = theDate;
        if (retVal != null) {
            retVal = new Date(retVal.getTime());
        }
        return retVal;
    }
}

