/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.dialect;

import ca.uhn.fhir.jpa.model.entity.StorageSettings;
import ca.uhn.fhir.jpa.util.ISequenceValueMassager;
import java.io.Serializable;
import java.util.Properties;
import org.apache.commons.lang3.Validate;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.ExportableProducer;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.BulkInsertionCapableIdentifierGenerator;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.id.enhanced.SequenceStyleGenerator;
import org.hibernate.id.enhanced.StandardOptimizerDescriptor;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;

public class HapiSequenceStyleGenerator
implements PersistentIdentifierGenerator,
BulkInsertionCapableIdentifierGenerator,
ExportableProducer {
    public static final String ID_MASSAGER_TYPE_KEY = "hapi_fhir.sequence_generator_massager";
    private final SequenceStyleGenerator myGen = new SequenceStyleGenerator();
    @Autowired
    private StorageSettings myStorageSettings;
    private ISequenceValueMassager myIdMassager;
    private boolean myConfigured;
    private String myGeneratorName;

    public boolean supportsBulkInsertionIdentifierGeneration() {
        return this.myGen.supportsBulkInsertionIdentifierGeneration();
    }

    public String determineBulkInsertionIdentifierGenerationSelectFragment(SqlStringGenerationContext theContext) {
        return this.myGen.determineBulkInsertionIdentifierGenerationSelectFragment(theContext);
    }

    public Serializable generate(SharedSessionContractImplementor theSession, Object theObject) throws HibernateException {
        Long retVal;
        Long l = retVal = this.myIdMassager != null ? this.myIdMassager.generate(this.myGeneratorName) : null;
        if (retVal == null) {
            Long next = (Long)this.myGen.generate(theSession, theObject);
            retVal = this.myIdMassager.massage(this.myGeneratorName, next);
        }
        return retVal;
    }

    public void configure(Type theType, Properties theParams, ServiceRegistry theServiceRegistry) throws MappingException {
        this.myIdMassager = (ISequenceValueMassager)theServiceRegistry.getService(ISequenceValueMassager.class);
        if (this.myIdMassager == null) {
            this.myIdMassager = new ISequenceValueMassager.NoopSequenceValueMassager();
        }
        this.myGeneratorName = theParams.getProperty("GENERATOR_NAME");
        Validate.notBlank((CharSequence)this.myGeneratorName, (String)"No generator name found", (Object[])new Object[0]);
        Properties props = new Properties(theParams);
        props.put("optimizer", StandardOptimizerDescriptor.POOLED.getExternalName());
        props.put("initial_value", "1");
        props.put("increment_size", "50");
        props.put("GENERATOR_NAME", this.myGeneratorName);
        this.myGen.configure(theType, props, theServiceRegistry);
        this.myConfigured = true;
    }

    public void registerExportables(Database database) {
        this.myGen.registerExportables(database);
    }

    public void initialize(SqlStringGenerationContext context) {
        this.myGen.initialize(context);
    }

    public boolean supportsJdbcBatchInserts() {
        return this.myGen.supportsJdbcBatchInserts();
    }

    public Optimizer getOptimizer() {
        return this.myGen.getOptimizer();
    }
}

