/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.util;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.param.QuantityParam;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.util.ClasspathUtil;
import jakarta.annotation.Nullable;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.fhir.ucum.Decimal;
import org.fhir.ucum.Pair;
import org.fhir.ucum.UcumEssenceService;
import org.fhir.ucum.UcumException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UcumServiceUtil {
    private static final Logger ourLog = LoggerFactory.getLogger(UcumServiceUtil.class);
    public static final String CELSIUS_CODE = "Cel";
    public static final String FAHRENHEIT_CODE = "[degF]";
    public static final float CELSIUS_KELVIN_DIFF = 273.15f;
    public static final String UCUM_CODESYSTEM_URL = "http://unitsofmeasure.org";
    private static final String UCUM_SOURCE = "/ucum-essence.xml";
    private static UcumEssenceService myUcumEssenceService = null;

    private UcumServiceUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        if (myUcumEssenceService != null) {
            return;
        }
        Class<UcumServiceUtil> clazz = UcumServiceUtil.class;
        synchronized (UcumServiceUtil.class) {
            InputStream input = ClasspathUtil.loadResourceAsStream((String)UCUM_SOURCE);
            try {
                myUcumEssenceService = new UcumEssenceService(input);
            }
            catch (UcumException e) {
                ourLog.warn("Failed to load ucum code from {}: {}", (Object)UCUM_SOURCE, (Object)e);
            }
            finally {
                ClasspathUtil.close((InputStream)input);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static Pair getCanonicalForm(String theSystem, BigDecimal theValue, String theCode) {
        Pair theCanonicalPair;
        if (!UCUM_CODESYSTEM_URL.equals(theSystem) || theValue == null || theCode == null) {
            return null;
        }
        if (UcumServiceUtil.isCelsiusOrFahrenheit(theCode)) {
            try {
                return UcumServiceUtil.getCanonicalFormForCelsiusOrFahrenheit(theValue, theCode);
            }
            catch (UcumException theE) {
                ourLog.error("Exception when trying to obtain canonical form for value {} and code {}: {}", new Object[]{theValue, theCode, theE.getMessage()});
                return null;
            }
        }
        UcumServiceUtil.init();
        try {
            Decimal theDecimal = new Decimal(theValue.toPlainString(), theValue.precision());
            theCanonicalPair = myUcumEssenceService.getCanonicalForm(new Pair(theDecimal, theCode));
            if (theCanonicalPair.getValue() == null) {
                return null;
            }
        }
        catch (UcumException e) {
            return null;
        }
        return theCanonicalPair;
    }

    private static Pair getCanonicalFormForCelsiusOrFahrenheit(BigDecimal theValue, String theCode) throws UcumException {
        return theCode.equals(CELSIUS_CODE) ? UcumServiceUtil.canonicalizeCelsius(theValue) : UcumServiceUtil.canonicalizeFahrenheit(theValue);
    }

    private static Pair canonicalizeFahrenheit(BigDecimal theValue) throws UcumException {
        BigDecimal converted = theValue.subtract(BigDecimal.valueOf(32L)).multiply(BigDecimal.valueOf(0.5555555820465088)).add(BigDecimal.valueOf(273.15f));
        BigDecimal adjusted = converted.setScale(theValue.precision(), RoundingMode.HALF_UP);
        Decimal newValue = new Decimal(adjusted.toPlainString());
        return new Pair(newValue, "K");
    }

    private static Pair canonicalizeCelsius(BigDecimal theValue) throws UcumException {
        Decimal valueDec = new Decimal(theValue.toPlainString(), theValue.precision());
        Decimal converted = valueDec.add(new Decimal(Float.toString(273.15f)));
        return new Pair(converted, "K");
    }

    private static boolean isCelsiusOrFahrenheit(String theCode) {
        return theCode.equals(CELSIUS_CODE) || theCode.equals(FAHRENHEIT_CODE);
    }

    @Nullable
    public static QuantityParam toCanonicalQuantityOrNull(QuantityParam theQuantityParam) {
        Pair canonicalForm = UcumServiceUtil.getCanonicalForm(theQuantityParam.getSystem(), theQuantityParam.getValue(), theQuantityParam.getUnits());
        if (canonicalForm != null) {
            BigDecimal valueValue = new BigDecimal(canonicalForm.getValue().asDecimal());
            String unitsValue = canonicalForm.getCode();
            return (QuantityParam)new QuantityParam().setSystem(theQuantityParam.getSystem()).setValue(valueValue).setUnits(unitsValue).setPrefix(theQuantityParam.getPrefix());
        }
        return null;
    }

    public static double convert(double theDistanceKm, String theSourceUnits, String theTargetUnits) {
        UcumServiceUtil.init();
        try {
            Decimal distance = new Decimal(Double.toString(theDistanceKm));
            Decimal output = myUcumEssenceService.convert(distance, theSourceUnits, theTargetUnits);
            String decimal = output.asDecimal();
            return Double.parseDouble(decimal);
        }
        catch (UcumException e) {
            throw new InvalidRequestException(Msg.code((int)2309) + e.getMessage());
        }
    }
}

