/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.listener;

import ca.uhn.fhir.jpa.model.entity.BaseResourceIndexedSearchParam;
import ca.uhn.fhir.jpa.model.entity.StorageSettings;
import ca.uhn.fhir.jpa.model.search.ISearchParamHashIdentityRegistry;
import ca.uhn.fhir.rest.server.util.IndexedSearchParam;
import jakarta.persistence.PostLoad;
import jakarta.persistence.PostPersist;
import jakarta.persistence.PostUpdate;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class IndexStorageOptimizationListener {
    private final StorageSettings myStorageSettings;
    private final ApplicationContext myApplicationContext;

    public IndexStorageOptimizationListener(@Autowired StorageSettings theStorageSettings, @Autowired ApplicationContext theApplicationContext) {
        this.myStorageSettings = theStorageSettings;
        this.myApplicationContext = theApplicationContext;
    }

    @PrePersist
    @PreUpdate
    public void optimizeSearchParams(Object theEntity) {
        if (this.myStorageSettings.isIndexStorageOptimized() && theEntity instanceof BaseResourceIndexedSearchParam) {
            ((BaseResourceIndexedSearchParam)theEntity).optimizeIndexStorage();
        }
    }

    @PostLoad
    @PostPersist
    @PostUpdate
    public void restoreSearchParams(Object theEntity) {
        if (this.myStorageSettings.isIndexStorageOptimized() && theEntity instanceof BaseResourceIndexedSearchParam) {
            this.restoreSearchParams((BaseResourceIndexedSearchParam)theEntity);
        }
    }

    private void restoreSearchParams(BaseResourceIndexedSearchParam theResourceIndexedSearchParam) {
        ISearchParamHashIdentityRegistry searchParamRegistry = (ISearchParamHashIdentityRegistry)this.myApplicationContext.getBean(ISearchParamHashIdentityRegistry.class);
        Optional<IndexedSearchParam> indexedSearchParamOptional = searchParamRegistry.getIndexedSearchParamByHashIdentity(theResourceIndexedSearchParam.getHashIdentity());
        if (indexedSearchParamOptional.isPresent()) {
            theResourceIndexedSearchParam.setResourceType(indexedSearchParamOptional.get().getResourceType());
            theResourceIndexedSearchParam.restoreParamName(indexedSearchParamOptional.get().getParameterName());
        }
    }
}

