/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.jpa.model.entity.ResourceHistoryTag;
import ca.uhn.fhir.jpa.model.entity.ResourceTag;
import ca.uhn.fhir.jpa.model.entity.TagTypeEnum;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.OneToMany;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.annotations.JdbcTypeCode;

@Entity
@Table(name="HFJ_TAG_DEF", indexes={@Index(name="IDX_TAG_DEF_TP_CD_SYS", columnList="TAG_TYPE, TAG_CODE, TAG_SYSTEM, TAG_ID, TAG_VERSION, TAG_USER_SELECTED")})
public class TagDefinition
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="TAG_CODE", length=200)
    private String myCode;
    @Column(name="TAG_DISPLAY", length=200)
    private String myDisplay;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_TAGDEF_ID")
    @SequenceGenerator(name="SEQ_TAGDEF_ID", sequenceName="SEQ_TAGDEF_ID")
    @Column(name="TAG_ID")
    private Long myId;
    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="myTag")
    private Collection<ResourceTag> myResources;
    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="myTag")
    private Collection<ResourceHistoryTag> myResourceVersions;
    @Column(name="TAG_SYSTEM", length=200)
    private String mySystem;
    @Column(name="TAG_TYPE", nullable=false)
    @Enumerated(value=EnumType.ORDINAL)
    @JdbcTypeCode(value=4)
    private TagTypeEnum myTagType;
    @Column(name="TAG_VERSION", length=30)
    private String myVersion;
    @Column(name="TAG_USER_SELECTED")
    private Boolean myUserSelected;
    @Transient
    private transient Integer myHashCode;

    public TagDefinition() {
    }

    public TagDefinition(TagTypeEnum theTagType, String theSystem, String theCode, String theDisplay) {
        this.setTagType(theTagType);
        this.setCode(theCode);
        this.setSystem(theSystem);
        this.setDisplay(theDisplay);
    }

    public String getCode() {
        return this.myCode;
    }

    public void setCode(String theCode) {
        this.myCode = theCode;
        this.myHashCode = null;
    }

    public String getDisplay() {
        return this.myDisplay;
    }

    public void setDisplay(String theDisplay) {
        this.myDisplay = theDisplay;
    }

    public Long getId() {
        return this.myId;
    }

    public void setId(Long theId) {
        this.myId = theId;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public void setSystem(String theSystem) {
        this.mySystem = theSystem;
        this.myHashCode = null;
    }

    public TagTypeEnum getTagType() {
        return this.myTagType;
    }

    public void setTagType(TagTypeEnum theTagType) {
        this.myTagType = theTagType;
        this.myHashCode = null;
    }

    public String getVersion() {
        return this.myVersion;
    }

    public void setVersion(String theVersion) {
        this.setVersionAfterTrim(theVersion);
    }

    private void setVersionAfterTrim(String theVersion) {
        if (theVersion != null) {
            this.myVersion = StringUtils.truncate((String)theVersion, (int)30);
        }
    }

    public Boolean getUserSelected() {
        return this.myUserSelected;
    }

    public void setUserSelected(Boolean theUserSelected) {
        this.myUserSelected = theUserSelected;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TagDefinition)) {
            return false;
        }
        TagDefinition other = (TagDefinition)obj;
        EqualsBuilder b = new EqualsBuilder();
        if (this.myId != null && other.myId != null) {
            b.append((Object)this.myId, (Object)other.myId);
        } else {
            b.append((Object)this.myTagType, (Object)other.myTagType);
            b.append((Object)this.mySystem, (Object)other.mySystem);
            b.append((Object)this.myCode, (Object)other.myCode);
            b.append((Object)this.myVersion, (Object)other.myVersion);
            b.append((Object)this.myUserSelected, (Object)other.myUserSelected);
        }
        return b.isEquals();
    }

    public int hashCode() {
        if (this.myHashCode == null) {
            HashCodeBuilder b = new HashCodeBuilder();
            b.append((Object)this.myTagType);
            b.append((Object)this.mySystem);
            b.append((Object)this.myCode);
            b.append((Object)this.myVersion);
            b.append((Object)this.myUserSelected);
            this.myHashCode = b.toHashCode();
        }
        return this.myHashCode;
    }

    public String toString() {
        ToStringBuilder retVal = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        retVal.append("id", (Object)this.myId);
        retVal.append("system", (Object)this.mySystem);
        retVal.append("code", (Object)this.myCode);
        retVal.append("display", (Object)this.myDisplay);
        retVal.append("version", (Object)this.myVersion);
        retVal.append("userSelected", (Object)this.myUserSelected);
        return retVal.build();
    }
}

