/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.dialect.HapiSequenceStyleGenerator;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndex;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndexedSearchParam;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndexedSearchParamQuantity;
import ca.uhn.fhir.jpa.model.entity.IdAndPartitionId;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.model.listener.IndexStorageOptimizationListener;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.param.QuantityParam;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.math.BigDecimal;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.ScaledNumberField;

@EntityListeners(value={IndexStorageOptimizationListener.class})
@Entity
@Table(name="HFJ_SPIDX_QUANTITY", indexes={@Index(name="IDX_SP_QUANTITY_HASH_V2", columnList="HASH_IDENTITY,SP_VALUE,RES_ID,PARTITION_ID"), @Index(name="IDX_SP_QUANTITY_HASH_UN_V2", columnList="HASH_IDENTITY_AND_UNITS,SP_VALUE,RES_ID,PARTITION_ID"), @Index(name="IDX_SP_QUANTITY_HASH_SYSUN_V2", columnList="HASH_IDENTITY_SYS_UNITS,SP_VALUE,RES_ID,PARTITION_ID"), @Index(name="IDX_SP_QUANTITY_RESID_V2", columnList="RES_ID,HASH_IDENTITY,HASH_IDENTITY_SYS_UNITS,HASH_IDENTITY_AND_UNITS,SP_VALUE,PARTITION_ID")})
@IdClass(value=IdAndPartitionId.class)
public class ResourceIndexedSearchParamQuantity
extends BaseResourceIndexedSearchParamQuantity {
    private static final long serialVersionUID = 1L;
    @Id
    @GenericGenerator(name="SEQ_SPIDX_QUANTITY", type=HapiSequenceStyleGenerator.class)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_SPIDX_QUANTITY")
    @Column(name="SP_ID")
    private Long myId;
    @Column(name="SP_VALUE", nullable=true)
    @ScaledNumberField
    public Double myValue;
    @ManyToOne(optional=false, fetch=FetchType.LAZY, cascade={})
    @JoinColumns(value={@JoinColumn(name="RES_ID", referencedColumnName="RES_ID", insertable=false, updatable=false, nullable=false), @JoinColumn(name="PARTITION_ID", referencedColumnName="PARTITION_ID", insertable=false, updatable=false, nullable=false)}, foreignKey=@ForeignKey(name="FK_SP_QUANTITY_RES"))
    private ResourceTable myResource;
    @Column(name="RES_ID", nullable=false)
    private Long myResourceId;

    public ResourceIndexedSearchParamQuantity() {
    }

    public ResourceIndexedSearchParamQuantity(PartitionSettings thePartitionSettings, String theResourceType, String theParamName, BigDecimal theValue, String theSystem, String theUnits) {
        this();
        this.setPartitionSettings(thePartitionSettings);
        this.setResourceType(theResourceType);
        this.setParamName(theParamName);
        this.setSystem(theSystem);
        this.setValue(theValue);
        this.setUnits(theUnits);
        this.calculateHashes();
    }

    @Override
    public <T extends BaseResourceIndex> void copyMutableValuesFrom(T theSource) {
        super.copyMutableValuesFrom(theSource);
        ResourceIndexedSearchParamQuantity source = (ResourceIndexedSearchParamQuantity)theSource;
        this.mySystem = source.mySystem;
        this.myUnits = source.myUnits;
        this.myValue = source.myValue;
        this.setHashIdentity(source.getHashIdentity());
        this.setHashIdentityAndUnits(source.getHashIdentityAndUnits());
        this.setHashIdentitySystemAndUnits(source.getHashIdentitySystemAndUnits());
    }

    @Override
    public void setResourceId(Long theResourceId) {
        this.myResourceId = theResourceId;
    }

    public BigDecimal getValue() {
        return this.myValue != null ? new BigDecimal(this.myValue) : null;
    }

    public ResourceIndexedSearchParamQuantity setValue(BigDecimal theValue) {
        this.myValue = theValue != null ? Double.valueOf(theValue.doubleValue()) : null;
        return this;
    }

    @Override
    public Long getId() {
        return this.myId;
    }

    @Override
    public void setId(Long theId) {
        this.myId = theId;
    }

    @Override
    public IQueryParameterType toQueryParameterType() {
        return new QuantityParam(null, this.getValue(), this.getSystem(), this.getUnits());
    }

    @Override
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        b.append("paramName", (Object)this.getParamName());
        b.append("resourceId", (Object)this.getResourcePid());
        b.append("system", (Object)this.getSystem());
        b.append("units", (Object)this.getUnits());
        b.append("value", (Object)this.getValue());
        b.append("missing", this.isMissing());
        b.append("hashIdentitySystemAndUnits", (Object)this.getHashIdentitySystemAndUnits());
        return b.build();
    }

    @Override
    public boolean equals(Object theObj) {
        if (this == theObj) {
            return true;
        }
        if (theObj == null) {
            return false;
        }
        if (!(theObj instanceof ResourceIndexedSearchParamQuantity)) {
            return false;
        }
        ResourceIndexedSearchParamQuantity obj = (ResourceIndexedSearchParamQuantity)theObj;
        EqualsBuilder b = new EqualsBuilder();
        b.append((Object)this.getHashIdentity(), (Object)obj.getHashIdentity());
        b.append((Object)this.getHashIdentityAndUnits(), (Object)obj.getHashIdentityAndUnits());
        b.append((Object)this.getHashIdentitySystemAndUnits(), (Object)obj.getHashIdentitySystemAndUnits());
        b.append(this.isMissing(), obj.isMissing());
        b.append((Object)this.getValue(), (Object)obj.getValue());
        return b.isEquals();
    }

    @Override
    public int hashCode() {
        HashCodeBuilder b = new HashCodeBuilder();
        b.append((Object)this.getHashIdentity());
        b.append((Object)this.getHashIdentityAndUnits());
        b.append((Object)this.getHashIdentitySystemAndUnits());
        b.append(this.isMissing());
        b.append((Object)this.getValue());
        return b.toHashCode();
    }

    @Override
    public boolean matches(IQueryParameterType theParam) {
        if (!(theParam instanceof QuantityParam)) {
            return false;
        }
        QuantityParam quantity = (QuantityParam)theParam;
        boolean retval = false;
        String quantityUnitsString = StringUtils.defaultString((String)quantity.getUnits());
        if (quantity.getSystem() == null && StringUtils.isBlank((CharSequence)quantityUnitsString)) {
            if (Objects.equals(this.getValue(), quantity.getValue())) {
                retval = true;
            }
        } else {
            String unitsString = StringUtils.defaultString((String)this.getUnits());
            if (quantity.getSystem() == null) {
                if (unitsString.equalsIgnoreCase(quantityUnitsString) && Objects.equals(this.getValue(), quantity.getValue())) {
                    retval = true;
                }
            } else if (StringUtils.isBlank((CharSequence)quantityUnitsString)) {
                if (this.getSystem().equalsIgnoreCase(quantity.getSystem()) && Objects.equals(this.getValue(), quantity.getValue())) {
                    retval = true;
                }
            } else if (this.getSystem().equalsIgnoreCase(quantity.getSystem()) && unitsString.equalsIgnoreCase(quantityUnitsString) && Objects.equals(this.getValue(), quantity.getValue())) {
                retval = true;
            }
        }
        return retval;
    }

    @Override
    public ResourceTable getResource() {
        return this.myResource;
    }

    @Override
    public BaseResourceIndexedSearchParam setResource(ResourceTable theResource) {
        this.myResource = theResource;
        this.setResourceType(theResource.getResourceType());
        return this;
    }
}

