/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.dialect.HapiSequenceStyleGenerator;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndex;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndexedSearchParam;
import ca.uhn.fhir.jpa.model.entity.IdAndPartitionId;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.model.listener.IndexStorageOptimizationListener;
import ca.uhn.fhir.model.api.IQueryParameterType;
import jakarta.annotation.Nullable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.annotations.GenericGenerator;

@EntityListeners(value={IndexStorageOptimizationListener.class})
@Entity
@Table(name="HFJ_SPIDX_COORDS", indexes={@Index(name="IDX_SP_COORDS_HASH_V2", columnList="HASH_IDENTITY,SP_LATITUDE,SP_LONGITUDE,RES_ID,PARTITION_ID"), @Index(name="IDX_SP_COORDS_UPDATED", columnList="SP_UPDATED"), @Index(name="IDX_SP_COORDS_RESID", columnList="RES_ID")})
@IdClass(value=IdAndPartitionId.class)
public class ResourceIndexedSearchParamCoords
extends BaseResourceIndexedSearchParam {
    public static final int MAX_LENGTH = 100;
    private static final long serialVersionUID = 1L;
    @Column(name="SP_LATITUDE", nullable=true)
    public Double myLatitude;
    @Column(name="SP_LONGITUDE", nullable=true)
    public Double myLongitude;
    @Id
    @GenericGenerator(name="SEQ_SPIDX_COORDS", type=HapiSequenceStyleGenerator.class)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_SPIDX_COORDS")
    @Column(name="SP_ID")
    private Long myId;
    @ManyToOne(optional=false, fetch=FetchType.LAZY, cascade={})
    @JoinColumns(value={@JoinColumn(name="RES_ID", referencedColumnName="RES_ID", insertable=false, updatable=false, nullable=false), @JoinColumn(name="PARTITION_ID", referencedColumnName="PARTITION_ID", insertable=false, updatable=false, nullable=false)}, foreignKey=@ForeignKey(name="FKC97MPK37OKWU8QVTCEG2NH9VN"))
    private ResourceTable myResource;
    @Column(name="RES_ID", nullable=false)
    private Long myResourceId;

    public ResourceIndexedSearchParamCoords() {
    }

    public ResourceIndexedSearchParamCoords(PartitionSettings thePartitionSettings, String theResourceType, String theParamName, double theLatitude, double theLongitude) {
        this.setPartitionSettings(thePartitionSettings);
        this.setResourceType(theResourceType);
        this.setParamName(theParamName);
        this.setLatitude(theLatitude);
        this.setLongitude(theLongitude);
        this.calculateHashes();
    }

    @Override
    public void clearHashes() {
        this.myHashIdentity = null;
    }

    @Override
    public void calculateHashes() {
        if (this.myHashIdentity != null) {
            return;
        }
        String resourceType = this.getResourceType();
        String paramName = this.getParamName();
        this.setHashIdentity(ResourceIndexedSearchParamCoords.calculateHashIdentity(this.getPartitionSettings(), this.getPartitionId(), resourceType, paramName));
    }

    @Override
    public boolean equals(Object theObj) {
        if (this == theObj) {
            return true;
        }
        if (theObj == null) {
            return false;
        }
        if (!(theObj instanceof ResourceIndexedSearchParamCoords)) {
            return false;
        }
        ResourceIndexedSearchParamCoords obj = (ResourceIndexedSearchParamCoords)theObj;
        EqualsBuilder b = new EqualsBuilder();
        b.append((Object)this.getHashIdentity(), (Object)obj.getHashIdentity());
        b.append((Object)this.getLatitude(), (Object)obj.getLatitude());
        b.append((Object)this.getLongitude(), (Object)obj.getLongitude());
        b.append(this.isMissing(), obj.isMissing());
        return b.isEquals();
    }

    @Override
    public <T extends BaseResourceIndex> void copyMutableValuesFrom(T theSource) {
        super.copyMutableValuesFrom(theSource);
        ResourceIndexedSearchParamCoords source = (ResourceIndexedSearchParamCoords)theSource;
        this.myLatitude = source.getLatitude();
        this.myLongitude = source.getLongitude();
        this.myHashIdentity = source.myHashIdentity;
    }

    @Override
    public void setResourceId(Long theResourceId) {
        this.myResourceId = theResourceId;
    }

    @Override
    public Long getId() {
        return this.myId;
    }

    @Override
    public void setId(Long theId) {
        this.myId = theId;
    }

    @Nullable
    public Double getLatitude() {
        return this.myLatitude;
    }

    public ResourceIndexedSearchParamCoords setLatitude(double theLatitude) {
        this.myLatitude = theLatitude;
        return this;
    }

    @Nullable
    public Double getLongitude() {
        return this.myLongitude;
    }

    public ResourceIndexedSearchParamCoords setLongitude(double theLongitude) {
        this.myLongitude = theLongitude;
        return this;
    }

    @Override
    public int hashCode() {
        HashCodeBuilder b = new HashCodeBuilder();
        b.append((Object)this.getHashIdentity());
        b.append((Object)this.getLatitude());
        b.append((Object)this.getLongitude());
        b.append(this.isMissing());
        return b.toHashCode();
    }

    @Override
    public IQueryParameterType toQueryParameterType() {
        return null;
    }

    @Override
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        b.append("paramName", (Object)this.getParamName());
        b.append("resourceId", (Object)this.getResourcePid());
        if (this.isMissing()) {
            b.append("missing", this.isMissing());
        } else {
            b.append("lat", (Object)this.getLatitude());
            b.append("lon", (Object)this.getLongitude());
        }
        return b.build();
    }

    @Override
    public ResourceTable getResource() {
        return this.myResource;
    }

    @Override
    public BaseResourceIndexedSearchParam setResource(ResourceTable theResource) {
        this.myResource = theResource;
        this.setResourceType(theResource.getResourceType());
        return this;
    }
}

