/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.jpa.model.dao.JpaPid;
import ca.uhn.fhir.jpa.model.dao.JpaPidFk;
import ca.uhn.fhir.jpa.model.entity.BaseHasResource;
import ca.uhn.fhir.jpa.model.entity.PartitionablePartitionId;
import ca.uhn.fhir.jpa.model.entity.ResourceEncodingEnum;
import ca.uhn.fhir.jpa.model.entity.ResourceHistoryProvenanceEntity;
import ca.uhn.fhir.jpa.model.entity.ResourceHistoryTablePk;
import ca.uhn.fhir.jpa.model.entity.ResourceHistoryTag;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.model.entity.ResourceTag;
import ca.uhn.fhir.jpa.model.entity.TagDefinition;
import ca.uhn.fhir.model.primitive.IdDt;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.AttributeOverrides;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Embedded;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.persistence.UniqueConstraint;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.annotations.JdbcTypeCode;
import org.hibernate.annotations.OptimisticLock;

@Entity
@Table(name="HFJ_RES_VER", uniqueConstraints={@UniqueConstraint(name="IDX_RESVER_ID_VER", columnNames={"PARTITION_ID", "RES_ID", "RES_VER"})}, indexes={@Index(name="IDX_RESVER_TYPE_DATE", columnList="RES_TYPE,RES_UPDATED,RES_ID"), @Index(name="IDX_RESVER_ID_DATE", columnList="RES_ID,RES_UPDATED"), @Index(name="IDX_RESVER_DATE", columnList="RES_UPDATED,RES_ID")})
public class ResourceHistoryTable
extends BaseHasResource<ResourceHistoryTablePk>
implements Serializable {
    public static final String IDX_RESVER_ID_VER = "IDX_RESVER_ID_VER";
    public static final int SOURCE_URI_LENGTH = 768;
    public static final int ENCODING_COL_LENGTH = 5;
    public static final String HFJ_RES_VER = "HFJ_RES_VER";
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private ResourceHistoryTablePk myId;
    @Column(name="PARTITION_ID", nullable=true, insertable=false, updatable=false)
    private Integer myPartitionIdValue;
    @Column(name="PARTITION_DATE", updatable=false, nullable=true)
    private LocalDate myPartitionDateValue;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="RES_ID", nullable=false, insertable=false, updatable=false), @JoinColumn(name="PARTITION_ID", nullable=false, insertable=false, updatable=false)}, foreignKey=@ForeignKey(name="FK_RESOURCE_HISTORY_RESOURCE"))
    private ResourceTable myResourceTable;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="myId", column=@Column(name="RES_ID", insertable=true, updatable=false)), @AttributeOverride(name="myPartitionIdValue", column=@Column(name="PARTITION_ID", insertable=false, updatable=false))})
    private JpaPidFk myResourcePid;
    @Column(name="RES_ID", insertable=false, nullable=false, updatable=false)
    private Long myResourceId;
    @Column(name="RES_TYPE", length=40, nullable=false)
    private String myResourceType;
    @Column(name="RES_VER", nullable=false)
    private Long myResourceVersion;
    @OneToMany(mappedBy="myResourceHistory", cascade={CascadeType.ALL}, fetch=FetchType.LAZY, orphanRemoval=true)
    private Collection<ResourceHistoryTag> myTags;
    @Column(name="RES_TEXT", length=0x7FFFFFFE, nullable=true)
    @Lob
    @OptimisticLock(excluded=true)
    private byte[] myResource;
    @Column(name="RES_TEXT_VC", length=0x7FFFFFFF, nullable=true)
    @OptimisticLock(excluded=true)
    private String myResourceTextVc;
    @Column(name="RES_ENCODING", nullable=false, length=5)
    @Enumerated(value=EnumType.STRING)
    @JdbcTypeCode(value=12)
    @OptimisticLock(excluded=true)
    private ResourceEncodingEnum myEncoding;
    @Column(name="SOURCE_URI", length=768, nullable=true)
    private String mySourceUri;
    @Column(name="REQUEST_ID", length=16, nullable=true)
    private String myRequestId;
    @Transient
    private transient ResourceHistoryProvenanceEntity myNewHistoryProvenanceEntity;
    @Transient
    private transient String myTransientForcedId;

    @Override
    @Nullable
    public PartitionablePartitionId getPartitionId() {
        return PartitionablePartitionId.with(this.getResourceId().getPartitionId(), this.myPartitionDateValue);
    }

    public String getSourceUri() {
        return this.mySourceUri;
    }

    public void setSourceUri(String theSourceUri) {
        this.mySourceUri = theSourceUri;
    }

    public String getRequestId() {
        return this.myRequestId;
    }

    public void setRequestId(String theRequestId) {
        this.myRequestId = theRequestId;
    }

    public String toString() {
        JpaPid resourceId = this.getResourceId();
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("resourceId", (Object)resourceId.getId()).append("partitionId", (Object)resourceId.getPartitionId()).append("resourceType", (Object)this.myResourceType).append("resourceVersion", (Object)this.myResourceVersion).append("pid", (Object)this.myId).append("updated", (Object)this.getPublished()).toString();
    }

    public String getResourceTextVc() {
        return this.myResourceTextVc;
    }

    public void setResourceTextVc(String theResourceTextVc) {
        this.myResourceTextVc = theResourceTextVc;
    }

    public void addTag(ResourceTag theTag) {
        ResourceHistoryTag tag = new ResourceHistoryTag(this, theTag.getTag(), this.getPartitionId());
        tag.setResourceType(theTag.getResourceType());
        this.getTags().add(tag);
    }

    @Override
    public ResourceHistoryTag addTag(TagDefinition theTag) {
        for (ResourceHistoryTag next : this.getTags()) {
            if (!next.getTag().equals(theTag)) continue;
            return next;
        }
        ResourceHistoryTag historyTag = new ResourceHistoryTag(this, theTag, this.getPartitionId());
        this.getTags().add(historyTag);
        return historyTag;
    }

    public ResourceEncodingEnum getEncoding() {
        return this.myEncoding;
    }

    public void setEncoding(ResourceEncodingEnum theEncoding) {
        this.myEncoding = theEncoding;
    }

    @Override
    @Nonnull
    public ResourceHistoryTablePk getId() {
        if (this.myId == null) {
            this.myId = new ResourceHistoryTablePk();
        }
        return this.myId;
    }

    public ResourceHistoryTablePk getMyId() {
        return this.getId();
    }

    public void setMyId(ResourceHistoryTablePk theId) {
        this.myId = theId;
    }

    public byte[] getResource() {
        return this.myResource;
    }

    public void setResource(byte[] theResource) {
        this.myResource = theResource;
    }

    @Override
    public JpaPid getResourceId() {
        this.initializeResourceId();
        JpaPid retVal = this.myResourcePid.toJpaPid();
        retVal.setVersion(this.myResourceVersion);
        retVal.setResourceType(this.myResourceType);
        if (retVal.getPartitionId() == null) {
            retVal.setPartitionId(this.myPartitionIdValue);
        }
        return retVal;
    }

    private void initializeResourceId() {
        if (this.myResourcePid == null) {
            this.myResourcePid = new JpaPidFk();
        }
    }

    public void setResourceId(Long theResourceId) {
        this.initializeResourceId();
        this.myResourcePid.setId(theResourceId);
    }

    @Override
    public String getResourceType() {
        return this.myResourceType;
    }

    @Override
    public String getFhirId() {
        return this.getIdDt().getIdPart();
    }

    public void setResourceType(String theResourceType) {
        this.myResourceType = theResourceType;
    }

    @Override
    public Collection<ResourceHistoryTag> getTags() {
        if (this.myTags == null) {
            this.myTags = new ArrayList<ResourceHistoryTag>();
        }
        return this.myTags;
    }

    @Override
    public long getVersion() {
        return this.myResourceVersion;
    }

    public void setVersion(long theVersion) {
        this.myResourceVersion = theVersion;
    }

    @Override
    public boolean isDeleted() {
        return this.getDeleted() != null;
    }

    @Override
    public void setNotDeleted() {
        this.setDeleted(null);
    }

    @Override
    public JpaPid getPersistentId() {
        return this.getResourceId();
    }

    public ResourceTable getResourceTable() {
        return this.myResourceTable;
    }

    public void setResourceTable(ResourceTable theResourceTable) {
        this.myResourceTable = theResourceTable;
    }

    @Override
    public IdDt getIdDt() {
        String resourceIdPart = this.getTransientForcedId() != null ? this.getTransientForcedId() : this.getResourceTable().getFhirId();
        return new IdDt(this.getResourceType() + "/" + resourceIdPart + "/_history/" + this.getVersion());
    }

    public boolean hasResource() {
        return this.myResource != null || this.myResourceTextVc != null;
    }

    public ResourceHistoryProvenanceEntity toProvenance() {
        if (this.myNewHistoryProvenanceEntity == null) {
            this.myNewHistoryProvenanceEntity = new ResourceHistoryProvenanceEntity();
        }
        return this.myNewHistoryProvenanceEntity;
    }

    public String getTransientForcedId() {
        return this.myTransientForcedId;
    }

    public void setTransientForcedId(String theTransientForcedId) {
        assert (theTransientForcedId == null || !theTransientForcedId.contains("/")) : "Invalid FHIR ID: " + theTransientForcedId;
        this.myTransientForcedId = theTransientForcedId;
    }

    public void setPartitionId(PartitionablePartitionId thePartitionablePartitionId) {
        if (thePartitionablePartitionId != null) {
            this.getId().setPartitionIdValue(thePartitionablePartitionId.getPartitionId());
            this.initializeResourceId();
            this.myResourcePid.setPartitionId(thePartitionablePartitionId.getPartitionId());
            this.myPartitionIdValue = thePartitionablePartitionId.getPartitionId();
            this.myPartitionDateValue = thePartitionablePartitionId.getPartitionDate();
        } else {
            this.getId().setPartitionIdValue(null);
            this.initializeResourceId();
            this.myResourcePid.setPartitionId(null);
            this.myPartitionIdValue = null;
            this.myPartitionDateValue = null;
        }
    }
}

