/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.entity;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.jpa.model.entity.NpmPackageVersionEntity;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Version;
import java.util.Date;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.annotations.JdbcTypeCode;

@Entity
@Table(name="NPM_PACKAGE_VER_RES", indexes={@Index(name="IDX_PACKVERRES_URL", columnList="CANONICAL_URL"), @Index(name="FK_NPM_PACKVERRES_PACKVER", columnList="PACKVER_PID"), @Index(name="FK_NPM_PKVR_RESID", columnList="BINARY_RES_ID")})
public class NpmPackageVersionResourceEntity {
    @Id
    @SequenceGenerator(name="SEQ_NPM_PACKVERRES", sequenceName="SEQ_NPM_PACKVERRES")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_NPM_PACKVERRES")
    @Column(name="PID")
    private Long myId;
    @ManyToOne
    @JoinColumn(name="PACKVER_PID", referencedColumnName="PID", foreignKey=@ForeignKey(name="FK_NPM_PACKVERRES_PACKVER"), nullable=false)
    private NpmPackageVersionEntity myPackageVersion;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="BINARY_RES_ID", referencedColumnName="RES_ID", nullable=false, insertable=false, updatable=false), @JoinColumn(name="PARTITION_ID", referencedColumnName="PARTITION_ID", nullable=false, insertable=false, updatable=false)}, foreignKey=@ForeignKey(name="FK_NPM_PKVR_RESID"))
    private ResourceTable myResourceBinary;
    @Column(name="BINARY_RES_ID", nullable=false)
    private Long myResourcePid;
    @Column(name="PARTITION_ID", nullable=true)
    private Integer myPartitionId;
    @Column(name="FILE_DIR", length=200)
    private String myDirectory;
    @Column(name="FILE_NAME", length=200)
    private String myFilename;
    @Column(name="RES_TYPE", length=40, nullable=false)
    private String myResourceType;
    @Column(name="CANONICAL_URL", length=200)
    private String myCanonicalUrl;
    @Column(name="CANONICAL_VERSION", length=200)
    private String myCanonicalVersion;
    @Enumerated(value=EnumType.STRING)
    @JdbcTypeCode(value=12)
    @Column(name="FHIR_VERSION", length=10, nullable=false)
    private FhirVersionEnum myFhirVersion;
    @Column(name="FHIR_VERSION_ID", length=20, nullable=false)
    private String myFhirVersionId;
    @Column(name="RES_SIZE_BYTES", nullable=false)
    private long myResSizeBytes;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Version
    @Column(name="UPDATED_TIME", nullable=false)
    private Date myVersion;

    public long getResSizeBytes() {
        return this.myResSizeBytes;
    }

    public void setResSizeBytes(long theResSizeBytes) {
        this.myResSizeBytes = theResSizeBytes;
    }

    public String getCanonicalVersion() {
        return this.myCanonicalVersion;
    }

    public void setCanonicalVersion(String theCanonicalVersion) {
        this.myCanonicalVersion = theCanonicalVersion;
    }

    public ResourceTable getResourceBinary() {
        return this.myResourceBinary;
    }

    public void setResourceBinary(ResourceTable theResourceBinary) {
        this.myResourceBinary = theResourceBinary;
        this.myResourcePid = theResourceBinary.getId().getId();
        this.myPartitionId = theResourceBinary.getPersistentId().getPartitionId();
    }

    public String getFhirVersionId() {
        return this.myFhirVersionId;
    }

    public void setFhirVersionId(String theFhirVersionId) {
        this.myFhirVersionId = theFhirVersionId;
    }

    public FhirVersionEnum getFhirVersion() {
        return this.myFhirVersion;
    }

    public void setFhirVersion(FhirVersionEnum theFhirVersion) {
        this.myFhirVersion = theFhirVersion;
    }

    public void setPackageVersion(NpmPackageVersionEntity thePackageVersion) {
        this.myPackageVersion = thePackageVersion;
    }

    public String getDirectory() {
        return this.myDirectory;
    }

    public void setDirectory(String theDirectory) {
        this.myDirectory = theDirectory;
    }

    public String getFilename() {
        return this.myFilename;
    }

    public void setFilename(String theFilename) {
        this.myFilename = theFilename;
    }

    public String getResourceType() {
        return this.myResourceType;
    }

    public void setResourceType(String theResourceType) {
        this.myResourceType = theResourceType;
    }

    public String getCanonicalUrl() {
        return this.myCanonicalUrl;
    }

    public void setCanonicalUrl(String theCanonicalUrl) {
        this.myCanonicalUrl = theCanonicalUrl;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("myId", (Object)this.myId).append("myCanonicalUrl", (Object)this.myCanonicalUrl).append("myCanonicalVersion", (Object)this.myCanonicalVersion).append("myResourceType", (Object)this.myResourceType).append("myDirectory", (Object)this.myDirectory).append("myFilename", (Object)this.myFilename).append("myPackageVersion", (Object)this.myPackageVersion).append("myResSizeBytes", this.myResSizeBytes).append("myVersion", (Object)this.myVersion).toString();
    }
}

