/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.dao;

import ca.uhn.fhir.jpa.model.dao.JpaPid;
import ca.uhn.hapi.fhir.sql.hibernatesvc.PartitionedIdProperty;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Embeddable
public class JpaPidFk
implements Serializable {
    @Column(name="RES_ID", nullable=false)
    private Long myId;
    @PartitionedIdProperty
    @Column(name="PARTITION_ID", nullable=false)
    private Integer myPartitionIdValue;

    public boolean equals(Object theO) {
        if (this == theO) {
            return true;
        }
        if (!(theO instanceof JpaPidFk)) {
            return false;
        }
        JpaPidFk jpaPid = (JpaPidFk)theO;
        return Objects.equals(this.myId, jpaPid.myId) && Objects.equals(this.myPartitionIdValue, jpaPid.myPartitionIdValue);
    }

    public int hashCode() {
        return Objects.hash(this.myId, this.myPartitionIdValue);
    }

    public JpaPid toJpaPid() {
        return JpaPid.fromId(this.myId, this.myPartitionIdValue);
    }

    public void setId(Long theId) {
        this.myId = theId;
    }

    public void setPartitionId(Integer thePartitionId) {
        this.myPartitionIdValue = thePartitionId;
    }

    public static List<JpaPidFk> fromPids(List<JpaPid> thePids) {
        return thePids.stream().map(JpaPidFk::fromPid).collect(Collectors.toList());
    }

    public static JpaPidFk fromPid(JpaPid thePid) {
        JpaPidFk retVal = new JpaPidFk();
        retVal.setId(thePid.getId());
        retVal.setPartitionId(thePid.getPartitionId());
        return retVal;
    }

    public static JpaPidFk fromId(Long theId, Integer thePartitionId) {
        JpaPidFk retVal = new JpaPidFk();
        retVal.setId(theId);
        retVal.setPartitionId(thePartitionId);
        return retVal;
    }

    public static JpaPidFk fromId(Long theId) {
        return JpaPidFk.fromId(theId, null);
    }
}

