/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.sched;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.model.sched.IHapiScheduler;
import ca.uhn.fhir.jpa.model.sched.IHasScheduledJobs;
import ca.uhn.fhir.jpa.model.sched.ISchedulerService;
import ca.uhn.fhir.jpa.model.sched.ScheduledJobDefinition;
import ca.uhn.fhir.jpa.sched.AutowiringSpringBeanJobFactory;
import ca.uhn.fhir.jpa.sched.HapiNullScheduler;
import ca.uhn.fhir.util.StopWatch;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.quartz.JobKey;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.env.Environment;

public abstract class BaseSchedulerServiceImpl
implements ISchedulerService {
    public static final String SCHEDULING_DISABLED = "scheduling_disabled";
    public static final String SCHEDULING_DISABLED_EQUALS_TRUE = "scheduling_disabled=true";
    private static final Logger ourLog = LoggerFactory.getLogger(BaseSchedulerServiceImpl.class);
    private IHapiScheduler myLocalScheduler;
    private IHapiScheduler myClusteredScheduler;
    private boolean myLocalSchedulingEnabled;
    private boolean myClusteredSchedulingEnabled;
    private AtomicBoolean myStopping = new AtomicBoolean(false);
    private String myDefaultGroup;
    @Autowired
    private Environment myEnvironment;
    @Autowired
    private ApplicationContext myApplicationContext;
    @Autowired
    protected AutowiringSpringBeanJobFactory mySchedulerJobFactory;

    public BaseSchedulerServiceImpl() {
        this.setLocalSchedulingEnabled(true);
        this.setClusteredSchedulingEnabled(true);
    }

    public BaseSchedulerServiceImpl setDefaultGroup(String theDefaultGroup) {
        this.myDefaultGroup = theDefaultGroup;
        return this;
    }

    public boolean isLocalSchedulingEnabled() {
        return this.myLocalSchedulingEnabled;
    }

    public void setLocalSchedulingEnabled(boolean theLocalSchedulingEnabled) {
        this.myLocalSchedulingEnabled = theLocalSchedulingEnabled;
    }

    @Override
    public boolean isClusteredSchedulingEnabled() {
        return this.myClusteredSchedulingEnabled;
    }

    public void setClusteredSchedulingEnabled(boolean theClusteredSchedulingEnabled) {
        this.myClusteredSchedulingEnabled = theClusteredSchedulingEnabled;
    }

    @PostConstruct
    public void create() throws SchedulerException {
        this.myLocalScheduler = this.createScheduler(false);
        this.myClusteredScheduler = this.createScheduler(true);
        if (this.isSchedulingDisabled()) {
            this.setLocalSchedulingEnabled(false);
            this.setClusteredSchedulingEnabled(false);
        }
        this.myStopping.set(false);
    }

    private IHapiScheduler createScheduler(boolean theClustered) throws SchedulerException {
        IHapiScheduler retval;
        if (this.isSchedulingDisabled()) {
            ourLog.info("Scheduling is disabled on this server");
            return new HapiNullScheduler();
        }
        if (theClustered) {
            ourLog.info("Creating Clustered Scheduler");
            retval = this.getClusteredScheduler();
        } else {
            ourLog.info("Creating Local Scheduler");
            retval = this.getLocalHapiScheduler();
        }
        retval.init();
        return retval;
    }

    @Override
    public boolean isSchedulingDisabled() {
        return !this.isLocalSchedulingEnabled() || this.isSchedulingDisabledForUnitTests();
    }

    protected abstract IHapiScheduler getLocalHapiScheduler();

    protected abstract IHapiScheduler getClusteredScheduler();

    @EventListener(value={ContextRefreshedEvent.class})
    public void start() {
        this.myStopping.set(false);
        if (this.isSchedulingDisabled()) {
            return;
        }
        this.scheduleJobs();
        try {
            ourLog.info("Starting task schedulers for context {}", (Object)this.myApplicationContext.getId());
            if (this.myLocalScheduler != null) {
                this.myLocalScheduler.start();
            }
            if (this.myClusteredScheduler != null) {
                this.myClusteredScheduler.start();
            }
        }
        catch (Exception e) {
            ourLog.error("Failed to start scheduler", (Throwable)e);
            throw new ConfigurationException(Msg.code((int)1632) + "Failed to start scheduler", (Throwable)e);
        }
    }

    private void scheduleJobs() {
        Collection values = this.myApplicationContext.getBeansOfType(IHasScheduledJobs.class).values();
        ourLog.info("Scheduling {} jobs in {}", (Object)values.size(), (Object)this.myApplicationContext.getId());
        values.forEach(t -> t.scheduleJobs(this));
    }

    @PreDestroy
    public void stop() {
        ourLog.info("Shutting down task scheduler...");
        this.myStopping.set(true);
        this.myLocalScheduler.shutdown();
        this.myClusteredScheduler.shutdown();
    }

    @Override
    public void purgeAllScheduledJobsForUnitTest() throws SchedulerException {
        this.myLocalScheduler.clear();
        this.myClusteredScheduler.clear();
    }

    @Override
    public void logStatusForUnitTest() {
        this.myLocalScheduler.logStatusForUnitTest();
        this.myClusteredScheduler.logStatusForUnitTest();
    }

    @Override
    public void pause() {
        this.myLocalScheduler.pause();
        this.myClusteredScheduler.pause();
    }

    @Override
    public void unpause() {
        this.myLocalScheduler.unpause();
        this.myClusteredScheduler.unpause();
    }

    @Override
    public void scheduleLocalJob(long theIntervalMillis, ScheduledJobDefinition theJobDefinition) {
        this.scheduleJob("local", this.myLocalScheduler, theIntervalMillis, theJobDefinition);
    }

    @Override
    public void scheduleClusteredJob(long theIntervalMillis, ScheduledJobDefinition theJobDefinition) {
        this.scheduleJob("clustered", this.myClusteredScheduler, theIntervalMillis, theJobDefinition);
    }

    private void scheduleJob(String theInstanceName, IHapiScheduler theScheduler, long theIntervalMillis, ScheduledJobDefinition theJobDefinition) {
        if (this.isSchedulingDisabled()) {
            return;
        }
        assert (theJobDefinition.getId() != null);
        assert (theJobDefinition.getJobClass() != null);
        ourLog.info("Scheduling {} job {} with interval {}", new Object[]{theInstanceName, theJobDefinition.getId(), StopWatch.formatMillis((long)theIntervalMillis)});
        this.defaultGroup(theJobDefinition);
        theScheduler.scheduleJob(theIntervalMillis, theJobDefinition);
    }

    @Override
    @VisibleForTesting
    public Set<JobKey> getLocalJobKeysForUnitTest() throws SchedulerException {
        return this.myLocalScheduler.getJobKeysForUnitTest();
    }

    @Override
    @VisibleForTesting
    public Set<JobKey> getClusteredJobKeysForUnitTest() throws SchedulerException {
        return this.myClusteredScheduler.getJobKeysForUnitTest();
    }

    private boolean isSchedulingDisabledForUnitTests() {
        String schedulingDisabled = this.myEnvironment.getProperty(SCHEDULING_DISABLED);
        return "true".equals(schedulingDisabled);
    }

    @Override
    public boolean isStopping() {
        return this.myStopping.get();
    }

    @Override
    public void triggerClusteredJobImmediately(ScheduledJobDefinition theJobDefinition) {
        this.defaultGroup(theJobDefinition);
        this.myClusteredScheduler.triggerJobImmediately(theJobDefinition);
    }

    @Override
    public void triggerLocalJobImmediately(ScheduledJobDefinition theJobDefinition) {
        this.defaultGroup(theJobDefinition);
        this.myLocalScheduler.triggerJobImmediately(theJobDefinition);
    }

    private void defaultGroup(ScheduledJobDefinition theJobDefinition) {
        if (theJobDefinition.getGroup() == null) {
            theJobDefinition.setGroup(this.myDefaultGroup);
        }
    }
}

