/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.nickname;

import jakarta.annotation.Nonnull;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class NicknameMap {
    private final Map<String, List<String>> myFormalToNick = new HashMap<String, List<String>>();
    private final Map<String, List<String>> myNicknameToFormal = new HashMap<String, List<String>>();
    private final List<String> myBadRows = new ArrayList<String>();

    NicknameMap() {
    }

    void load(Reader theReader) throws IOException {
        try (BufferedReader reader = new BufferedReader(theReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] parts = line.split(",");
                if (parts.length > 1) {
                    String key = parts[0];
                    ArrayList<String> values = new ArrayList<String>(Arrays.asList(parts).subList(1, parts.length));
                    this.add(key, values);
                    continue;
                }
                this.myBadRows.add(line);
            }
        }
    }

    void clear() {
        this.myFormalToNick.clear();
        this.myNicknameToFormal.clear();
    }

    void add(String theKey, List<String> theValues) {
        this.myFormalToNick.put(theKey, theValues);
        for (String value : theValues) {
            this.myNicknameToFormal.putIfAbsent(value, new ArrayList());
            this.myNicknameToFormal.get(value).add(theKey);
        }
    }

    int size() {
        return this.myFormalToNick.size();
    }

    boolean isEmpty() {
        return this.size() == 0;
    }

    List<String> getBadRows() {
        return this.myBadRows;
    }

    @Nonnull
    public List<String> getNicknamesFromFormalName(String theName) {
        ArrayList result = this.myFormalToNick.get(theName);
        return result == null ? new ArrayList() : result;
    }

    @Nonnull
    public List<String> getFormalNamesFromNickname(String theNickname) {
        ArrayList result = this.myNicknameToFormal.get(theNickname);
        return result == null ? new ArrayList() : result;
    }
}

