/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.logging;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.logging.BaseSqlLoggerFilterImpl;
import ca.uhn.fhir.jpa.logging.ISqlLoggerFilter;
import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlLoggerStackTraceFilter
extends BaseSqlLoggerFilterImpl
implements ISqlLoggerFilter {
    private static final Logger ourLog = LoggerFactory.getLogger(SqlLoggerStackTraceFilter.class);
    public static final String PREFIX = "stack:";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean match(String theStatement) {
        boolean matched;
        LinkedList filterDefinitionsSafeCopy;
        List list = this.myFilterDefinitions;
        synchronized (list) {
            filterDefinitionsSafeCopy = new LinkedList(this.myFilterDefinitions);
        }
        Set cdrClassesInStack = this.getStackTraceStream().map(StackTraceElement::getClassName).collect(Collectors.toSet());
        if (cdrClassesInStack.isEmpty()) {
            ourLog.trace("No CDR or HAPI-FHIR class found in stack");
            return false;
        }
        try {
            matched = cdrClassesInStack.stream().anyMatch(clName -> filterDefinitionsSafeCopy.stream().filter(Objects::nonNull).anyMatch(clName::startsWith));
        }
        catch (Exception theE) {
            ourLog.debug("myFilterDefinitions: {}", (Object)filterDefinitionsSafeCopy.stream().map(String::valueOf).collect(Collectors.joining("\n", "\n", "")));
            ourLog.debug("cdrClassesInStack: {}", (Object)cdrClassesInStack.stream().map(String::valueOf).collect(Collectors.joining("\n", "\n", "")));
            throw new RuntimeException(Msg.code((int)2479) + String.valueOf(theE));
        }
        return matched;
    }

    @VisibleForTesting
    public Stream<StackTraceElement> getStackTraceStream() {
        return Arrays.stream(Thread.currentThread().getStackTrace());
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }
}

