/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.logging;

import ca.uhn.fhir.jpa.logging.ISqlLoggerFilter;
import com.google.common.annotations.VisibleForTesting;
import java.util.LinkedList;
import java.util.List;

public abstract class BaseSqlLoggerFilterImpl
implements ISqlLoggerFilter {
    protected final List<String> myFilterDefinitions = new LinkedList<String>();

    @Override
    public boolean evaluateFilterLine(String theFilterLine) {
        boolean matched = theFilterLine.startsWith(this.getPrefix());
        if (matched) {
            this.myFilterDefinitions.add(theFilterLine.substring(this.getPrefix().length()).trim());
        }
        return matched;
    }

    @Override
    public void clearDefinitions() {
        this.myFilterDefinitions.clear();
    }

    @Override
    public Object getLockingObject() {
        return this.myFilterDefinitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void setFilterDefinitions(List<String> theFilterDefinitions) {
        List<String> list = this.myFilterDefinitions;
        synchronized (list) {
            this.myFilterDefinitions.clear();
            this.myFilterDefinitions.addAll(theFilterDefinitions);
        }
    }
}

