/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.config;

import ca.uhn.hapi.fhir.sql.hibernatesvc.DatabasePartitionModeIdFilteringMappingContributor;
import com.google.common.base.Strings;
import jakarta.annotation.Nonnull;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.spi.PersistenceUnitInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.AdditionalMappingContributor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.id.SequenceMismatchStrategy;
import org.hibernate.query.criteria.ValueHandlingMode;
import org.hibernate.resource.jdbc.spi.PhysicalConnectionHandlingMode;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.orm.hibernate5.SpringBeanContainer;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;

public class HapiFhirLocalContainerEntityManagerFactoryBean
extends LocalContainerEntityManagerFactoryBean {
    ConfigurableListableBeanFactory myConfigurableListableBeanFactory;

    public HapiFhirLocalContainerEntityManagerFactoryBean(ConfigurableListableBeanFactory theConfigurableListableBeanFactory) {
        this.myConfigurableListableBeanFactory = theConfigurableListableBeanFactory;
    }

    @Nonnull
    public Map<String, Object> getJpaPropertyMap() {
        Map retVal = super.getJpaPropertyMap();
        retVal.putIfAbsent("hibernate.criteria.value_handling_mode", ValueHandlingMode.BIND);
        retVal.putIfAbsent("hibernate.connection.handling_mode", PhysicalConnectionHandlingMode.DELAYED_ACQUISITION_AND_RELEASE_AFTER_TRANSACTION);
        retVal.putIfAbsent("hibernate.id.sequence.increment_size_mismatch_strategy", SequenceMismatchStrategy.FIX);
        retVal.putIfAbsent("hibernate.jdbc.batch_size", "30");
        retVal.putIfAbsent("hibernate.order_inserts", "true");
        retVal.putIfAbsent("hibernate.order_updates", "true");
        retVal.putIfAbsent("hibernate.jdbc.batch_versioned_data", "true");
        retVal.putIfAbsent("hibernate.resource.beans.container", new SpringBeanContainer(this.myConfigurableListableBeanFactory));
        return retVal;
    }

    void addHibernateHook(String thePropertyName, String theHookFQCN) {
        Map retVal = super.getJpaPropertyMap();
        ArrayList<String> listeners = new ArrayList<String>();
        String currentListeners = (String)retVal.get(thePropertyName);
        if (!Strings.isNullOrEmpty((String)currentListeners)) {
            listeners.addAll(Arrays.asList(currentListeners.split(",")));
        }
        if (!listeners.contains(theHookFQCN)) {
            listeners.add(theHookFQCN);
            retVal.put(thePropertyName, String.join((CharSequence)",", listeners));
        }
    }

    protected void postProcessEntityManagerFactory(EntityManagerFactory theEntityManagerFactory, PersistenceUnitInfo thePersistenceUnitInfo) {
        super.postProcessEntityManagerFactory(theEntityManagerFactory, thePersistenceUnitInfo);
        SessionFactoryImplementor sessionFactory = (SessionFactoryImplementor)theEntityManagerFactory;
        ClassLoaderService classLoaderService = (ClassLoaderService)sessionFactory.getServiceRegistry().getService(ClassLoaderService.class);
        Validate.notNull((Object)classLoaderService, (String)"No classloader service available", (Object[])new Object[0]);
        Collection additionalMappingContributors = classLoaderService.loadJavaServices(AdditionalMappingContributor.class);
        boolean haveConditionalMappingContributor = additionalMappingContributors.stream().anyMatch(t -> t instanceof DatabasePartitionModeIdFilteringMappingContributor);
        Validate.isTrue((boolean)haveConditionalMappingContributor, (String)("No " + DatabasePartitionModeIdFilteringMappingContributor.class.getSimpleName() + " found registered with Hibernate. Verify that hapi-fhir-jpa-hibernate-services is on your classpath. Can not start."), (Object[])new Object[0]);
    }
}

