/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.nickname;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.nickname.INicknameSvc;
import ca.uhn.fhir.jpa.nickname.NicknameMap;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class NicknameSvc
implements INicknameSvc {
    private static final Logger ourLog = LoggerFactory.getLogger(NicknameSvc.class);
    private NicknameMap myNicknameMap;
    private Resource myNicknameResource;

    @Override
    public void setNicknameResource(Resource theNicknameResource) {
        this.myNicknameResource = theNicknameResource;
    }

    @Override
    public int size() {
        this.ensureMapInitialized();
        return this.myNicknameMap.size();
    }

    @Override
    public List<String> getBadRows() {
        this.ensureMapInitialized();
        return this.myNicknameMap.getBadRows();
    }

    @Override
    public Collection<String> getEquivalentNames(String theName) {
        HashSet<String> retval = new HashSet<String>(this.getNicknamesFromFormalName(theName));
        if (retval.isEmpty()) {
            List<String> formalNames = this.getFormalNamesFromNickname(theName);
            retval.addAll(formalNames);
            for (String formalName : formalNames) {
                retval.addAll(this.getNicknamesFromFormalName(formalName));
            }
        }
        retval.add(theName);
        return retval;
    }

    @Nonnull
    List<String> getNicknamesFromFormalName(String theName) {
        this.ensureMapInitialized();
        return this.myNicknameMap.getNicknamesFromFormalName(theName);
    }

    @Nonnull
    List<String> getFormalNamesFromNickname(String theNickname) {
        this.ensureMapInitialized();
        return this.myNicknameMap.getFormalNamesFromNickname(theNickname);
    }

    private void ensureMapInitialized() {
        if (this.myNicknameResource == null) {
            ourLog.debug("Loading defaults");
            this.myNicknameResource = new ClassPathResource("/nickname/names.csv");
        }
        if (this.myNicknameMap == null) {
            this.myNicknameMap = new NicknameMap();
        }
        if (this.myNicknameMap.isEmpty()) {
            try (InputStream inputStream = this.myNicknameResource.getInputStream();
                 InputStreamReader reader = new InputStreamReader(inputStream);){
                this.myNicknameMap.load(reader);
            }
            catch (IOException e) {
                throw new ConfigurationException(Msg.code((int)2234) + "Unable to load nicknames", (Throwable)e);
            }
        }
    }
}

