/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.model.sched;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.quartz.Job;
import org.quartz.JobKey;
import org.quartz.TriggerKey;

public class ScheduledJobDefinition {
    private Class<? extends Job> myJobClass;
    private String myId;
    private String myGroup;
    private Map<String, String> myJobData;

    public Map<String, String> getJobData() {
        Map<String, String> retVal = this.myJobData;
        if (retVal == null) {
            retVal = Collections.emptyMap();
        }
        return Collections.unmodifiableMap(retVal);
    }

    public Class<? extends Job> getJobClass() {
        return this.myJobClass;
    }

    public ScheduledJobDefinition setJobClass(Class<? extends Job> theJobClass) {
        this.myJobClass = theJobClass;
        return this;
    }

    public String getId() {
        return this.myId;
    }

    public ScheduledJobDefinition setId(String theId) {
        this.myId = theId;
        return this;
    }

    public String getGroup() {
        return this.myGroup;
    }

    public ScheduledJobDefinition setGroup(String theGroup) {
        this.myGroup = theGroup;
        return this;
    }

    public void addJobData(String thePropertyName, String thePropertyValue) {
        Validate.notBlank((CharSequence)thePropertyName);
        if (this.myJobData == null) {
            this.myJobData = new HashMap<String, String>();
        }
        Validate.isTrue((!this.myJobData.containsKey(thePropertyName) ? 1 : 0) != 0);
        this.myJobData.put(thePropertyName, thePropertyValue);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("myJobClass", this.myJobClass).append("myId", (Object)this.myId).append("myGroup", (Object)this.myGroup).toString();
    }

    public JobKey toJobKey() {
        return new JobKey(this.getId(), this.getGroup());
    }

    public TriggerKey toTriggerKey() {
        return new TriggerKey(this.getId(), this.getGroup());
    }
}

