/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.logging;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.logging.ISqlLoggerFilter;
import ca.uhn.fhir.jpa.logging.SqlLoggerFragmentFilter;
import ca.uhn.fhir.jpa.logging.SqlLoggerStackTraceFilter;
import ca.uhn.fhir.jpa.logging.SqlLoggerStartsWithFilter;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public class SqlLoggerFilteringUtil {
    private static final Logger ourLog = LoggerFactory.getLogger(SqlLoggerFilteringUtil.class);
    public static int FILTER_UPDATE_INTERVAL_SECS = 5;
    public static final String FILTER_FILE_PATH = "hibernate-sql-log-filters.txt";
    private static final AtomicInteger ourRefreshCount = new AtomicInteger();
    private final Logger hibernateLogger = LoggerFactory.getLogger((String)"org.hibernate.SQL");
    private final List<ISqlLoggerFilter> mySqlLoggerFilters;
    private CountDownLatch myRefreshDoneLatch;
    private volatile ScheduledThreadPoolExecutor myRefreshExecutor;
    private static final SqlLoggerFilteringUtil myInstance = new SqlLoggerFilteringUtil();

    public static SqlLoggerFilteringUtil getInstance() {
        return myInstance;
    }

    private SqlLoggerFilteringUtil() {
        ourRefreshCount.set(0);
        this.mySqlLoggerFilters = List.of(new SqlLoggerStartsWithFilter(), new SqlLoggerFragmentFilter(), new SqlLoggerStackTraceFilter());
    }

    public boolean allowLog(String theStatement) {
        boolean allowLog;
        if (this.myRefreshExecutor == null || this.myRefreshExecutor.isShutdown()) {
            this.startFilterRefreshExecutor();
        }
        ourLog.trace("SQL log {}: {}", (Object)((allowLog = this.isStatementAllowed(theStatement)) ? "allowed" : "filtered out"), (Object)theStatement);
        return allowLog;
    }

    private boolean isStatementAllowed(String theStatement) {
        return this.mySqlLoggerFilters.stream().noneMatch(f -> f.match(theStatement));
    }

    private synchronized void startFilterRefreshExecutor() {
        if (this.myRefreshExecutor != null && !this.myRefreshExecutor.isShutdown()) {
            ourLog.debug("myRefreshExecutor terminated state: {}, terminating state: {}", (Object)this.myRefreshExecutor.isTerminated(), (Object)this.myRefreshExecutor.isTerminating());
            return;
        }
        this.myRefreshDoneLatch = new CountDownLatch(1);
        this.myRefreshExecutor = new ScheduledThreadPoolExecutor(1);
        this.myRefreshExecutor.scheduleAtFixedRate(new UpdateFiltersTask(), 0L, FILTER_UPDATE_INTERVAL_SECS, TimeUnit.SECONDS);
        ourLog.info("Starting SQL log filters refresh executor");
        try {
            this.myRefreshDoneLatch.await();
        }
        catch (InterruptedException ignored) {
            ourLog.warn("Interrupted from sleep");
        }
    }

    private synchronized void stopFilterRefreshExecutor() {
        if (this.myRefreshExecutor == null || this.myRefreshExecutor.isShutdown()) {
            return;
        }
        ourLog.info("Stopping SQL log filters refresh executor");
        this.myRefreshExecutor.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void refreshFilters(String theFilterFilePath) throws IOException {
        ourLog.debug("SQL log DEBUG enabled: {}", (Object)this.hibernateLogger.isDebugEnabled());
        if (!this.hibernateLogger.isDebugEnabled()) {
            this.myRefreshDoneLatch.countDown();
            this.stopFilterRefreshExecutor();
            return;
        }
        ourLog.debug("Starting filters refresh");
        File resource = new ClassPathResource(theFilterFilePath).getFile();
        List<String> filterDefinitionLines = Files.readAllLines(resource.toPath());
        for (ISqlLoggerFilter filter : this.mySqlLoggerFilters) {
            Object object = filter.getLockingObject();
            synchronized (object) {
                filter.clearDefinitions();
                filterDefinitionLines.stream().filter(l -> !l.startsWith("#")).filter(filterDef -> StringUtils.isNotBlank((CharSequence)filterDef.trim())).forEach(filterLine -> this.presentFilterDefinitionLineToFilters((String)filterLine, this.mySqlLoggerFilters));
            }
        }
        ourLog.debug("Ended filter refresh");
    }

    private void presentFilterDefinitionLineToFilters(String theFilterLine, List<ISqlLoggerFilter> theFilterList) {
        for (ISqlLoggerFilter filterRef : theFilterList) {
            if (!filterRef.evaluateFilterLine(theFilterLine)) continue;
            return;
        }
        int spaceIdx = theFilterLine.indexOf(" ");
        ourLog.warn("SQL log filtering line prefix not recognized: '{}'. Must be one of: '#', {}", (Object)theFilterLine.substring(0, spaceIdx == -1 ? theFilterLine.length() : spaceIdx), (Object)theFilterList.stream().map(ISqlLoggerFilter::getPrefix).collect(Collectors.joining("', '", "'", "'")));
    }

    @VisibleForTesting
    public static int getRefreshCountForTests() {
        return ourRefreshCount.get();
    }

    @VisibleForTesting
    public static void setFilterUpdateIntervalSecs(int theFilterUpdateIntervalSecs) {
        FILTER_UPDATE_INTERVAL_SECS = theFilterUpdateIntervalSecs;
    }

    @VisibleForTesting
    public List<ISqlLoggerFilter> getSqlLoggerFilters() {
        return this.mySqlLoggerFilters;
    }

    private class UpdateFiltersTask
    implements Runnable {
        private UpdateFiltersTask() {
        }

        @Override
        public void run() {
            ourLog.debug("\n\n\t\t\tRefreshing hibernate SQL filters!\n");
            try {
                SqlLoggerFilteringUtil.this.refreshFilters(SqlLoggerFilteringUtil.FILTER_FILE_PATH);
            }
            catch (Exception theE) {
                ourLog.error("Hibernate SQL log filters not refreshed. Exception: {} \n{}", (Object)theE, (Object)theE.getStackTrace());
                throw new RuntimeException(Msg.code((int)2478) + String.valueOf(theE));
            }
            finally {
                SqlLoggerFilteringUtil.this.myRefreshDoneLatch.countDown();
            }
            int count = ourRefreshCount.getAndIncrement();
            ourLog.debug("SQL logging filters {}. Refresh count: {}", (Object)(count == 0 ? "initialized" : "refreshed"), (Object)count);
        }
    }
}

