/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hapi.fhir.sql.hibernatesvc;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.hapi.fhir.sql.hibernatesvc.HapiHibernateDialectSettingsService;
import ca.uhn.hapi.fhir.sql.hibernatesvc.PartitionedIdProperty;
import ca.uhn.hapi.fhir.sql.hibernatesvc.PartitionedIndex;
import ca.uhn.hapi.fhir.sql.hibernatesvc.PartitionedIndexes;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.Column;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hibernate.boot.ResourceStreamLocator;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.AdditionalMappingContributions;
import org.hibernate.boot.spi.AdditionalMappingContributor;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.internal.util.collections.IdentitySet;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.mapping.Value;
import org.hibernate.service.UnknownServiceException;
import org.hibernate.type.ComponentType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EmbeddedComponentType;

public class DatabasePartitionModeIdFilteringMappingContributor
implements AdditionalMappingContributor {
    private final Set<TableAndColumnName> myQualifiedIdRemovedColumnNames = new HashSet<TableAndColumnName>();

    public String getContributorName() {
        return this.getClass().getSimpleName();
    }

    public void contribute(AdditionalMappingContributions theContributions, InFlightMetadataCollector theMetadata, ResourceStreamLocator theResourceStreamLocator, MetadataBuildingContext theBuildingContext) {
        HapiHibernateDialectSettingsService hapiSettingsSvc;
        StandardServiceRegistry serviceRegistry = theMetadata.getBootstrapContext().getServiceRegistry();
        try {
            hapiSettingsSvc = (HapiHibernateDialectSettingsService)serviceRegistry.getService(HapiHibernateDialectSettingsService.class);
        }
        catch (UnknownServiceException e) {
            return;
        }
        if (hapiSettingsSvc == null) {
            throw new ConfigurationException(Msg.code((int)2601) + HapiHibernateDialectSettingsService.class.getSimpleName() + " was not found in the service registry. The Hibernate EntityManager for HAPI FHIR must be constructed using HapiEntityManagerFactoryUtil.");
        }
        if (hapiSettingsSvc.isDatabasePartitionMode()) {
            return;
        }
        ClassLoaderService classLoaderService = (ClassLoaderService)serviceRegistry.getService(ClassLoaderService.class);
        this.removePartitionedIdColumnsFromMetadata(classLoaderService, theMetadata);
        DatabasePartitionModeIdFilteringMappingContributor.removeColumnsFromIndexes(theMetadata, classLoaderService);
    }

    private void removePartitionedIdColumnsFromMetadata(ClassLoaderService theClassLoaderService, InFlightMetadataCollector theMetadata) {
        PersistentClass entityPersistentClass;
        for (Map.Entry<String, PersistentClass> entry : theMetadata.getEntityBindingMap().entrySet()) {
            this.filterPartitionedIdsFromIdClassPks(theClassLoaderService, entry);
        }
        ArrayList registeredComponents = new ArrayList();
        theMetadata.visitRegisteredComponents(registeredComponents::add);
        for (Component component : registeredComponents) {
            this.filterPartitionedIdsFromCompositeComponents(component);
        }
        for (String string : new TreeSet(theMetadata.getEntityBindingMap().keySet())) {
            entityPersistentClass = (PersistentClass)theMetadata.getEntityBindingMap().get(string);
            Table table = entityPersistentClass.getTable();
            for (ForeignKey foreignKey : table.getForeignKeys().values()) {
                this.filterPartitionedIdsFromLocalFks(theClassLoaderService, theMetadata, foreignKey, table, string);
            }
            for (Property property : entityPersistentClass.getProperties()) {
                Value value = property.getValue();
                if (!(value instanceof ToOne)) continue;
                ToOne toOne = (ToOne)value;
                this.filterPropertiesFromToOneRelationship(theClassLoaderService, theMetadata, table, entityPersistentClass.getClassName(), toOne);
            }
            for (UniqueKey uniqueKey : table.getUniqueKeys().values()) {
                this.filterPartitionedIdsFromUniqueConstraints(uniqueKey, table);
            }
        }
        for (Map.Entry entry : theMetadata.getEntityBindingMap().entrySet()) {
            entityPersistentClass = (PersistentClass)entry.getValue();
            this.filterPartitionedIdsFromRemoteFks(entityPersistentClass);
        }
    }

    private void filterPartitionedIdsFromIdClassPks(ClassLoaderService theClassLoaderService, Map.Entry<String, PersistentClass> nextEntry) {
        IdentitySet idRemovedColumns = new IdentitySet();
        HashSet idRemovedColumnNames = new HashSet();
        HashSet<String> idRemovedProperties = new HashSet<String>();
        String entityTypeName = nextEntry.getKey();
        Class<?> entityType = DatabasePartitionModeIdFilteringMappingContributor.getType(theClassLoaderService, entityTypeName);
        PersistentClass entityPersistentClass = nextEntry.getValue();
        Table table = entityPersistentClass.getTable();
        if (entityPersistentClass.getIdentifier() instanceof BasicValue) {
            return;
        }
        Component identifier = (Component)entityPersistentClass.getIdentifier();
        List properties = identifier.getProperties();
        Iterator iter = properties.iterator();
        while (iter.hasNext()) {
            Property property = (Property)iter.next();
            String fieldName = property.getName();
            Field field = DatabasePartitionModeIdFilteringMappingContributor.getField(entityType, fieldName);
            if (field == null) {
                field = DatabasePartitionModeIdFilteringMappingContributor.getField(identifier.getComponentClass(), fieldName);
            }
            if (field == null) {
                throw new ConfigurationException(Msg.code((int)2598) + "Failed to find field " + fieldName + " on type: " + entityType.getName());
            }
            PartitionedIdProperty remove = field.getAnnotation(PartitionedIdProperty.class);
            if (remove == null) continue;
            iter.remove();
            idRemovedColumns.addAll((Collection)property.getColumns());
            idRemovedColumnNames.addAll(property.getColumns().stream().map(c -> c.getName().toUpperCase(Locale.ROOT)).collect(Collectors.toSet()));
            property.getColumns().stream().map(theColumn -> new TableAndColumnName(table.getName(), theColumn.getName())).forEach(this.myQualifiedIdRemovedColumnNames::add);
            idRemovedProperties.add(property.getName());
            for (org.hibernate.mapping.Column next : entityPersistentClass.getTable().getColumns()) {
                if (!idRemovedColumnNames.contains(next.getName().toUpperCase(Locale.ROOT))) continue;
                next.setNullable(true);
            }
            if (DatabasePartitionModeIdFilteringMappingContributor.getField(entityType, property.getName()) == null) continue;
            entityPersistentClass.addProperty(property);
        }
        if (idRemovedColumns.isEmpty()) {
            return;
        }
        Component identifierMapper = entityPersistentClass.getIdentifierMapper();
        if (identifierMapper != null) {
            List finalPropertyList = identifierMapper.getProperties();
            finalPropertyList.removeIf(t -> idRemovedProperties.contains(t.getName()));
            DatabasePartitionModeIdFilteringMappingContributor.updateComponentWithNewPropertyList(identifierMapper, finalPropertyList);
        }
        PrimaryKey pk = table.getPrimaryKey();
        List pkColumns = pk.getColumns();
        DatabasePartitionModeIdFilteringMappingContributor.removeColumns(pkColumns, arg_0 -> ((IdentitySet)idRemovedColumns).contains(arg_0));
    }

    private void filterPartitionedIdsFromCompositeComponents(Component c) {
        Class componentType = c.getComponentClass();
        String tableName = c.getTable().getName();
        HashSet<String> removedPropertyNames = new HashSet<String>();
        for (Property property : new ArrayList(c.getProperties())) {
            Field field = DatabasePartitionModeIdFilteringMappingContributor.getField(componentType, property.getName());
            assert (field != null);
            PartitionedIdProperty annotation = field.getAnnotation(PartitionedIdProperty.class);
            if (annotation == null) continue;
            c.getProperties().remove(property);
            removedPropertyNames.add(property.getName());
            Column column = field.getAnnotation(Column.class);
            String columnName = column.name();
            this.myQualifiedIdRemovedColumnNames.add(new TableAndColumnName(tableName, columnName));
            PrimaryKey primaryKey = c.getTable().getPrimaryKey();
            primaryKey.getColumns().removeIf(t -> this.myQualifiedIdRemovedColumnNames.contains(new TableAndColumnName(tableName, t.getName())));
            for (org.hibernate.mapping.Column nextColumn : c.getTable().getColumns()) {
                if (!this.myQualifiedIdRemovedColumnNames.contains(new TableAndColumnName(tableName, nextColumn.getName()))) continue;
                nextColumn.setNullable(true);
            }
            List properties = c.getOwner().getProperties();
            for (Property nextProperty : properties) {
                if (!nextProperty.getName().equals(property.getName())) continue;
                BasicValue value = (BasicValue)nextProperty.getValue();
                Field insertabilityField = DatabasePartitionModeIdFilteringMappingContributor.getField(value.getClass(), "insertability");
                assert (insertabilityField != null);
                insertabilityField.setAccessible(true);
                try {
                    List insertability = (List)insertabilityField.get(value);
                    insertability.set(0, Boolean.TRUE);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(Msg.code((int)2599) + String.valueOf(e), e);
                }
            }
        }
        CompositeType type = c.getType();
        if (type instanceof ComponentType) {
            String[] typePropertyNames;
            for (String propertyName : typePropertyNames = ((ComponentType)type).getPropertyNames()) {
                if (!removedPropertyNames.contains(propertyName)) continue;
                DatabasePartitionModeIdFilteringMappingContributor.updateComponentWithNewPropertyList(c, c.getProperties());
                break;
            }
        }
    }

    private void filterPartitionedIdsFromLocalFks(ClassLoaderService theClassLoaderService, InFlightMetadataCollector theMetadata, ForeignKey theForeignKey, Table theTable, String theEntityTypeName) {
        Value value = theForeignKey.getColumn(0).getValue();
        if (value instanceof ToOne) {
            ToOne manyToOne = (ToOne)value;
            Set<String> columnNamesToRemoveFromFks = this.filterPropertiesFromToOneRelationship(theClassLoaderService, theMetadata, theTable, theEntityTypeName, manyToOne);
            DatabasePartitionModeIdFilteringMappingContributor.removeColumns(theForeignKey.getColumns(), t1 -> columnNamesToRemoveFromFks.contains(t1.getName().toUpperCase(Locale.ROOT)));
        } else {
            theForeignKey.getColumns().removeIf(t -> this.myQualifiedIdRemovedColumnNames.contains(new TableAndColumnName(theForeignKey.getReferencedTable().getName(), t.getName())));
        }
    }

    @Nonnull
    private Set<String> filterPropertiesFromToOneRelationship(ClassLoaderService theClassLoaderService, InFlightMetadataCollector theMetadata, Table theTable, String theEntityTypeName, ToOne manyToOne) {
        String targetTableName = ((PersistentClass)theMetadata.getEntityBindingMap().get(manyToOne.getReferencedEntityName())).getTable().getName();
        Class<?> entityType = DatabasePartitionModeIdFilteringMappingContributor.getType(theClassLoaderService, theEntityTypeName);
        String propertyName = manyToOne.getPropertyName();
        Set<String> columnNamesToRemoveFromFks = this.determineFilteredColumnNamesInForeignKey(entityType, propertyName, targetTableName);
        DatabasePartitionModeIdFilteringMappingContributor.removeColumns(manyToOne.getColumns(), t1 -> columnNamesToRemoveFromFks.contains(t1.getName().toUpperCase(Locale.ROOT)));
        columnNamesToRemoveFromFks.forEach(t -> this.myQualifiedIdRemovedColumnNames.add(new TableAndColumnName(theTable.getName(), (String)t)));
        return columnNamesToRemoveFromFks;
    }

    private void filterPartitionedIdsFromUniqueConstraints(UniqueKey uniqueKey, Table table) {
        uniqueKey.getColumns().removeIf(t -> this.myQualifiedIdRemovedColumnNames.contains(new TableAndColumnName(table.getName(), t.getName())));
    }

    private void filterPartitionedIdsFromRemoteFks(PersistentClass entityPersistentClass) {
        for (Property property : entityPersistentClass.getProperties()) {
            org.hibernate.mapping.Collection propertyValueBag;
            KeyValue propertyKey;
            Value propertyValue = property.getValue();
            if (!(propertyValue instanceof org.hibernate.mapping.Collection) || !((propertyKey = (propertyValueBag = (org.hibernate.mapping.Collection)propertyValue).getKey()) instanceof DependantValue)) continue;
            DependantValue dependantValue = (DependantValue)propertyKey;
            dependantValue.getColumns().removeIf(t -> this.myQualifiedIdRemovedColumnNames.contains(new TableAndColumnName(propertyValueBag.getCollectionTable().getName(), t.getName())));
        }
    }

    @Nonnull
    private Set<String> determineFilteredColumnNamesInForeignKey(Class<?> theEntityType, String thePropertyName, String theTargetTableName) {
        Field field = DatabasePartitionModeIdFilteringMappingContributor.getField(theEntityType, thePropertyName);
        Validate.notNull((Object)field, (String)"Unable to find field %s on entity %s", (Object[])new Object[]{thePropertyName, theEntityType.getName()});
        JoinColumns joinColumns = field.getAnnotation(JoinColumns.class);
        HashSet<String> columnNamesToRemoveFromFks = new HashSet<String>();
        if (joinColumns != null) {
            for (JoinColumn joinColumn : joinColumns.value()) {
                String targetColumnName = joinColumn.referencedColumnName();
                String sourceColumnName = joinColumn.name();
                if (StringUtils.isBlank((CharSequence)targetColumnName)) {
                    targetColumnName = sourceColumnName;
                }
                if (!this.myQualifiedIdRemovedColumnNames.contains(new TableAndColumnName(theTargetTableName, targetColumnName))) continue;
                columnNamesToRemoveFromFks.add(sourceColumnName.toUpperCase(Locale.ROOT));
            }
        }
        return columnNamesToRemoveFromFks;
    }

    private static void removeColumnsFromIndexes(InFlightMetadataCollector theMetadata, ClassLoaderService classLoaderService) {
        for (Map.Entry nextEntry : theMetadata.getEntityBindingMap().entrySet()) {
            Class<?> type = DatabasePartitionModeIdFilteringMappingContributor.getType(classLoaderService, (String)nextEntry.getKey());
            Table table = ((PersistentClass)nextEntry.getValue()).getTable();
            PartitionedIndexes partitionedIndexes = type.getAnnotation(PartitionedIndexes.class);
            if (partitionedIndexes == null) continue;
            for (PartitionedIndex partitionedIndex : partitionedIndexes.value()) {
                String indexName = partitionedIndex.name();
                Set<String> columnNames = Set.of(partitionedIndex.columns());
                assert (columnNames.stream().allMatch(t -> t.equals(t.toUpperCase(Locale.ROOT))));
                Index index = table.getIndex(indexName);
                if (index != null) {
                    List selectables = (List)DatabasePartitionModeIdFilteringMappingContributor.getFieldValue(index, "selectables");
                    Iterator iter = selectables.iterator();
                    while (iter.hasNext()) {
                        org.hibernate.mapping.Column next = (org.hibernate.mapping.Column)iter.next();
                        if (columnNames.contains(next.getName().toUpperCase(Locale.ROOT))) continue;
                        iter.remove();
                    }
                    continue;
                }
                throw new ConfigurationException(Msg.code((int)2604) + "@PartitionedIndex refers to unknown index " + indexName);
            }
        }
    }

    @Nullable
    private static Field getField(Class<?> theType, String theFieldName) {
        Field field;
        try {
            field = theType.getDeclaredField(theFieldName);
        }
        catch (NoSuchFieldException e) {
            try {
                field = theType.getField(theFieldName);
            }
            catch (NoSuchFieldException theE) {
                field = null;
            }
        }
        if (field == null && theType.getSuperclass() != null) {
            field = DatabasePartitionModeIdFilteringMappingContributor.getField(theType.getSuperclass(), theFieldName);
        }
        if (field != null) {
            field.setAccessible(true);
        }
        return field;
    }

    private static <T> T getFieldValue(Object theTarget, String theFieldName) {
        Object selectables;
        try {
            selectables = DatabasePartitionModeIdFilteringMappingContributor.getField(theTarget.getClass(), theFieldName).get(theTarget);
        }
        catch (IllegalAccessException e) {
            throw new InternalErrorException(Msg.code((int)2603) + "Failed to access field " + theFieldName, (Throwable)e);
        }
        return (T)selectables;
    }

    private static void updateComponentWithNewPropertyList(Component identifierMapper, List<Property> finalPropertyList) {
        CompositeType type = identifierMapper.getType();
        if (type instanceof ComponentType) {
            ComponentType ect = (ComponentType)type;
            Component wrapped = new Component(identifierMapper.getBuildingContext(), identifierMapper);
            wrapped.setComponentClassName(identifierMapper.getComponentClassName());
            finalPropertyList.forEach(arg_0 -> ((Component)wrapped).addProperty(arg_0));
            EmbeddedComponentType filtered = new EmbeddedComponentType(wrapped, ect.getOriginalPropertyOrder());
            filtered.injectMappingModelPart(ect.getMappingModelPart(), null);
            try {
                Class<?> identifierMapperClass = identifierMapper.getClass();
                Field field = identifierMapperClass.getDeclaredField("type");
                field.setAccessible(true);
                field.set(identifierMapper, filtered);
                field.set(wrapped, filtered);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new IllegalStateException(Msg.code((int)2600) + String.valueOf(e), e);
            }
        }
    }

    private static void removeColumns(List<org.hibernate.mapping.Column> theColumnList, Predicate<org.hibernate.mapping.Column> theRemoveIfPredicate) {
        for (int listIndex = 0; listIndex < theColumnList.size(); ++listIndex) {
            org.hibernate.mapping.Column column = theColumnList.get(listIndex);
            if (!theRemoveIfPredicate.test(column)) continue;
            theColumnList.remove(listIndex);
            for (int remainingIndex = listIndex; remainingIndex < theColumnList.size(); ++remainingIndex) {
                org.hibernate.mapping.Column remainingColumn = theColumnList.get(remainingIndex);
                if (remainingColumn.getTypeIndex() <= 0) continue;
                remainingColumn.setTypeIndex(remainingColumn.getTypeIndex() - 1);
            }
            --listIndex;
        }
    }

    @Nonnull
    private static Class<?> getType(ClassLoaderService theClassLoaderService, String theEntityTypeName) {
        Class entityType = theClassLoaderService.classForTypeName(theEntityTypeName);
        Validate.notNull((Object)entityType, (String)"Could not load type: %s", (Object[])new Object[]{theEntityTypeName});
        return entityType;
    }

    private static class TableAndColumnName {
        private final String myTableName;
        private final String myColumnName;
        private final int myHashCode;

        private TableAndColumnName(String theTableName, String theColumnName) {
            this.myTableName = theTableName.toUpperCase(Locale.ROOT);
            this.myColumnName = theColumnName.toUpperCase(Locale.ROOT);
            this.myHashCode = Objects.hash(this.myTableName, this.myColumnName);
        }

        public boolean equals(Object theO) {
            if (!(theO instanceof TableAndColumnName)) {
                return false;
            }
            TableAndColumnName that = (TableAndColumnName)theO;
            return Objects.equals(this.myTableName, that.myTableName) && Objects.equals(this.myColumnName, that.myColumnName);
        }

        public int hashCode() {
            return this.myHashCode;
        }

        public String toString() {
            return "[" + this.myTableName + "#" + this.myColumnName + "]";
        }
    }
}

