/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hapi.converters.canonical;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.CodingDt;
import ca.uhn.fhir.model.dstu2.resource.ValueSet;
import ca.uhn.hapi.converters.canonical.SubscriptionTopicCanonicalizer;
import jakarta.annotation.Nonnull;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.convertors.advisors.impl.BaseAdvisor_10_40;
import org.hl7.fhir.convertors.advisors.impl.BaseAdvisor_10_50;
import org.hl7.fhir.convertors.advisors.impl.BaseAdvisor_14_40;
import org.hl7.fhir.convertors.advisors.impl.BaseAdvisor_14_50;
import org.hl7.fhir.convertors.advisors.impl.BaseAdvisor_30_40;
import org.hl7.fhir.convertors.advisors.impl.BaseAdvisor_30_50;
import org.hl7.fhir.convertors.advisors.impl.BaseAdvisor_40_50;
import org.hl7.fhir.convertors.advisors.impl.BaseAdvisor_43_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_10_40;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_10_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_14_40;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_14_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_30_40;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_30_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_40_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_43_50;
import org.hl7.fhir.dstu2016may.model.Type;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IBaseConformance;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.AuditEvent;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.ConceptMap;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.PackageInformation;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.SubscriptionTopic;
import org.hl7.fhir.r5.model.ValueSet;

public class VersionCanonicalizer {
    private static final BaseAdvisor_30_50 ADVISOR_30_50 = new BaseAdvisor_30_50(Boolean.valueOf(false));
    private static final BaseAdvisor_30_40 ADVISOR_30_40 = new BaseAdvisor_30_40(Boolean.valueOf(false));
    private static final BaseAdvisor_10_40 ADVISOR_10_40 = new BaseAdvisor_10_40(Boolean.valueOf(false));
    private static final BaseAdvisor_10_50 ADVISOR_10_50 = new BaseAdvisor_10_50(Boolean.valueOf(false));
    private static final BaseAdvisor_40_50 ADVISOR_40_50 = new BaseAdvisor_40_50(Boolean.valueOf(false));
    private static final BaseAdvisor_43_50 ADVISOR_43_50 = new BaseAdvisor_43_50(Boolean.valueOf(false));
    private static final BaseAdvisor_14_40 ADVISOR_14_40 = new BaseAdvisor_14_40(Boolean.valueOf(false));
    private static final BaseAdvisor_14_50 ADVISOR_14_50 = new BaseAdvisor_14_50(Boolean.valueOf(false));
    private final IStrategy myStrategy;
    private final FhirContext myContext;

    public VersionCanonicalizer(FhirVersionEnum theTargetVersion) {
        this(FhirContext.forCached((FhirVersionEnum)theTargetVersion));
    }

    public VersionCanonicalizer(FhirContext theTargetContext) {
        this.myContext = theTargetContext;
        FhirVersionEnum targetVersion = theTargetContext.getVersion().getVersion();
        switch (targetVersion) {
            case DSTU2: {
                this.myStrategy = new Dstu2Strategy(false);
                break;
            }
            case DSTU2_HL7ORG: {
                this.myStrategy = new Dstu2Strategy(true);
                break;
            }
            case DSTU2_1: {
                this.myStrategy = new Dstu21Strategy();
                break;
            }
            case DSTU3: {
                this.myStrategy = new Dstu3Strategy();
                break;
            }
            case R4: {
                this.myStrategy = new R4Strategy();
                break;
            }
            case R4B: {
                this.myStrategy = new R4BStrategy();
                break;
            }
            case R5: {
                this.myStrategy = new R5Strategy();
                break;
            }
            default: {
                throw new IllegalStateException(Msg.code((int)193) + "Can't handle version: " + String.valueOf(targetVersion));
            }
        }
    }

    public CapabilityStatement capabilityStatementToCanonical(IBaseResource theCapabilityStatement) {
        return this.myStrategy.capabilityStatementToCanonical(theCapabilityStatement);
    }

    public IBaseConformance capabilityStatementFromCanonical(CapabilityStatement theCapabilityStatement) {
        return this.myStrategy.capabilityStatementFromCanonical(theCapabilityStatement);
    }

    public org.hl7.fhir.r4.model.CodeableConcept codeableConceptToCanonical(IBaseDatatype theCodeableConcept) {
        if (theCodeableConcept == null) {
            return null;
        }
        return this.myStrategy.codeableConceptToCanonical(theCodeableConcept);
    }

    public org.hl7.fhir.r4.model.Coding codingToCanonical(IBaseCoding theCodingToValidate) {
        if (theCodingToValidate == null) {
            return null;
        }
        return this.myStrategy.codingToCanonical(theCodingToValidate);
    }

    public org.hl7.fhir.r4.model.ValueSet valueSetToCanonical(IBaseResource theValueSet) {
        if (theValueSet == null) {
            return null;
        }
        return this.myStrategy.valueSetToCanonical(theValueSet);
    }

    public CodeSystem codeSystemToCanonical(IBaseResource theCodeSystem) {
        return this.myStrategy.codeSystemToCanonical(theCodeSystem);
    }

    public IBaseResource valueSetFromCanonical(org.hl7.fhir.r4.model.ValueSet theValueSet) {
        return this.myStrategy.valueSetFromCanonical(theValueSet);
    }

    public IBaseResource codeSystemFromCanonical(CodeSystem theCodeSystem) {
        return this.myStrategy.codeSystemFromCanonical(theCodeSystem);
    }

    public ConceptMap conceptMapToCanonical(IBaseResource theConceptMap) {
        return this.myStrategy.conceptMapToCanonical(theConceptMap);
    }

    public <T extends IBaseResource> SearchParameter searchParameterToCanonical(T theSearchParameter) {
        IBaseResource input = this.myContext.newTerser().clone(theSearchParameter);
        List<String> baseExtensionValues = this.extractNonStandardSearchParameterListAndClearSourceIfAnyArePresent(input, "base");
        List<String> targetExtensionValues = this.extractNonStandardSearchParameterListAndClearSourceIfAnyArePresent(input, "target");
        SearchParameter retVal = this.myStrategy.searchParameterToCanonical(input);
        baseExtensionValues.forEach(t -> retVal.addExtension("http://hl7.org/fhir/tools/CustomBaseResource", (DataType)new CodeType(t)));
        targetExtensionValues.forEach(t -> retVal.addExtension("http://hl7.org/fhir/tools/CustomTargetResource", (DataType)new CodeType(t)));
        return retVal;
    }

    public IBaseResource searchParameterFromCanonical(SearchParameter theSearchParameter) {
        return this.myStrategy.searchParameterFromCanonical(theSearchParameter);
    }

    public IBaseParameters parametersFromCanonical(Parameters theParameters) {
        return this.myStrategy.parametersFromCanonical(theParameters);
    }

    public StructureDefinition structureDefinitionToCanonical(IBaseResource theResource) {
        StructureDefinition retVal = this.myStrategy.structureDefinitionToCanonical(theResource);
        String packageUserData = (String)theResource.getUserData("package");
        if (packageUserData != null) {
            retVal.setUserData("package", (Object)packageUserData);
            retVal.setSourcePackage(new PackageInformation(packageUserData, theResource.getStructureFhirVersionEnum().getFhirVersionString(), new Date()));
        }
        return retVal;
    }

    public IBaseResource structureDefinitionFromCanonical(StructureDefinition theResource) {
        return this.myStrategy.structureDefinitionFromCanonical(theResource);
    }

    public IBaseResource valueSetFromValidatorCanonical(ValueSet theResource) {
        return this.myStrategy.valueSetFromValidatorCanonical(theResource);
    }

    public Resource resourceToValidatorCanonical(IBaseResource theResource) {
        return this.myStrategy.resourceToValidatorCanonical(theResource);
    }

    public ValueSet valueSetToValidatorCanonical(IBaseResource theResource) {
        return this.myStrategy.valueSetToValidatorCanonical(theResource);
    }

    public org.hl7.fhir.r5.model.CodeSystem codeSystemToValidatorCanonical(IBaseResource theResource) {
        return this.myStrategy.codeSystemToValidatorCanonical(theResource);
    }

    public IBaseResource auditEventFromCanonical(AuditEvent theResource) {
        return this.myStrategy.auditEventFromCanonical(theResource);
    }

    @Nonnull
    private List<String> extractNonStandardSearchParameterListAndClearSourceIfAnyArePresent(IBaseResource theSearchParameter, String theChildName) {
        BaseRuntimeChildDefinition child = this.myContext.getResourceDefinition(theSearchParameter).getChildByName(theChildName);
        List baseList = child.getAccessor().getValues((IBase)theSearchParameter);
        List<String> baseExtensionValues = baseList.stream().filter(Objects::nonNull).filter(t -> t instanceof IPrimitiveType).map(t -> (IPrimitiveType)t).map(IPrimitiveType::getValueAsString).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        if (baseExtensionValues.stream().allMatch(Enumerations.VersionIndependentResourceTypesAll::isValidCode)) {
            baseExtensionValues.clear();
        } else {
            baseList.clear();
        }
        return baseExtensionValues;
    }

    public SubscriptionTopic subscriptionTopicToCanonical(IBaseResource theResource) {
        return SubscriptionTopicCanonicalizer.canonicalizeTopic(this.myContext, theResource);
    }

    public IBaseResource conceptMapFromCanonical(ConceptMap theConceptMap) {
        return this.myStrategy.conceptMapFromCanonical(theConceptMap);
    }

    private static class Dstu2Strategy
    implements IStrategy {
        private final FhirContext myDstu2Hl7OrgContext = FhirContext.forDstu2Hl7OrgCached();
        private final FhirContext myDstu2Context = FhirContext.forDstu2Cached();
        private final boolean myHl7OrgStructures;

        public Dstu2Strategy(boolean theHl7OrgStructures) {
            this.myHl7OrgStructures = theHl7OrgStructures;
        }

        @Override
        public CapabilityStatement capabilityStatementToCanonical(IBaseResource theCapabilityStatement) {
            org.hl7.fhir.dstu2.model.Resource reencoded = this.reencodeToHl7Org(theCapabilityStatement);
            return (CapabilityStatement)VersionConvertorFactory_10_50.convertResource((org.hl7.fhir.dstu2.model.Resource)reencoded, (BaseAdvisor_10_50)ADVISOR_10_50);
        }

        @Override
        public org.hl7.fhir.r4.model.Coding codingToCanonical(IBaseCoding theCoding) {
            CodingDt coding = (CodingDt)theCoding;
            org.hl7.fhir.r4.model.Coding retVal = new org.hl7.fhir.r4.model.Coding();
            retVal.setCode(coding.getCode());
            retVal.setSystem(coding.getSystem());
            retVal.setDisplay(coding.getDisplay());
            retVal.setVersion(coding.getVersion());
            if (!coding.getUserSelectedElement().isEmpty()) {
                retVal.setUserSelected(coding.getUserSelected());
            }
            return retVal;
        }

        @Override
        public org.hl7.fhir.r4.model.CodeableConcept codeableConceptToCanonical(IBaseDatatype theCodeableConcept) {
            CodeableConceptDt codeableConcept = (CodeableConceptDt)theCodeableConcept;
            org.hl7.fhir.r4.model.CodeableConcept retVal = new org.hl7.fhir.r4.model.CodeableConcept();
            retVal.setText(codeableConcept.getText());
            for (CodingDt next : codeableConcept.getCoding()) {
                retVal.addCoding(this.codingToCanonical((IBaseCoding)next));
            }
            return retVal;
        }

        @Override
        public org.hl7.fhir.r4.model.ValueSet valueSetToCanonical(IBaseResource theValueSet) {
            org.hl7.fhir.dstu2.model.Resource reencoded = this.reencodeToHl7Org(theValueSet);
            return (org.hl7.fhir.r4.model.ValueSet)VersionConvertorFactory_10_40.convertResource((org.hl7.fhir.dstu2.model.Resource)reencoded, (BaseAdvisor_10_40)ADVISOR_10_40);
        }

        @Override
        public CodeSystem codeSystemToCanonical(IBaseResource theCodeSystem) {
            CodeSystem retVal = new CodeSystem();
            ca.uhn.fhir.model.dstu2.resource.ValueSet input = (ca.uhn.fhir.model.dstu2.resource.ValueSet)theCodeSystem;
            retVal.setUrl(input.getUrl());
            for (ValueSet.CodeSystemConcept next : input.getCodeSystem().getConcept()) {
                this.translateAndAddConcept(next, retVal.getConcept());
            }
            return retVal;
        }

        private void translateAndAddConcept(ValueSet.CodeSystemConcept theSource, List<CodeSystem.ConceptDefinitionComponent> theTarget) {
            CodeSystem.ConceptDefinitionComponent targetConcept = new CodeSystem.ConceptDefinitionComponent();
            targetConcept.setCode(theSource.getCode());
            targetConcept.setDisplay(theSource.getDisplay());
            for (ValueSet.CodeSystemConceptDesignation next : theSource.getDesignation()) {
                CodeSystem.ConceptDefinitionDesignationComponent targetDesignation = targetConcept.addDesignation();
                targetDesignation.setLanguage(next.getLanguage());
                targetDesignation.setValue(next.getValue());
                if (next.getUse() == null) continue;
                targetDesignation.setUse(this.codingToCanonical((IBaseCoding)next.getUse()));
            }
            for (ValueSet.CodeSystemConcept nextChild : theSource.getConcept()) {
                this.translateAndAddConcept(nextChild, targetConcept.getConcept());
            }
            theTarget.add(targetConcept);
        }

        @Override
        public IBaseResource valueSetFromCanonical(org.hl7.fhir.r4.model.ValueSet theValueSet) {
            org.hl7.fhir.dstu2.model.Resource valueSetDstu2Hl7Org = VersionConvertorFactory_10_40.convertResource((org.hl7.fhir.r4.model.Resource)theValueSet, (BaseAdvisor_10_40)ADVISOR_10_40);
            return this.reencodeFromHl7Org(valueSetDstu2Hl7Org);
        }

        @Override
        public IBaseResource codeSystemFromCanonical(CodeSystem theCodeSystem) {
            org.hl7.fhir.dstu2.model.Resource codeSystemDstu2Hl7Org = VersionConvertorFactory_10_40.convertResource((org.hl7.fhir.r4.model.Resource)theCodeSystem, (BaseAdvisor_10_40)ADVISOR_10_40);
            return this.reencodeFromHl7Org(codeSystemDstu2Hl7Org);
        }

        @Override
        public ConceptMap conceptMapToCanonical(IBaseResource theConceptMap) {
            org.hl7.fhir.dstu2.model.Resource reencoded = this.reencodeToHl7Org(theConceptMap);
            return (ConceptMap)VersionConvertorFactory_10_40.convertResource((org.hl7.fhir.dstu2.model.Resource)reencoded, (BaseAdvisor_10_40)ADVISOR_10_40);
        }

        @Override
        public IBaseResource conceptMapFromCanonical(ConceptMap theConceptMap) {
            org.hl7.fhir.dstu2.model.Resource codeSystemDstu2Hl7Org = VersionConvertorFactory_10_40.convertResource((org.hl7.fhir.r4.model.Resource)theConceptMap, (BaseAdvisor_10_40)ADVISOR_10_40);
            return this.reencodeFromHl7Org(codeSystemDstu2Hl7Org);
        }

        @Override
        public SearchParameter searchParameterToCanonical(IBaseResource theSearchParameter) {
            org.hl7.fhir.dstu2.model.SearchParameter reencoded = (org.hl7.fhir.dstu2.model.SearchParameter)this.reencodeToHl7Org(theSearchParameter);
            SearchParameter retVal = (SearchParameter)VersionConvertorFactory_10_50.convertResource((org.hl7.fhir.dstu2.model.Resource)reencoded, (BaseAdvisor_10_50)ADVISOR_10_50);
            if (StringUtils.isBlank((CharSequence)retVal.getExpression())) {
                retVal.setExpression(reencoded.getXpath());
            }
            return retVal;
        }

        @Override
        public IBaseParameters parametersFromCanonical(Parameters theParameters) {
            org.hl7.fhir.dstu2.model.Resource converted = VersionConvertorFactory_10_40.convertResource((org.hl7.fhir.r4.model.Resource)theParameters, (BaseAdvisor_10_40)ADVISOR_10_40);
            return (IBaseParameters)this.reencodeFromHl7Org(converted);
        }

        @Override
        public StructureDefinition structureDefinitionToCanonical(IBaseResource theResource) {
            org.hl7.fhir.dstu2.model.Resource reencoded = this.reencodeToHl7Org(theResource);
            return (StructureDefinition)VersionConvertorFactory_10_50.convertResource((org.hl7.fhir.dstu2.model.Resource)reencoded, (BaseAdvisor_10_50)ADVISOR_10_50);
        }

        @Override
        public IBaseResource structureDefinitionFromCanonical(StructureDefinition theResource) {
            org.hl7.fhir.dstu2.model.Resource converted = VersionConvertorFactory_10_50.convertResource((Resource)theResource, (BaseAdvisor_10_50)ADVISOR_10_50);
            return this.reencodeFromHl7Org(converted);
        }

        @Override
        public IBaseResource valueSetFromValidatorCanonical(ValueSet theResource) {
            org.hl7.fhir.dstu2.model.Resource converted = VersionConvertorFactory_10_50.convertResource((Resource)theResource, (BaseAdvisor_10_50)ADVISOR_10_50);
            return this.reencodeFromHl7Org(converted);
        }

        @Override
        public Resource resourceToValidatorCanonical(IBaseResource theResource) {
            org.hl7.fhir.dstu2.model.Resource reencoded = this.reencodeToHl7Org(theResource);
            return VersionConvertorFactory_10_50.convertResource((org.hl7.fhir.dstu2.model.Resource)reencoded, (BaseAdvisor_10_50)ADVISOR_10_50);
        }

        @Override
        public ValueSet valueSetToValidatorCanonical(IBaseResource theResource) {
            org.hl7.fhir.dstu2.model.Resource reencoded = this.reencodeToHl7Org(theResource);
            return (ValueSet)VersionConvertorFactory_10_50.convertResource((org.hl7.fhir.dstu2.model.Resource)reencoded, (BaseAdvisor_10_50)ADVISOR_10_50);
        }

        @Override
        public org.hl7.fhir.r5.model.CodeSystem codeSystemToValidatorCanonical(IBaseResource theResource) {
            org.hl7.fhir.dstu2.model.Resource reencoded = this.reencodeToHl7Org(theResource);
            return (org.hl7.fhir.r5.model.CodeSystem)VersionConvertorFactory_10_50.convertResource((org.hl7.fhir.dstu2.model.Resource)reencoded, (BaseAdvisor_10_50)ADVISOR_10_50);
        }

        @Override
        public IBaseResource auditEventFromCanonical(AuditEvent theResource) {
            org.hl7.fhir.dstu2.model.Resource hl7Org = VersionConvertorFactory_10_40.convertResource((org.hl7.fhir.r4.model.Resource)theResource, (BaseAdvisor_10_40)ADVISOR_10_40);
            return this.reencodeFromHl7Org(hl7Org);
        }

        @Override
        public IBaseResource searchParameterFromCanonical(SearchParameter theResource) {
            org.hl7.fhir.dstu2.model.Resource resource = VersionConvertorFactory_10_50.convertResource((Resource)theResource, (BaseAdvisor_10_50)ADVISOR_10_50);
            return this.reencodeFromHl7Org(resource);
        }

        @Override
        public IBaseConformance capabilityStatementFromCanonical(CapabilityStatement theResource) {
            org.hl7.fhir.dstu2.model.Resource converted = VersionConvertorFactory_10_50.convertResource((Resource)theResource, (BaseAdvisor_10_50)ADVISOR_10_50);
            return (IBaseConformance)this.reencodeFromHl7Org(converted);
        }

        private org.hl7.fhir.dstu2.model.Resource reencodeToHl7Org(IBaseResource theInput) {
            if (theInput == null) {
                return null;
            }
            if (this.myHl7OrgStructures) {
                return (org.hl7.fhir.dstu2.model.Resource)theInput;
            }
            return (org.hl7.fhir.dstu2.model.Resource)this.myDstu2Hl7OrgContext.newJsonParser().parseResource(this.encodeAsString(theInput));
        }

        private IBaseResource reencodeFromHl7Org(org.hl7.fhir.dstu2.model.Resource theInput) {
            if (theInput == null) {
                return null;
            }
            if (this.myHl7OrgStructures) {
                return theInput;
            }
            return this.myDstu2Context.newJsonParser().parseResource(this.encodeAsString((IBaseResource)theInput));
        }

        private String encodeAsString(IBaseResource theResource) {
            FhirVersionEnum version = theResource.getStructureFhirVersionEnum();
            if (this.myDstu2Context.getVersion().getVersion().equals((Object)version)) {
                return this.myDstu2Context.newJsonParser().encodeResourceToString(theResource);
            }
            if (this.myDstu2Hl7OrgContext.getVersion().getVersion().equals((Object)version)) {
                return this.myDstu2Hl7OrgContext.newJsonParser().encodeResourceToString(theResource);
            }
            throw new IllegalArgumentException(Msg.code((int)2777) + "Cannot encode resource with version: %s".formatted(version));
        }
    }

    private static interface IStrategy {
        public CapabilityStatement capabilityStatementToCanonical(IBaseResource var1);

        public org.hl7.fhir.r4.model.Coding codingToCanonical(IBaseCoding var1);

        public org.hl7.fhir.r4.model.CodeableConcept codeableConceptToCanonical(IBaseDatatype var1);

        public org.hl7.fhir.r4.model.ValueSet valueSetToCanonical(IBaseResource var1);

        public CodeSystem codeSystemToCanonical(IBaseResource var1);

        public IBaseResource valueSetFromCanonical(org.hl7.fhir.r4.model.ValueSet var1);

        public IBaseResource codeSystemFromCanonical(CodeSystem var1);

        public ConceptMap conceptMapToCanonical(IBaseResource var1);

        public IBaseResource conceptMapFromCanonical(ConceptMap var1);

        public SearchParameter searchParameterToCanonical(IBaseResource var1);

        public IBaseParameters parametersFromCanonical(Parameters var1);

        public StructureDefinition structureDefinitionToCanonical(IBaseResource var1);

        public IBaseResource structureDefinitionFromCanonical(StructureDefinition var1);

        public IBaseResource valueSetFromValidatorCanonical(ValueSet var1);

        public Resource resourceToValidatorCanonical(IBaseResource var1);

        public ValueSet valueSetToValidatorCanonical(IBaseResource var1);

        public org.hl7.fhir.r5.model.CodeSystem codeSystemToValidatorCanonical(IBaseResource var1);

        public IBaseResource searchParameterFromCanonical(SearchParameter var1);

        public IBaseResource auditEventFromCanonical(AuditEvent var1);

        public IBaseConformance capabilityStatementFromCanonical(CapabilityStatement var1);
    }

    private static class Dstu21Strategy
    implements IStrategy {
        private Dstu21Strategy() {
        }

        @Override
        public CapabilityStatement capabilityStatementToCanonical(IBaseResource theCapabilityStatement) {
            return (CapabilityStatement)VersionConvertorFactory_14_50.convertResource((org.hl7.fhir.dstu2016may.model.Resource)((org.hl7.fhir.dstu2016may.model.Resource)theCapabilityStatement), (BaseAdvisor_14_50)ADVISOR_14_50);
        }

        @Override
        public org.hl7.fhir.r4.model.Coding codingToCanonical(IBaseCoding theCoding) {
            return (org.hl7.fhir.r4.model.Coding)VersionConvertorFactory_14_40.convertType((Type)((org.hl7.fhir.dstu2016may.model.Coding)theCoding), (BaseAdvisor_14_40)ADVISOR_14_40);
        }

        @Override
        public org.hl7.fhir.r4.model.CodeableConcept codeableConceptToCanonical(IBaseDatatype theCodeableConcept) {
            return (org.hl7.fhir.r4.model.CodeableConcept)VersionConvertorFactory_14_40.convertType((Type)((org.hl7.fhir.dstu2016may.model.CodeableConcept)theCodeableConcept), (BaseAdvisor_14_40)ADVISOR_14_40);
        }

        @Override
        public org.hl7.fhir.r4.model.ValueSet valueSetToCanonical(IBaseResource theValueSet) {
            return (org.hl7.fhir.r4.model.ValueSet)VersionConvertorFactory_14_40.convertResource((org.hl7.fhir.dstu2016may.model.Resource)((org.hl7.fhir.dstu2016may.model.Resource)theValueSet), (BaseAdvisor_14_40)ADVISOR_14_40);
        }

        @Override
        public CodeSystem codeSystemToCanonical(IBaseResource theCodeSystem) {
            return (CodeSystem)VersionConvertorFactory_14_40.convertResource((org.hl7.fhir.dstu2016may.model.Resource)((org.hl7.fhir.dstu2016may.model.Resource)theCodeSystem), (BaseAdvisor_14_40)ADVISOR_14_40);
        }

        @Override
        public IBaseResource valueSetFromCanonical(org.hl7.fhir.r4.model.ValueSet theValueSet) {
            return VersionConvertorFactory_14_40.convertResource((org.hl7.fhir.r4.model.Resource)theValueSet, (BaseAdvisor_14_40)ADVISOR_14_40);
        }

        @Override
        public IBaseResource codeSystemFromCanonical(CodeSystem theCodeSystem) {
            return VersionConvertorFactory_14_40.convertResource((org.hl7.fhir.r4.model.Resource)theCodeSystem, (BaseAdvisor_14_40)ADVISOR_14_40);
        }

        @Override
        public ConceptMap conceptMapToCanonical(IBaseResource theConceptMap) {
            return (ConceptMap)VersionConvertorFactory_14_40.convertResource((org.hl7.fhir.dstu2016may.model.Resource)((org.hl7.fhir.dstu2016may.model.Resource)theConceptMap), (BaseAdvisor_14_40)ADVISOR_14_40);
        }

        @Override
        public IBaseResource conceptMapFromCanonical(ConceptMap theConceptMap) {
            return VersionConvertorFactory_14_40.convertResource((org.hl7.fhir.r4.model.Resource)theConceptMap, (BaseAdvisor_14_40)ADVISOR_14_40);
        }

        @Override
        public SearchParameter searchParameterToCanonical(IBaseResource theSearchParameter) {
            return (SearchParameter)VersionConvertorFactory_14_50.convertResource((org.hl7.fhir.dstu2016may.model.Resource)((org.hl7.fhir.dstu2016may.model.Resource)theSearchParameter), (BaseAdvisor_14_50)ADVISOR_14_50);
        }

        @Override
        public IBaseParameters parametersFromCanonical(Parameters theParameters) {
            return (IBaseParameters)VersionConvertorFactory_14_40.convertResource((org.hl7.fhir.r4.model.Resource)theParameters, (BaseAdvisor_14_40)ADVISOR_14_40);
        }

        @Override
        public StructureDefinition structureDefinitionToCanonical(IBaseResource theResource) {
            return (StructureDefinition)VersionConvertorFactory_14_50.convertResource((org.hl7.fhir.dstu2016may.model.Resource)((org.hl7.fhir.dstu2016may.model.Resource)theResource), (BaseAdvisor_14_50)ADVISOR_14_50);
        }

        @Override
        public IBaseResource structureDefinitionFromCanonical(StructureDefinition theResource) {
            return VersionConvertorFactory_14_50.convertResource((Resource)theResource, (BaseAdvisor_14_50)ADVISOR_14_50);
        }

        @Override
        public IBaseResource valueSetFromValidatorCanonical(ValueSet theResource) {
            return VersionConvertorFactory_14_50.convertResource((Resource)theResource, (BaseAdvisor_14_50)ADVISOR_14_50);
        }

        @Override
        public Resource resourceToValidatorCanonical(IBaseResource theResource) {
            return VersionConvertorFactory_14_50.convertResource((org.hl7.fhir.dstu2016may.model.Resource)((org.hl7.fhir.dstu2016may.model.Resource)theResource), (BaseAdvisor_14_50)ADVISOR_14_50);
        }

        @Override
        public ValueSet valueSetToValidatorCanonical(IBaseResource theResource) {
            return (ValueSet)VersionConvertorFactory_14_50.convertResource((org.hl7.fhir.dstu2016may.model.Resource)((org.hl7.fhir.dstu2016may.model.Resource)theResource), (BaseAdvisor_14_50)ADVISOR_14_50);
        }

        @Override
        public org.hl7.fhir.r5.model.CodeSystem codeSystemToValidatorCanonical(IBaseResource theResource) {
            return (org.hl7.fhir.r5.model.CodeSystem)VersionConvertorFactory_14_50.convertResource((org.hl7.fhir.dstu2016may.model.Resource)((org.hl7.fhir.dstu2016may.model.Resource)theResource), (BaseAdvisor_14_50)ADVISOR_14_50);
        }

        @Override
        public IBaseResource searchParameterFromCanonical(SearchParameter theResource) {
            return VersionConvertorFactory_14_50.convertResource((Resource)theResource, (BaseAdvisor_14_50)ADVISOR_14_50);
        }

        @Override
        public IBaseResource auditEventFromCanonical(AuditEvent theResource) {
            return VersionConvertorFactory_14_40.convertResource((org.hl7.fhir.r4.model.Resource)theResource, (BaseAdvisor_14_40)ADVISOR_14_40);
        }

        @Override
        public IBaseConformance capabilityStatementFromCanonical(CapabilityStatement theResource) {
            return (IBaseConformance)VersionConvertorFactory_14_50.convertResource((Resource)theResource, (BaseAdvisor_14_50)ADVISOR_14_50);
        }
    }

    private static class Dstu3Strategy
    implements IStrategy {
        private Dstu3Strategy() {
        }

        @Override
        public CapabilityStatement capabilityStatementToCanonical(IBaseResource theCapabilityStatement) {
            return (CapabilityStatement)VersionConvertorFactory_30_50.convertResource((org.hl7.fhir.dstu3.model.Resource)((org.hl7.fhir.dstu3.model.Resource)theCapabilityStatement), (BaseAdvisor_30_50)ADVISOR_30_50);
        }

        @Override
        public org.hl7.fhir.r4.model.Coding codingToCanonical(IBaseCoding theCoding) {
            return (org.hl7.fhir.r4.model.Coding)VersionConvertorFactory_30_40.convertType((org.hl7.fhir.dstu3.model.Type)((org.hl7.fhir.dstu3.model.Coding)theCoding), (BaseAdvisor_30_40)ADVISOR_30_40);
        }

        @Override
        public org.hl7.fhir.r4.model.CodeableConcept codeableConceptToCanonical(IBaseDatatype theCodeableConcept) {
            return (org.hl7.fhir.r4.model.CodeableConcept)VersionConvertorFactory_30_40.convertType((org.hl7.fhir.dstu3.model.Type)((org.hl7.fhir.dstu3.model.CodeableConcept)theCodeableConcept), (BaseAdvisor_30_40)ADVISOR_30_40);
        }

        @Override
        public org.hl7.fhir.r4.model.ValueSet valueSetToCanonical(IBaseResource theValueSet) {
            return (org.hl7.fhir.r4.model.ValueSet)VersionConvertorFactory_30_40.convertResource((org.hl7.fhir.dstu3.model.Resource)((org.hl7.fhir.dstu3.model.Resource)theValueSet), (BaseAdvisor_30_40)ADVISOR_30_40);
        }

        @Override
        public CodeSystem codeSystemToCanonical(IBaseResource theCodeSystem) {
            return (CodeSystem)VersionConvertorFactory_30_40.convertResource((org.hl7.fhir.dstu3.model.Resource)((org.hl7.fhir.dstu3.model.Resource)theCodeSystem), (BaseAdvisor_30_40)ADVISOR_30_40);
        }

        @Override
        public IBaseResource valueSetFromCanonical(org.hl7.fhir.r4.model.ValueSet theValueSet) {
            return VersionConvertorFactory_30_40.convertResource((org.hl7.fhir.r4.model.Resource)theValueSet, (BaseAdvisor_30_40)ADVISOR_30_40);
        }

        @Override
        public IBaseResource codeSystemFromCanonical(CodeSystem theCodeSystem) {
            return VersionConvertorFactory_30_40.convertResource((org.hl7.fhir.r4.model.Resource)theCodeSystem, (BaseAdvisor_30_40)ADVISOR_30_40);
        }

        @Override
        public ConceptMap conceptMapToCanonical(IBaseResource theConceptMap) {
            return (ConceptMap)VersionConvertorFactory_30_40.convertResource((org.hl7.fhir.dstu3.model.Resource)((org.hl7.fhir.dstu3.model.Resource)theConceptMap), (BaseAdvisor_30_40)ADVISOR_30_40);
        }

        @Override
        public IBaseResource conceptMapFromCanonical(ConceptMap theConceptMap) {
            return VersionConvertorFactory_30_40.convertResource((org.hl7.fhir.r4.model.Resource)theConceptMap, (BaseAdvisor_30_40)ADVISOR_30_40);
        }

        @Override
        public SearchParameter searchParameterToCanonical(IBaseResource theSearchParameter) {
            return (SearchParameter)VersionConvertorFactory_30_50.convertResource((org.hl7.fhir.dstu3.model.Resource)((org.hl7.fhir.dstu3.model.Resource)theSearchParameter), (BaseAdvisor_30_50)ADVISOR_30_50);
        }

        @Override
        public IBaseParameters parametersFromCanonical(Parameters theParameters) {
            return (IBaseParameters)VersionConvertorFactory_30_40.convertResource((org.hl7.fhir.r4.model.Resource)theParameters, (BaseAdvisor_30_40)ADVISOR_30_40);
        }

        @Override
        public StructureDefinition structureDefinitionToCanonical(IBaseResource theResource) {
            return (StructureDefinition)VersionConvertorFactory_30_50.convertResource((org.hl7.fhir.dstu3.model.Resource)((org.hl7.fhir.dstu3.model.Resource)theResource), (BaseAdvisor_30_50)ADVISOR_30_50);
        }

        @Override
        public IBaseResource structureDefinitionFromCanonical(StructureDefinition theResource) {
            return VersionConvertorFactory_30_50.convertResource((Resource)theResource, (BaseAdvisor_30_50)ADVISOR_30_50);
        }

        @Override
        public IBaseResource valueSetFromValidatorCanonical(ValueSet theResource) {
            return VersionConvertorFactory_30_50.convertResource((Resource)theResource, (BaseAdvisor_30_50)ADVISOR_30_50);
        }

        @Override
        public Resource resourceToValidatorCanonical(IBaseResource theResource) {
            return VersionConvertorFactory_30_50.convertResource((org.hl7.fhir.dstu3.model.Resource)((org.hl7.fhir.dstu3.model.Resource)theResource), (BaseAdvisor_30_50)ADVISOR_30_50);
        }

        @Override
        public ValueSet valueSetToValidatorCanonical(IBaseResource theResource) {
            return (ValueSet)VersionConvertorFactory_30_50.convertResource((org.hl7.fhir.dstu3.model.Resource)((org.hl7.fhir.dstu3.model.Resource)theResource), (BaseAdvisor_30_50)ADVISOR_30_50);
        }

        @Override
        public org.hl7.fhir.r5.model.CodeSystem codeSystemToValidatorCanonical(IBaseResource theResource) {
            return (org.hl7.fhir.r5.model.CodeSystem)VersionConvertorFactory_30_50.convertResource((org.hl7.fhir.dstu3.model.Resource)((org.hl7.fhir.dstu3.model.Resource)theResource), (BaseAdvisor_30_50)ADVISOR_30_50);
        }

        @Override
        public IBaseResource searchParameterFromCanonical(SearchParameter theResource) {
            return VersionConvertorFactory_30_50.convertResource((Resource)theResource, (BaseAdvisor_30_50)ADVISOR_30_50);
        }

        @Override
        public IBaseResource auditEventFromCanonical(AuditEvent theResource) {
            return VersionConvertorFactory_30_40.convertResource((org.hl7.fhir.r4.model.Resource)theResource, (BaseAdvisor_30_40)ADVISOR_30_40);
        }

        @Override
        public IBaseConformance capabilityStatementFromCanonical(CapabilityStatement theResource) {
            return (IBaseConformance)VersionConvertorFactory_30_50.convertResource((Resource)theResource, (BaseAdvisor_30_50)ADVISOR_30_50);
        }
    }

    private static class R4Strategy
    implements IStrategy {
        private R4Strategy() {
        }

        @Override
        public CapabilityStatement capabilityStatementToCanonical(IBaseResource theCapabilityStatement) {
            return (CapabilityStatement)VersionConvertorFactory_40_50.convertResource((org.hl7.fhir.r4.model.Resource)((org.hl7.fhir.r4.model.Resource)theCapabilityStatement), (BaseAdvisor_40_50)ADVISOR_40_50);
        }

        @Override
        public org.hl7.fhir.r4.model.Coding codingToCanonical(IBaseCoding theCoding) {
            return (org.hl7.fhir.r4.model.Coding)theCoding;
        }

        @Override
        public org.hl7.fhir.r4.model.CodeableConcept codeableConceptToCanonical(IBaseDatatype theCodeableConcept) {
            return (org.hl7.fhir.r4.model.CodeableConcept)theCodeableConcept;
        }

        @Override
        public org.hl7.fhir.r4.model.ValueSet valueSetToCanonical(IBaseResource theValueSet) {
            return (org.hl7.fhir.r4.model.ValueSet)theValueSet;
        }

        @Override
        public CodeSystem codeSystemToCanonical(IBaseResource theCodeSystem) {
            return (CodeSystem)theCodeSystem;
        }

        @Override
        public IBaseResource valueSetFromCanonical(org.hl7.fhir.r4.model.ValueSet theValueSet) {
            return theValueSet;
        }

        @Override
        public IBaseResource codeSystemFromCanonical(CodeSystem theCodeSystem) {
            return theCodeSystem;
        }

        @Override
        public ConceptMap conceptMapToCanonical(IBaseResource theConceptMap) {
            return (ConceptMap)theConceptMap;
        }

        @Override
        public IBaseResource conceptMapFromCanonical(ConceptMap theConceptMap) {
            return theConceptMap;
        }

        @Override
        public SearchParameter searchParameterToCanonical(IBaseResource theSearchParameter) {
            return (SearchParameter)VersionConvertorFactory_40_50.convertResource((org.hl7.fhir.r4.model.Resource)((org.hl7.fhir.r4.model.Resource)theSearchParameter), (BaseAdvisor_40_50)ADVISOR_40_50);
        }

        @Override
        public IBaseParameters parametersFromCanonical(Parameters theParameters) {
            return theParameters;
        }

        @Override
        public StructureDefinition structureDefinitionToCanonical(IBaseResource theResource) {
            return (StructureDefinition)VersionConvertorFactory_40_50.convertResource((org.hl7.fhir.r4.model.Resource)((org.hl7.fhir.r4.model.Resource)theResource), (BaseAdvisor_40_50)ADVISOR_40_50);
        }

        @Override
        public IBaseResource structureDefinitionFromCanonical(StructureDefinition theResource) {
            return VersionConvertorFactory_40_50.convertResource((Resource)theResource, (BaseAdvisor_40_50)ADVISOR_40_50);
        }

        @Override
        public IBaseResource valueSetFromValidatorCanonical(ValueSet theResource) {
            return VersionConvertorFactory_40_50.convertResource((Resource)theResource, (BaseAdvisor_40_50)ADVISOR_40_50);
        }

        @Override
        public Resource resourceToValidatorCanonical(IBaseResource theResource) {
            return VersionConvertorFactory_40_50.convertResource((org.hl7.fhir.r4.model.Resource)((org.hl7.fhir.r4.model.Resource)theResource), (BaseAdvisor_40_50)ADVISOR_40_50);
        }

        @Override
        public ValueSet valueSetToValidatorCanonical(IBaseResource theResource) {
            return (ValueSet)VersionConvertorFactory_40_50.convertResource((org.hl7.fhir.r4.model.Resource)((org.hl7.fhir.r4.model.Resource)theResource), (BaseAdvisor_40_50)ADVISOR_40_50);
        }

        @Override
        public org.hl7.fhir.r5.model.CodeSystem codeSystemToValidatorCanonical(IBaseResource theResource) {
            return (org.hl7.fhir.r5.model.CodeSystem)VersionConvertorFactory_40_50.convertResource((org.hl7.fhir.r4.model.Resource)((org.hl7.fhir.r4.model.Resource)theResource), (BaseAdvisor_40_50)ADVISOR_40_50);
        }

        @Override
        public IBaseResource searchParameterFromCanonical(SearchParameter theResource) {
            return VersionConvertorFactory_40_50.convertResource((Resource)theResource, (BaseAdvisor_40_50)ADVISOR_40_50);
        }

        @Override
        public IBaseResource auditEventFromCanonical(AuditEvent theResource) {
            return theResource;
        }

        @Override
        public IBaseConformance capabilityStatementFromCanonical(CapabilityStatement theResource) {
            return (IBaseConformance)VersionConvertorFactory_40_50.convertResource((Resource)theResource, (BaseAdvisor_40_50)ADVISOR_40_50);
        }
    }

    private static class R4BStrategy
    implements IStrategy {
        private R4BStrategy() {
        }

        @Override
        public CapabilityStatement capabilityStatementToCanonical(IBaseResource theCapabilityStatement) {
            return (CapabilityStatement)VersionConvertorFactory_43_50.convertResource((org.hl7.fhir.r4b.model.Resource)((org.hl7.fhir.r4b.model.Resource)theCapabilityStatement), (BaseAdvisor_43_50)ADVISOR_43_50);
        }

        @Override
        public org.hl7.fhir.r4.model.Coding codingToCanonical(IBaseCoding theCoding) {
            Coding r5coding = (Coding)VersionConvertorFactory_43_50.convertType((org.hl7.fhir.r4b.model.DataType)((org.hl7.fhir.r4b.model.Coding)theCoding), (BaseAdvisor_43_50)ADVISOR_43_50);
            return (org.hl7.fhir.r4.model.Coding)VersionConvertorFactory_40_50.convertType((DataType)r5coding, (BaseAdvisor_40_50)ADVISOR_40_50);
        }

        @Override
        public org.hl7.fhir.r4.model.CodeableConcept codeableConceptToCanonical(IBaseDatatype theCodeableConcept) {
            CodeableConcept r5coding = (CodeableConcept)VersionConvertorFactory_43_50.convertType((org.hl7.fhir.r4b.model.DataType)((org.hl7.fhir.r4b.model.CodeableConcept)theCodeableConcept), (BaseAdvisor_43_50)ADVISOR_43_50);
            return (org.hl7.fhir.r4.model.CodeableConcept)VersionConvertorFactory_40_50.convertType((DataType)r5coding, (BaseAdvisor_40_50)ADVISOR_40_50);
        }

        @Override
        public org.hl7.fhir.r4.model.ValueSet valueSetToCanonical(IBaseResource theValueSet) {
            ValueSet valueSetR5 = (ValueSet)VersionConvertorFactory_43_50.convertResource((org.hl7.fhir.r4b.model.Resource)((org.hl7.fhir.r4b.model.Resource)theValueSet), (BaseAdvisor_43_50)ADVISOR_43_50);
            return (org.hl7.fhir.r4.model.ValueSet)VersionConvertorFactory_40_50.convertResource((Resource)valueSetR5, (BaseAdvisor_40_50)ADVISOR_40_50);
        }

        @Override
        public CodeSystem codeSystemToCanonical(IBaseResource theCodeSystem) {
            org.hl7.fhir.r5.model.CodeSystem codeSystemR5 = (org.hl7.fhir.r5.model.CodeSystem)VersionConvertorFactory_43_50.convertResource((org.hl7.fhir.r4b.model.Resource)((org.hl7.fhir.r4b.model.Resource)theCodeSystem), (BaseAdvisor_43_50)ADVISOR_43_50);
            return (CodeSystem)VersionConvertorFactory_40_50.convertResource((Resource)codeSystemR5, (BaseAdvisor_40_50)ADVISOR_40_50);
        }

        @Override
        public IBaseResource valueSetFromCanonical(org.hl7.fhir.r4.model.ValueSet theValueSet) {
            ValueSet valueSetR5 = (ValueSet)VersionConvertorFactory_40_50.convertResource((org.hl7.fhir.r4.model.Resource)theValueSet, (BaseAdvisor_40_50)ADVISOR_40_50);
            return VersionConvertorFactory_43_50.convertResource((Resource)valueSetR5, (BaseAdvisor_43_50)ADVISOR_43_50);
        }

        @Override
        public IBaseResource codeSystemFromCanonical(CodeSystem theCodeSystem) {
            org.hl7.fhir.r5.model.CodeSystem codeSystemR5 = (org.hl7.fhir.r5.model.CodeSystem)VersionConvertorFactory_40_50.convertResource((org.hl7.fhir.r4.model.Resource)theCodeSystem, (BaseAdvisor_40_50)ADVISOR_40_50);
            return VersionConvertorFactory_43_50.convertResource((Resource)codeSystemR5, (BaseAdvisor_43_50)ADVISOR_43_50);
        }

        @Override
        public ConceptMap conceptMapToCanonical(IBaseResource theConceptMap) {
            org.hl7.fhir.r5.model.ConceptMap conceptMapR5 = (org.hl7.fhir.r5.model.ConceptMap)VersionConvertorFactory_43_50.convertResource((org.hl7.fhir.r4b.model.Resource)((org.hl7.fhir.r4b.model.Resource)theConceptMap), (BaseAdvisor_43_50)ADVISOR_43_50);
            return (ConceptMap)VersionConvertorFactory_40_50.convertResource((Resource)conceptMapR5, (BaseAdvisor_40_50)ADVISOR_40_50);
        }

        @Override
        public IBaseResource conceptMapFromCanonical(ConceptMap theConceptMap) {
            org.hl7.fhir.r5.model.ConceptMap conceptMapR5 = (org.hl7.fhir.r5.model.ConceptMap)VersionConvertorFactory_40_50.convertResource((org.hl7.fhir.r4.model.Resource)theConceptMap, (BaseAdvisor_40_50)ADVISOR_40_50);
            return VersionConvertorFactory_43_50.convertResource((Resource)conceptMapR5, (BaseAdvisor_43_50)ADVISOR_43_50);
        }

        @Override
        public SearchParameter searchParameterToCanonical(IBaseResource theSearchParameter) {
            return (SearchParameter)VersionConvertorFactory_43_50.convertResource((org.hl7.fhir.r4b.model.Resource)((org.hl7.fhir.r4b.model.Resource)theSearchParameter), (BaseAdvisor_43_50)ADVISOR_43_50);
        }

        @Override
        public IBaseParameters parametersFromCanonical(Parameters theParameters) {
            org.hl7.fhir.r5.model.Parameters parametersR5 = (org.hl7.fhir.r5.model.Parameters)VersionConvertorFactory_40_50.convertResource((org.hl7.fhir.r4.model.Resource)theParameters, (BaseAdvisor_40_50)ADVISOR_40_50);
            return (IBaseParameters)VersionConvertorFactory_43_50.convertResource((Resource)parametersR5, (BaseAdvisor_43_50)ADVISOR_43_50);
        }

        @Override
        public StructureDefinition structureDefinitionToCanonical(IBaseResource theResource) {
            return (StructureDefinition)VersionConvertorFactory_43_50.convertResource((org.hl7.fhir.r4b.model.Resource)((org.hl7.fhir.r4b.model.Resource)theResource), (BaseAdvisor_43_50)ADVISOR_43_50);
        }

        @Override
        public IBaseResource structureDefinitionFromCanonical(StructureDefinition theResource) {
            return VersionConvertorFactory_43_50.convertResource((Resource)theResource, (BaseAdvisor_43_50)ADVISOR_43_50);
        }

        @Override
        public IBaseResource valueSetFromValidatorCanonical(ValueSet theResource) {
            return VersionConvertorFactory_43_50.convertResource((Resource)theResource, (BaseAdvisor_43_50)ADVISOR_43_50);
        }

        @Override
        public Resource resourceToValidatorCanonical(IBaseResource theResource) {
            return VersionConvertorFactory_43_50.convertResource((org.hl7.fhir.r4b.model.Resource)((org.hl7.fhir.r4b.model.Resource)theResource), (BaseAdvisor_43_50)ADVISOR_43_50);
        }

        @Override
        public ValueSet valueSetToValidatorCanonical(IBaseResource theResource) {
            return (ValueSet)VersionConvertorFactory_43_50.convertResource((org.hl7.fhir.r4b.model.Resource)((org.hl7.fhir.r4b.model.Resource)theResource), (BaseAdvisor_43_50)ADVISOR_43_50);
        }

        @Override
        public org.hl7.fhir.r5.model.CodeSystem codeSystemToValidatorCanonical(IBaseResource theResource) {
            return (org.hl7.fhir.r5.model.CodeSystem)VersionConvertorFactory_43_50.convertResource((org.hl7.fhir.r4b.model.Resource)((org.hl7.fhir.r4b.model.Resource)theResource), (BaseAdvisor_43_50)ADVISOR_43_50);
        }

        @Override
        public IBaseResource searchParameterFromCanonical(SearchParameter theResource) {
            return VersionConvertorFactory_43_50.convertResource((Resource)theResource, (BaseAdvisor_43_50)ADVISOR_43_50);
        }

        @Override
        public IBaseResource auditEventFromCanonical(AuditEvent theResource) {
            org.hl7.fhir.r5.model.AuditEvent r5 = (org.hl7.fhir.r5.model.AuditEvent)VersionConvertorFactory_40_50.convertResource((org.hl7.fhir.r4.model.Resource)theResource, (BaseAdvisor_40_50)ADVISOR_40_50);
            return VersionConvertorFactory_43_50.convertResource((Resource)r5, (BaseAdvisor_43_50)ADVISOR_43_50);
        }

        @Override
        public IBaseConformance capabilityStatementFromCanonical(CapabilityStatement theResource) {
            return (IBaseConformance)VersionConvertorFactory_43_50.convertResource((Resource)theResource, (BaseAdvisor_43_50)ADVISOR_43_50);
        }
    }

    private static class R5Strategy
    implements IStrategy {
        private R5Strategy() {
        }

        @Override
        public CapabilityStatement capabilityStatementToCanonical(IBaseResource theCapabilityStatement) {
            return (CapabilityStatement)theCapabilityStatement;
        }

        @Override
        public org.hl7.fhir.r4.model.Coding codingToCanonical(IBaseCoding theCoding) {
            return (org.hl7.fhir.r4.model.Coding)VersionConvertorFactory_40_50.convertType((DataType)((Coding)theCoding), (BaseAdvisor_40_50)ADVISOR_40_50);
        }

        @Override
        public org.hl7.fhir.r4.model.CodeableConcept codeableConceptToCanonical(IBaseDatatype theCodeableConcept) {
            return (org.hl7.fhir.r4.model.CodeableConcept)VersionConvertorFactory_40_50.convertType((DataType)((CodeableConcept)theCodeableConcept), (BaseAdvisor_40_50)ADVISOR_40_50);
        }

        @Override
        public org.hl7.fhir.r4.model.ValueSet valueSetToCanonical(IBaseResource theValueSet) {
            return (org.hl7.fhir.r4.model.ValueSet)VersionConvertorFactory_40_50.convertResource((Resource)((ValueSet)theValueSet), (BaseAdvisor_40_50)ADVISOR_40_50);
        }

        @Override
        public CodeSystem codeSystemToCanonical(IBaseResource theCodeSystem) {
            return (CodeSystem)VersionConvertorFactory_40_50.convertResource((Resource)((org.hl7.fhir.r5.model.CodeSystem)theCodeSystem), (BaseAdvisor_40_50)ADVISOR_40_50);
        }

        @Override
        public IBaseResource valueSetFromCanonical(org.hl7.fhir.r4.model.ValueSet theValueSet) {
            return VersionConvertorFactory_40_50.convertResource((org.hl7.fhir.r4.model.Resource)theValueSet, (BaseAdvisor_40_50)ADVISOR_40_50);
        }

        @Override
        public IBaseResource codeSystemFromCanonical(CodeSystem theCodeSystem) {
            return VersionConvertorFactory_40_50.convertResource((org.hl7.fhir.r4.model.Resource)theCodeSystem, (BaseAdvisor_40_50)ADVISOR_40_50);
        }

        @Override
        public ConceptMap conceptMapToCanonical(IBaseResource theConceptMap) {
            return (ConceptMap)VersionConvertorFactory_40_50.convertResource((Resource)((org.hl7.fhir.r5.model.ConceptMap)theConceptMap), (BaseAdvisor_40_50)ADVISOR_40_50);
        }

        @Override
        public IBaseResource conceptMapFromCanonical(ConceptMap theConceptMap) {
            return VersionConvertorFactory_40_50.convertResource((org.hl7.fhir.r4.model.Resource)theConceptMap, (BaseAdvisor_40_50)ADVISOR_40_50);
        }

        @Override
        public SearchParameter searchParameterToCanonical(IBaseResource theSearchParameter) {
            return (SearchParameter)theSearchParameter;
        }

        @Override
        public IBaseParameters parametersFromCanonical(Parameters theParameters) {
            return (IBaseParameters)VersionConvertorFactory_40_50.convertResource((org.hl7.fhir.r4.model.Resource)theParameters, (BaseAdvisor_40_50)ADVISOR_40_50);
        }

        @Override
        public StructureDefinition structureDefinitionToCanonical(IBaseResource theResource) {
            return (StructureDefinition)theResource;
        }

        @Override
        public IBaseResource structureDefinitionFromCanonical(StructureDefinition theResource) {
            return theResource;
        }

        @Override
        public IBaseResource valueSetFromValidatorCanonical(ValueSet theResource) {
            return theResource;
        }

        @Override
        public Resource resourceToValidatorCanonical(IBaseResource theResource) {
            return (Resource)theResource;
        }

        @Override
        public ValueSet valueSetToValidatorCanonical(IBaseResource theResource) {
            return (ValueSet)theResource;
        }

        @Override
        public org.hl7.fhir.r5.model.CodeSystem codeSystemToValidatorCanonical(IBaseResource theResource) {
            return (org.hl7.fhir.r5.model.CodeSystem)theResource;
        }

        @Override
        public IBaseResource searchParameterFromCanonical(SearchParameter theResource) {
            return theResource;
        }

        @Override
        public IBaseResource auditEventFromCanonical(AuditEvent theResource) {
            return VersionConvertorFactory_40_50.convertResource((org.hl7.fhir.r4.model.Resource)theResource, (BaseAdvisor_40_50)ADVISOR_40_50);
        }

        @Override
        public IBaseConformance capabilityStatementFromCanonical(CapabilityStatement theResource) {
            return theResource;
        }
    }
}

