/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hapi.converters.canonical;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_43_50;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Basic;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4b.model.Resource;
import org.hl7.fhir.r4b.model.SubscriptionTopic;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.SubscriptionTopic;

public final class SubscriptionTopicCanonicalizer {
    private SubscriptionTopicCanonicalizer() {
    }

    public static org.hl7.fhir.r5.model.SubscriptionTopic canonicalizeTopic(FhirContext theFhirContext, IBaseResource theSubscriptionTopic) {
        switch (theFhirContext.getVersion().getVersion()) {
            case R4: {
                if (theSubscriptionTopic instanceof Basic) {
                    return SubscriptionTopicCanonicalizer.canonicalizeR4BasicTopic((Basic)theSubscriptionTopic);
                }
                throw new UnsupportedOperationException(Msg.code((int)2337) + "Unsupported R4 resource type for subscription topic: " + theSubscriptionTopic.getClass().getSimpleName());
            }
            case R4B: {
                return (org.hl7.fhir.r5.model.SubscriptionTopic)VersionConvertorFactory_43_50.convertResource((Resource)((SubscriptionTopic)theSubscriptionTopic));
            }
            case R5: {
                return (org.hl7.fhir.r5.model.SubscriptionTopic)theSubscriptionTopic;
            }
        }
        throw new UnsupportedOperationException(Msg.code((int)2651) + "Subscription topics are not supported in FHIR version " + String.valueOf(theFhirContext.getVersion().getVersion()));
    }

    private static org.hl7.fhir.r5.model.SubscriptionTopic canonicalizeR4BasicTopic(Basic theBasicTopic) {
        String url;
        org.hl7.fhir.r5.model.SubscriptionTopic retVal = new org.hl7.fhir.r5.model.SubscriptionTopic();
        retVal.setId(theBasicTopic.getIdElement().getIdPart());
        for (Extension extension : theBasicTopic.getExtension()) {
            url = extension.getUrl();
            if ("http://hl7.org/fhir/5.0/StructureDefinition/extension-SubscriptionTopic.url".equals(url)) {
                retVal.setUrl(extension.getValue().primitiveValue());
                continue;
            }
            if ("http://hl7.org/fhir/5.0/StructureDefinition/extension-SubscriptionTopic.version".equals(url)) {
                retVal.setVersion(extension.getValue().primitiveValue());
                continue;
            }
            if ("http://hl7.org/fhir/5.0/StructureDefinition/extension-SubscriptionTopic.name".equals(url)) {
                retVal.setName(extension.getValue().primitiveValue());
                continue;
            }
            if ("http://hl7.org/fhir/5.0/StructureDefinition/extension-SubscriptionTopic.title".equals(url)) {
                retVal.setTitle(extension.getValue().primitiveValue());
                continue;
            }
            if ("http://hl7.org/fhir/5.0/StructureDefinition/extension-SubscriptionTopic.date".equals(url)) {
                retVal.setDateElement(new DateTimeType(extension.getValue().primitiveValue()));
                continue;
            }
            if ("http://hl7.org/fhir/5.0/StructureDefinition/extension-SubscriptionTopic.description".equals(url)) {
                retVal.setDescription(extension.getValue().primitiveValue());
                continue;
            }
            if ("http://hl7.org/fhir/4.3/StructureDefinition/extension-SubscriptionTopic.resourceTrigger".equals(url)) {
                SubscriptionTopicCanonicalizer.processResourceTrigger(extension, retVal);
                continue;
            }
            if ("http://hl7.org/fhir/4.3/StructureDefinition/extension-SubscriptionTopic.canFilterBy".equals(url)) {
                SubscriptionTopicCanonicalizer.processCanFilterBy(extension, retVal);
                continue;
            }
            if (!"http://hl7.org/fhir/4.3/StructureDefinition/extension-SubscriptionTopic.notificationShape".equals(url)) continue;
            SubscriptionTopicCanonicalizer.processNotificationShape(extension, retVal);
        }
        for (Extension extension : theBasicTopic.getModifierExtension()) {
            url = extension.getUrl();
            if (!"http://hl7.org/fhir/5.0/StructureDefinition/extension-SubscriptionTopic.status".equals(url)) continue;
            String statusCode = extension.getValue().primitiveValue();
            retVal.setStatus(Enumerations.PublicationStatus.fromCode((String)statusCode));
        }
        return retVal;
    }

    private static void processResourceTrigger(Extension theExtension, org.hl7.fhir.r5.model.SubscriptionTopic theTopic) {
        SubscriptionTopic.SubscriptionTopicResourceTriggerComponent trigger = new SubscriptionTopic.SubscriptionTopicResourceTriggerComponent();
        for (Extension ext : theExtension.getExtension()) {
            String url = ext.getUrl();
            if ("description".equals(url)) {
                trigger.setDescription(ext.getValue().primitiveValue());
                continue;
            }
            if ("resource".equals(url)) {
                trigger.setResource(ext.getValue().primitiveValue());
                continue;
            }
            if ("supportedInteraction".equals(url)) {
                trigger.addSupportedInteraction(SubscriptionTopic.InteractionTrigger.fromCode((String)ext.getValue().primitiveValue()));
                continue;
            }
            if ("fhirPathCriteria".equals(url)) {
                trigger.setFhirPathCriteria(ext.getValue().primitiveValue());
                continue;
            }
            if (!"queryCriteria".equals(url)) continue;
            SubscriptionTopicCanonicalizer.processQueryCriteria(ext, trigger);
        }
        theTopic.addResourceTrigger(trigger);
    }

    private static void processQueryCriteria(Extension theQueryCriteriaExtension, SubscriptionTopic.SubscriptionTopicResourceTriggerComponent theTrigger) {
        SubscriptionTopic.SubscriptionTopicResourceTriggerQueryCriteriaComponent queryCriteria = new SubscriptionTopic.SubscriptionTopicResourceTriggerQueryCriteriaComponent();
        for (Extension ext : theQueryCriteriaExtension.getExtension()) {
            String url = ext.getUrl();
            if ("previous".equals(url)) {
                queryCriteria.setPrevious(ext.getValue().primitiveValue());
                continue;
            }
            if ("current".equals(url)) {
                queryCriteria.setCurrent(ext.getValue().primitiveValue());
                continue;
            }
            if (!"requireBoth".equals(url)) continue;
            queryCriteria.setRequireBoth(Boolean.parseBoolean(ext.getValue().primitiveValue()));
        }
        theTrigger.setQueryCriteria(queryCriteria);
    }

    private static void processCanFilterBy(Extension theExtension, org.hl7.fhir.r5.model.SubscriptionTopic theTopic) {
        SubscriptionTopic.SubscriptionTopicCanFilterByComponent filterBy = new SubscriptionTopic.SubscriptionTopicCanFilterByComponent();
        for (Extension ext : theExtension.getExtension()) {
            String url = ext.getUrl();
            if ("description".equals(url)) {
                filterBy.setDescription(ext.getValue().primitiveValue());
                continue;
            }
            if ("resource".equals(url)) {
                filterBy.setResource(ext.getValue().primitiveValue());
                continue;
            }
            if (!"filterParameter".equals(url)) continue;
            filterBy.setFilterParameter(ext.getValue().primitiveValue());
        }
        theTopic.addCanFilterBy(filterBy);
    }

    private static void processNotificationShape(Extension theExtension, org.hl7.fhir.r5.model.SubscriptionTopic theTopic) {
        SubscriptionTopic.SubscriptionTopicNotificationShapeComponent shape = new SubscriptionTopic.SubscriptionTopicNotificationShapeComponent();
        for (Extension ext : theExtension.getExtension()) {
            String url = ext.getUrl();
            if ("resource".equals(url)) {
                shape.setResource(ext.getValue().primitiveValue());
                continue;
            }
            if ("include".equals(url)) {
                shape.addInclude(ext.getValue().primitiveValue());
                continue;
            }
            if (!"revInclude".equals(url)) continue;
            shape.addRevInclude(ext.getValue().primitiveValue());
        }
        theTopic.addNotificationShape(shape);
    }
}

