/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.annotation.ConditionalUrlParam;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.client.method.IParameter;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseResource;

class ConditionalParamBinder
implements IParameter {
    private boolean mySupportsMultiple;

    ConditionalParamBinder(RestOperationTypeEnum theOperationType, boolean theSupportsMultiple) {
        Validate.notNull((Object)theOperationType, (String)"theOperationType can not be null", (Object[])new Object[0]);
        this.mySupportsMultiple = theSupportsMultiple;
    }

    @Override
    public void initializeTypes(Method theMethod, Class<? extends Collection<?>> theOuterCollectionType, Class<? extends Collection<?>> theInnerCollectionType, Class<?> theParameterType) {
        if (theOuterCollectionType != null || theInnerCollectionType != null || !theParameterType.equals(String.class)) {
            throw new ConfigurationException(Msg.code((int)1439) + "Parameters annotated with @" + ConditionalUrlParam.class.getSimpleName() + " must be of type String, found incorrect parameter in method \"" + String.valueOf(theMethod) + "\"");
        }
    }

    public boolean isSupportsMultiple() {
        return this.mySupportsMultiple;
    }

    @Override
    public void translateClientArgumentIntoQueryArgument(FhirContext theContext, Object theSourceClientArgument, Map<String, List<String>> theTargetQueryArguments, IBaseResource theTargetResource) throws InternalErrorException {
        throw new UnsupportedOperationException(Msg.code((int)1440) + "Can not use @" + this.getClass().getName() + " annotated parameters in client");
    }
}

