/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.annotation.Sort;
import ca.uhn.fhir.rest.api.SortOrderEnum;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.client.method.IParameter;
import ca.uhn.fhir.rest.param.ParameterUtil;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class SortParameter
implements IParameter {
    private FhirContext myContext;

    public SortParameter(FhirContext theContext) {
        this.myContext = theContext;
    }

    @Override
    public void initializeTypes(Method theMethod, Class<? extends Collection<?>> theOuterCollectionType, Class<? extends Collection<?>> theInnerCollectionType, Class<?> theParameterType) {
        if (theOuterCollectionType != null || theInnerCollectionType != null) {
            throw new ConfigurationException(Msg.code((int)1463) + "Method '" + theMethod.getName() + "' in type '" + theMethod.getDeclaringClass().getCanonicalName() + "' is annotated with @" + Sort.class.getName() + " but can not be of collection type");
        }
        if (!theParameterType.equals(SortSpec.class)) {
            throw new ConfigurationException(Msg.code((int)1464) + "Method '" + theMethod.getName() + "' in type '" + theMethod.getDeclaringClass().getCanonicalName() + "' is annotated with @" + Sort.class.getName() + " but is an invalid type, must be: " + SortSpec.class.getCanonicalName());
        }
    }

    @Override
    public void translateClientArgumentIntoQueryArgument(FhirContext theContext, Object theSourceClientArgument, Map<String, List<String>> theTargetQueryArguments, IBaseResource theTargetResource) throws InternalErrorException {
        if (this.myContext.getVersion().getVersion().isNewerThan(FhirVersionEnum.DSTU2)) {
            String string = SortParameter.createSortStringDstu3(ss);
            if (string.length() > 0) {
                if (!theTargetQueryArguments.containsKey("_sort")) {
                    theTargetQueryArguments.put("_sort", new ArrayList());
                }
                theTargetQueryArguments.get("_sort").add(string);
            }
        } else {
            for (ss = (SortSpec)theSourceClientArgument; ss != null; ss = ss.getChain()) {
                String name = ss.getOrder() == null ? "_sort" : (ss.getOrder() == SortOrderEnum.ASC ? "_sort:asc" : "_sort:desc");
                if (ss.getParamName() == null) continue;
                if (!theTargetQueryArguments.containsKey(name)) {
                    theTargetQueryArguments.put(name, new ArrayList());
                }
                theTargetQueryArguments.get(name).add(ss.getParamName());
            }
        }
    }

    public static String createSortStringDstu3(SortSpec ss) {
        StringBuilder val = new StringBuilder();
        while (ss != null) {
            if (StringUtils.isNotBlank((CharSequence)ss.getParamName())) {
                if (val.length() > 0) {
                    val.append(',');
                }
                if (ss.getOrder() == SortOrderEnum.DESC) {
                    val.append('-');
                }
                val.append(ParameterUtil.escape((String)ss.getParamName()));
            }
            ss = ss.getChain();
        }
        String string = val.toString();
        return string;
    }
}

