/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.sl.cache.caffeine;

import ca.uhn.fhir.sl.cache.Cache;
import ca.uhn.fhir.sl.cache.CacheLoader;
import ca.uhn.fhir.sl.cache.LoadingCache;
import ca.uhn.fhir.sl.cache.caffeine.CacheDelegator;
import ca.uhn.fhir.sl.cache.caffeine.LoadingCacheDelegator;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.TimeUnit;

public class CacheProvider<K, V>
implements ca.uhn.fhir.sl.cache.CacheProvider<K, V> {
    public Cache<K, V> create(long timeoutMillis) {
        return new CacheDelegator(Caffeine.newBuilder().expireAfterWrite(timeoutMillis, TimeUnit.MILLISECONDS).build());
    }

    public LoadingCache<K, V> create(long timeoutMillis, CacheLoader<K, V> loading) {
        return new LoadingCacheDelegator(Caffeine.newBuilder().expireAfterWrite(timeoutMillis, TimeUnit.MILLISECONDS).build(arg_0 -> loading.load(arg_0)));
    }

    public Cache<K, V> create(long timeoutMillis, long maximumSize) {
        return new CacheDelegator(Caffeine.newBuilder().expireAfterWrite(timeoutMillis, TimeUnit.MILLISECONDS).initialCapacity((int)maximumSize).maximumSize(maximumSize).build());
    }

    public Cache<K, V> createEternal(int minimumSize, long maximumSize) {
        return new CacheDelegator(Caffeine.newBuilder().initialCapacity(minimumSize).maximumSize(maximumSize).build());
    }

    public LoadingCache<K, V> create(long timeoutMillis, long maximumSize, CacheLoader<K, V> loading) {
        return new LoadingCacheDelegator(Caffeine.newBuilder().expireAfterWrite(timeoutMillis, TimeUnit.MILLISECONDS).initialCapacity((int)maximumSize).maximumSize(maximumSize).build(arg_0 -> loading.load(arg_0)));
    }
}

