/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util.bundle;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.util.ElementUtil;
import ca.uhn.fhir.util.bundle.PartsConverter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Date;
import java.util.Objects;
import java.util.function.Function;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public record BundleResponseEntryParts(String fullUrl, IBaseResource resource, String responseStatus, String responseLocation, String responseEtag, IPrimitiveType<Date> responseLastModified, IBaseResource responseOutcome) {
    public static Function<IBase, BundleResponseEntryParts> buildPartsExtractor(FhirContext theFhirContext) {
        PartsConverter<BundleResponseEntryParts> m = BundleResponseEntryParts.getConverter(theFhirContext);
        return m::fromElement;
    }

    @Nonnull
    public static PartsConverter<BundleResponseEntryParts> getConverter(FhirContext theFhirContext) {
        return new Metadata(theFhirContext);
    }

    public static Function<BundleResponseEntryParts, IBase> builder(FhirContext theFhirContext) {
        PartsConverter<BundleResponseEntryParts> m = BundleResponseEntryParts.getConverter(theFhirContext);
        return m::toElement;
    }

    static class Metadata
    implements PartsConverter<BundleResponseEntryParts> {
        private final BaseRuntimeChildDefinition myFullUrlChildDef;
        private final BaseRuntimeChildDefinition myResourceChildDef;
        private final BaseRuntimeChildDefinition myResponseChildDef;
        private final BaseRuntimeChildDefinition myResponseOutcomeChildDef;
        private final BaseRuntimeChildDefinition myResponseStatusChildDef;
        private final BaseRuntimeChildDefinition myResponseLocation;
        private final BaseRuntimeChildDefinition myResponseEtag;
        private final BaseRuntimeChildDefinition myResponseLastModified;
        private final BaseRuntimeElementCompositeDefinition<?> myEntryElementDef;
        private final BaseRuntimeElementCompositeDefinition<?> myResponseChildContentsDef;

        private Metadata(FhirContext theFhirContext) {
            BaseRuntimeChildDefinition entryChildDef = theFhirContext.getResourceDefinition("Bundle").getChildByName("entry");
            this.myEntryElementDef = (BaseRuntimeElementCompositeDefinition)entryChildDef.getChildByName("entry");
            this.myFullUrlChildDef = this.myEntryElementDef.getChildByName("fullUrl");
            this.myResourceChildDef = this.myEntryElementDef.getChildByName("resource");
            this.myResponseChildDef = this.myEntryElementDef.getChildByName("response");
            this.myResponseChildContentsDef = (BaseRuntimeElementCompositeDefinition)this.myResponseChildDef.getChildByName("response");
            this.myResponseOutcomeChildDef = this.myResponseChildContentsDef.getChildByName("outcome");
            this.myResponseStatusChildDef = this.myResponseChildContentsDef.getChildByName("status");
            this.myResponseLocation = this.myResponseChildContentsDef.getChildByName("location");
            this.myResponseEtag = this.myResponseChildContentsDef.getChildByName("etag");
            this.myResponseLastModified = this.myResponseChildContentsDef.getChildByName("lastModified");
        }

        @Override
        @Nullable
        public BundleResponseEntryParts fromElement(IBase base) {
            if (base == null) {
                return null;
            }
            IBase response = (IBase)ElementUtil.getSingleValueOrNull(base, this.myResponseChildDef, Function.identity());
            return new BundleResponseEntryParts(ElementUtil.getSingleValueOrNull(base, this.myFullUrlChildDef, ElementUtil.CONVERT_PRIMITIVE_TO_STRING), ElementUtil.getSingleValueOrNull(base, this.myResourceChildDef, ElementUtil.CAST_BASE_TO_RESOURCE), ElementUtil.getSingleValueOrNull(response, this.myResponseStatusChildDef, ElementUtil.CONVERT_PRIMITIVE_TO_STRING), ElementUtil.getSingleValueOrNull(response, this.myResponseLocation, ElementUtil.CONVERT_PRIMITIVE_TO_STRING), ElementUtil.getSingleValueOrNull(response, this.myResponseEtag, ElementUtil.CONVERT_PRIMITIVE_TO_STRING), ElementUtil.getSingleValueOrNull(response, this.myResponseLastModified, ElementUtil.CAST_TO_PRIMITIVE_DATE), ElementUtil.getSingleValueOrNull(response, this.myResponseOutcomeChildDef, ElementUtil.CAST_BASE_TO_RESOURCE));
        }

        @Override
        public IBase toElement(BundleResponseEntryParts theParts) {
            Objects.requireNonNull(theParts);
            Object entry = this.myEntryElementDef.newInstance();
            ElementUtil.setValue(entry, this.myFullUrlChildDef, theParts.fullUrl());
            ElementUtil.setValue(entry, this.myResourceChildDef, theParts.resource());
            Object response = this.myResponseChildContentsDef.newInstance();
            ElementUtil.setValue(entry, this.myResponseChildDef, response);
            ElementUtil.setValue(response, this.myResponseStatusChildDef, theParts.responseStatus());
            ElementUtil.setValue(response, this.myResponseLocation, theParts.responseLocation());
            ElementUtil.setValue(response, this.myResponseEtag, theParts.responseEtag());
            ElementUtil.setValue(response, this.myResponseLastModified, theParts.responseLastModified());
            ElementUtil.setValue(response, this.myResponseOutcomeChildDef, theParts.responseOutcome());
            return entry;
        }
    }
}

