/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.api;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.api.SortOrderEnum;
import java.io.Serializable;
import java.util.Objects;

public class SortSpec
implements Serializable {
    private static final long serialVersionUID = 2866833099879713467L;
    private SortSpec myChain;
    private String myParamName;
    private SortOrderEnum myOrder;

    public SortSpec() {
    }

    public SortSpec(String theParamName) {
        this.myParamName = theParamName;
    }

    public SortSpec(String theParamName, SortOrderEnum theOrder) {
        this.myParamName = theParamName;
        this.myOrder = theOrder;
    }

    public SortSpec(String theParamName, SortOrderEnum theOrder, SortSpec theChain) {
        this.myParamName = theParamName;
        this.myOrder = theOrder;
        this.myChain = theChain;
    }

    public SortSpec getChain() {
        return this.myChain;
    }

    public SortSpec setChain(SortSpec theChain) {
        if (theChain == this) {
            throw new IllegalArgumentException(Msg.code(1966) + "Can not chain this to itself");
        }
        this.myChain = theChain;
        return this;
    }

    public String getParamName() {
        return this.myParamName;
    }

    public SortSpec setParamName(String theFieldName) {
        this.myParamName = theFieldName;
        return this;
    }

    public SortOrderEnum getOrder() {
        return this.myOrder;
    }

    public SortSpec setOrder(SortOrderEnum theOrder) {
        this.myOrder = theOrder;
        return this;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.getParamName());
        if (this.getOrder() != null) {
            b.append('(').append((Object)this.getOrder()).append(')');
        }
        if (this.myChain != null) {
            b.append(',').append(this.myChain);
        }
        return b.toString();
    }

    public boolean equals(Object theO) {
        if (!(theO instanceof SortSpec)) {
            return false;
        }
        SortSpec sortSpec = (SortSpec)theO;
        return Objects.equals(this.myChain, sortSpec.myChain) && Objects.equals(this.myParamName, sortSpec.myParamName) && this.myOrder == sortSpec.myOrder;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.myChain, this.myParamName, this.myOrder});
    }
}

