/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.parser;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeDeclaredChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeChildContainedResources;
import ca.uhn.fhir.context.RuntimeChildDirectResource;
import ca.uhn.fhir.context.RuntimeChildExtension;
import ca.uhn.fhir.context.RuntimeChildNarrativeDefinition;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.narrative.INarrativeGenerator;
import ca.uhn.fhir.parser.BaseParser;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.parser.IParserErrorHandler;
import ca.uhn.fhir.parser.ParserState;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.util.rdf.RDFUtil;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.irix.IRIs;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.riot.Lang;
import org.apache.jena.sys.JenaSystem;
import org.apache.jena.vocabulary.RDF;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseDatatypeElement;
import org.hl7.fhir.instance.model.api.IBaseElement;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IBaseXhtml;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.INarrative;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDFParser
extends BaseParser {
    private static final String VALUE = "value";
    private static final String FHIR_INDEX = "index";
    private static final String FHIR_PREFIX = "fhir";
    private static final String FHIR_NS = "http://hl7.org/fhir/";
    private static final String RDF_PREFIX = "rdf";
    private static final String RDF_NS = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    private static final String RDFS_PREFIX = "rdfs";
    private static final String RDFS_NS = "http://www.w3.org/2000/01/rdf-schema#";
    private static final String XSD_PREFIX = "xsd";
    private static final String XSD_NS = "http://www.w3.org/2001/XMLSchema#";
    private static final String SCT_PREFIX = "sct";
    private static final String SCT_NS = "http://snomed.info/id#";
    private static final String EXTENSION_URL = "Extension.url";
    private static final String ELEMENT_EXTENSION = "Element.extension";
    private static final Logger logger = LoggerFactory.getLogger(RDFParser.class);
    public static final String NODE_ROLE = "nodeRole";
    private static final List<String> ignoredPredicates;
    public static final String TREE_ROOT = "treeRoot";
    public static final String RESOURCE_ID = "Resource.id";
    public static final String ID = "id";
    public static final String ELEMENT_ID = "Element.id";
    public static final String DOMAIN_RESOURCE_CONTAINED = "DomainResource.contained";
    public static final String EXTENSION = "extension";
    public static final String CONTAINED = "contained";
    public static final String MODIFIER_EXTENSION = "modifierExtension";
    private final Map<Class, String> classToFhirTypeMap = new HashMap<Class, String>();
    private final Lang lang;

    public RDFParser(FhirContext context, IParserErrorHandler parserErrorHandler, Lang lang) {
        super(context, parserErrorHandler);
        this.lang = lang;
    }

    @Override
    public EncodingEnum getEncoding() {
        return EncodingEnum.RDF;
    }

    @Override
    public IParser setPrettyPrint(boolean prettyPrint) {
        return this;
    }

    @Override
    protected void doEncodeResourceToWriter(IBaseResource resource, Writer writer, BaseParser.EncodeContext encodeContext) {
        Model rdfModel = RDFUtil.initializeRDFModel();
        HashMap<String, String> prefixes = new HashMap<String, String>();
        prefixes.put(RDF_PREFIX, RDF_NS);
        prefixes.put(RDFS_PREFIX, RDFS_NS);
        prefixes.put(XSD_PREFIX, XSD_NS);
        prefixes.put(FHIR_PREFIX, FHIR_NS);
        prefixes.put(SCT_PREFIX, SCT_NS);
        for (String key : prefixes.keySet()) {
            rdfModel.setNsPrefix(key, (String)prefixes.get(key));
        }
        IIdType resourceId = this.processResourceID(resource, encodeContext);
        this.encodeResourceToRDFStreamWriter(resource, rdfModel, false, resourceId, encodeContext, true, null);
        try {
            RDFUtil.writeRDFModel(writer, rdfModel, this.lang);
        }
        catch (Exception e) {
            throw new DataFormatException(Msg.code(2618) + "Error writing RDF model to writer", e);
        }
    }

    @Override
    protected <T extends IBaseResource> T doParseResource(Class<T> resourceType, Reader reader) throws DataFormatException {
        Model model = null;
        try {
            model = RDFUtil.readRDFToModel(reader, this.lang);
        }
        catch (Exception e) {
            throw new DataFormatException(Msg.code(2619) + "Error reading RDF model from reader", e);
        }
        return this.parseResource(resourceType, model);
    }

    private Resource encodeResourceToRDFStreamWriter(IBaseResource resource, Model rdfModel, boolean containedResource, IIdType resourceId, BaseParser.EncodeContext encodeContext, boolean rootResource, Resource parentResource) {
        RuntimeResourceDefinition resDef = this.getContext().getResourceDefinition(resource);
        if (resDef == null) {
            throw new ConfigurationException(Msg.code(1845) + "Unknown resource type: " + String.valueOf(resource.getClass()));
        }
        if (!containedResource) {
            this.containResourcesInReferences(resource, encodeContext);
        }
        if (!(resource instanceof IAnyResource)) {
            throw new IllegalStateException(Msg.code(1846) + "Unsupported resource found: " + resource.getClass().getName());
        }
        Object uriBase = resource.getIdElement().getBaseUrl();
        if (uriBase == null) {
            uriBase = this.getServerBaseUrl();
        }
        if (uriBase == null) {
            uriBase = FHIR_NS;
        }
        if (!((String)uriBase).endsWith("/")) {
            uriBase = (String)uriBase + "/";
        }
        if (parentResource == null) {
            if (!resource.getIdElement().toUnqualified().hasIdPart()) {
                parentResource = rdfModel.getResource((String)null);
            } else {
                String resourceUri = IRIs.resolve((String)uriBase, (String)resource.getIdElement().toUnqualified().toString()).toString();
                parentResource = rdfModel.getResource(resourceUri);
            }
            if (parentResource != null && parentResource.listProperties().toList().size() > 0) {
                return parentResource;
            }
            if (parentResource == null) {
                return null;
            }
        }
        parentResource.addProperty(RDF.type, (RDFNode)rdfModel.createProperty(FHIR_NS + resDef.getName()));
        if (rootResource) {
            parentResource.addProperty(rdfModel.createProperty("http://hl7.org/fhir/nodeRole"), (RDFNode)rdfModel.createProperty("http://hl7.org/fhir/treeRoot"));
        }
        if (resourceId != null && resourceId.getIdPart() != null && !resourceId.getValue().startsWith("urn:")) {
            parentResource.addProperty(rdfModel.createProperty("http://hl7.org/fhir/Resource.id"), (RDFNode)this.createFhirValueBlankNode(rdfModel, resourceId.getIdPart()));
        }
        this.encodeCompositeElementToStreamWriter(resource, resource, rdfModel, parentResource, containedResource, new BaseParser.CompositeChildElement(resDef, encodeContext), encodeContext);
        return parentResource;
    }

    private Resource createFhirValueBlankNode(Model rdfModel, String value) {
        return this.createFhirValueBlankNode(rdfModel, value, XSDDatatype.XSDstring, null);
    }

    private Resource createFhirValueBlankNode(Model rdfModel, String value, XSDDatatype xsdDataType, Integer cardinalityIndex) {
        Resource fhirValueBlankNodeResource = rdfModel.createResource().addProperty(rdfModel.createProperty("http://hl7.org/fhir/value"), (RDFNode)rdfModel.createTypedLiteral(value, (RDFDatatype)xsdDataType));
        if (cardinalityIndex != null && cardinalityIndex > -1) {
            fhirValueBlankNodeResource.addProperty(rdfModel.createProperty("http://hl7.org/fhir/index"), (RDFNode)rdfModel.createTypedLiteral((Object)cardinalityIndex, (RDFDatatype)XSDDatatype.XSDinteger));
        }
        return fhirValueBlankNodeResource;
    }

    private String constructPredicateName(IBaseResource resource, BaseRuntimeChildDefinition definition, String childName, IBase parentElement) {
        BaseRuntimeDeclaredChildDefinition declaredDef;
        Class<?> declaringClass;
        String basePropertyName = FHIR_NS + resource.fhirType() + "." + childName;
        if (definition instanceof BaseRuntimeDeclaredChildDefinition && (declaringClass = (declaredDef = (BaseRuntimeDeclaredChildDefinition)definition).getField().getDeclaringClass()) != resource.getClass()) {
            String property = null;
            if (IBaseBackboneElement.class.isAssignableFrom(declaringClass) || IBaseDatatypeElement.class.isAssignableFrom(declaringClass)) {
                if (this.classToFhirTypeMap.containsKey(declaringClass)) {
                    property = this.classToFhirTypeMap.get(declaringClass);
                } else {
                    try {
                        IBase elem = (IBase)declaringClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        property = elem.fhirType();
                        this.classToFhirTypeMap.put(declaringClass, property);
                    }
                    catch (Exception ex) {
                        logger.debug("Error instantiating an " + declaringClass.getSimpleName() + " to retrieve its FhirType");
                    }
                }
            } else {
                property = "MetadataResource".equals(declaringClass.getSimpleName()) ? resource.getClass().getSimpleName() : declaredDef.getField().getDeclaringClass().getSimpleName();
            }
            String classBasedPropertyName = FHIR_NS + property + "." + childName;
            return classBasedPropertyName;
        }
        return basePropertyName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Model encodeChildElementToStreamWriter(IBaseResource resource, IBase parentElement, Model rdfModel, Resource rdfResource, BaseRuntimeChildDefinition childDefinition, IBase element, String childName, BaseRuntimeElementDefinition<?> childDef, boolean includedResource, BaseParser.CompositeChildElement parent, BaseParser.EncodeContext theEncodeContext, Integer cardinalityIndex) {
        String childGenericName = childDefinition.getElementName();
        theEncodeContext.pushPath(childGenericName, false);
        try {
            if ((element == null || element.isEmpty()) && !this.isChildContained(childDef, includedResource, theEncodeContext)) {
                Model model = rdfModel;
                return model;
            }
            switch (childDef.getChildType()) {
                case ID_DATATYPE: {
                    String encodedValue;
                    IIdType value = (IIdType)element;
                    assert (value != null);
                    String string = encodedValue = ID.equals(childName) ? value.getIdPart() : value.getValue();
                    if (!StringUtils.isNotBlank((CharSequence)encodedValue) && RDFParser.hasNoExtensions(value) || !StringUtils.isNotBlank((CharSequence)encodedValue)) return rdfModel;
                    String propertyName = this.constructPredicateName(resource, childDefinition, childName, parentElement);
                    if (element == null) return rdfModel;
                    XSDDatatype dataType = this.getXSDDataTypeForFhirType(element.fhirType(), encodedValue);
                    rdfResource.addProperty(rdfModel.createProperty(propertyName), (RDFNode)this.createFhirValueBlankNode(rdfModel, encodedValue, dataType, cardinalityIndex));
                    return rdfModel;
                }
                case PRIMITIVE_DATATYPE: {
                    IBaseHasExtensions hasExtension;
                    IPrimitiveType pd = (IPrimitiveType)element;
                    assert (pd != null);
                    String value = pd.getValueAsString();
                    if (value == null && RDFParser.hasNoExtensions(pd) || value == null) return rdfModel;
                    String propertyName = this.constructPredicateName(resource, childDefinition, childName, parentElement);
                    XSDDatatype dataType = this.getXSDDataTypeForFhirType(pd.fhirType(), value);
                    Resource valueResource = this.createFhirValueBlankNode(rdfModel, value, dataType, cardinalityIndex);
                    if (!RDFParser.hasNoExtensions(pd) && (hasExtension = (IBaseHasExtensions)((Object)pd)).getExtension() != null && hasExtension.getExtension().size() > 0) {
                        int i = 0;
                        for (IBaseExtension<?, ?> extension : hasExtension.getExtension()) {
                            RuntimeResourceDefinition resDef = this.getContext().getResourceDefinition(resource);
                            Resource extensionResource = rdfModel.createResource();
                            extensionResource.addProperty(rdfModel.createProperty("http://hl7.org/fhir/index"), (RDFNode)rdfModel.createTypedLiteral((Object)i, (RDFDatatype)XSDDatatype.XSDinteger));
                            valueResource.addProperty(rdfModel.createProperty("http://hl7.org/fhir/Element.extension"), (RDFNode)extensionResource);
                            this.encodeCompositeElementToStreamWriter(resource, extension, rdfModel, extensionResource, false, new BaseParser.CompositeChildElement(resDef, theEncodeContext), theEncodeContext);
                        }
                    }
                    rdfResource.addProperty(rdfModel.createProperty(propertyName), (RDFNode)valueResource);
                    return rdfModel;
                }
                case RESOURCE_BLOCK: 
                case COMPOSITE_DATATYPE: {
                    String idString = null;
                    String idPredicate = null;
                    if (element instanceof IBaseResource) {
                        idPredicate = "http://hl7.org/fhir/Resource.id";
                        IIdType resourceId = this.processResourceID((IBaseResource)element, theEncodeContext);
                        if (resourceId != null) {
                            idString = resourceId.getIdPart();
                        }
                    } else if (element instanceof IBaseElement) {
                        idPredicate = "http://hl7.org/fhir/Element.id";
                        if (((IBaseElement)((Object)element)).getId() != null) {
                            idString = ((IBaseElement)((Object)element)).getId();
                        }
                    }
                    if (idString != null) {
                        rdfResource.addProperty(rdfModel.createProperty(idPredicate), (RDFNode)this.createFhirValueBlankNode(rdfModel, idString));
                    }
                    rdfModel = this.encodeCompositeElementToStreamWriter(resource, element, rdfModel, rdfResource, includedResource, parent, theEncodeContext);
                    return rdfModel;
                }
                case CONTAINED_RESOURCE_LIST: 
                case CONTAINED_RESOURCES: {
                    if (element == null) return rdfModel;
                    IIdType resourceId = ((IBaseResource)element).getIdElement();
                    Resource containedResource = rdfModel.createResource();
                    rdfResource.addProperty(rdfModel.createProperty("http://hl7.org/fhir/DomainResource.contained"), (RDFNode)containedResource);
                    if (cardinalityIndex != null) {
                        containedResource.addProperty(rdfModel.createProperty("http://hl7.org/fhir/index"), cardinalityIndex.toString(), (RDFDatatype)XSDDatatype.XSDinteger);
                    }
                    this.encodeResourceToRDFStreamWriter((IBaseResource)element, rdfModel, true, super.fixContainedResourceId(resourceId.getValue()), theEncodeContext, false, containedResource);
                    return rdfModel;
                }
                case RESOURCE: {
                    IBaseResource baseResource = (IBaseResource)element;
                    String resourceName = this.getContext().getResourceType(baseResource);
                    if (!super.shouldEncodeResource(resourceName, theEncodeContext)) {
                        return rdfModel;
                    } else {
                        theEncodeContext.pushPath(resourceName, true);
                        IIdType resourceId = this.processResourceID(resource, theEncodeContext);
                        this.encodeResourceToRDFStreamWriter(resource, rdfModel, false, resourceId, theEncodeContext, false, null);
                        theEncodeContext.popPath();
                        return rdfModel;
                    }
                }
                case PRIMITIVE_XHTML: 
                case PRIMITIVE_XHTML_HL7ORG: {
                    IBaseXhtml xHtmlNode = (IBaseXhtml)element;
                    if (xHtmlNode == null) return rdfModel;
                    String value = xHtmlNode.getValueAsString();
                    String propertyName = this.constructPredicateName(resource, childDefinition, childName, parentElement);
                    rdfResource.addProperty(rdfModel.createProperty(propertyName), value);
                    return rdfModel;
                }
                default: {
                    throw new IllegalStateException(Msg.code(1847) + "Unexpected node - should not happen: " + childDef.getName());
                }
            }
        }
        finally {
            theEncodeContext.popPath();
        }
    }

    private XSDDatatype getXSDDataTypeForFhirType(String fhirType, String value) {
        switch (fhirType) {
            case "boolean": {
                return XSDDatatype.XSDboolean;
            }
            case "uri": {
                return XSDDatatype.XSDanyURI;
            }
            case "decimal": {
                return XSDDatatype.XSDdecimal;
            }
            case "date": {
                return XSDDatatype.XSDdate;
            }
            case "dateTime": 
            case "instant": {
                switch (value.length()) {
                    case 4: {
                        return XSDDatatype.XSDgYear;
                    }
                    case 7: {
                        return XSDDatatype.XSDgYearMonth;
                    }
                    case 10: {
                        return XSDDatatype.XSDdate;
                    }
                }
                return XSDDatatype.XSDdateTime;
            }
        }
        return XSDDatatype.XSDstring;
    }

    private IIdType processResourceID(IBaseResource resource, BaseParser.EncodeContext encodeContext) {
        IIdType resourceId = null;
        if (StringUtils.isNotBlank((CharSequence)resource.getIdElement().getIdPart())) {
            resourceId = resource.getIdElement();
            if (resource.getIdElement().getValue().startsWith("urn:")) {
                resourceId = null;
            }
        }
        if (!super.shouldEncodeResourceId(resource, encodeContext)) {
            resourceId = null;
        } else if (encodeContext.getResourcePath().size() == 1 && super.getEncodeForceResourceId() != null) {
            resourceId = super.getEncodeForceResourceId();
        }
        return resourceId;
    }

    private Model encodeExtension(IBaseResource resource, Model rdfModel, Resource rdfResource, boolean containedResource, BaseParser.CompositeChildElement nextChildElem, BaseRuntimeChildDefinition nextChild, IBase nextValue, String childName, BaseRuntimeElementDefinition<?> childDef, BaseParser.EncodeContext encodeContext, Integer cardinalityIndex) {
        BaseRuntimeDeclaredChildDefinition extDef = (BaseRuntimeDeclaredChildDefinition)nextChild;
        Resource childResource = rdfModel.createResource();
        String extensionPredicateName = this.constructPredicateName(resource, extDef, extDef.getElementName(), null);
        rdfResource.addProperty(rdfModel.createProperty(extensionPredicateName), (RDFNode)childResource);
        if (cardinalityIndex != null && cardinalityIndex > -1) {
            childResource.addProperty(rdfModel.createProperty("http://hl7.org/fhir/index"), cardinalityIndex.toString(), (RDFDatatype)XSDDatatype.XSDinteger);
        }
        rdfModel = this.encodeChildElementToStreamWriter(resource, null, rdfModel, childResource, nextChild, nextValue, childName, childDef, containedResource, nextChildElem, encodeContext, cardinalityIndex);
        return rdfModel;
    }

    private Model encodeCompositeElementToStreamWriter(IBaseResource resource, IBase element, Model rdfModel, Resource rdfResource, boolean containedResource, BaseParser.CompositeChildElement parent, BaseParser.EncodeContext encodeContext) {
        for (BaseParser.CompositeChildElement nextChildElem : super.compositeChildIterator(element, containedResource, parent, encodeContext)) {
            List<IBase> values;
            INarrativeGenerator gen;
            BaseRuntimeChildDefinition nextChild = nextChildElem.getDef();
            if (nextChild instanceof RuntimeChildNarrativeDefinition && (gen = this.getContext().getNarrativeGenerator()) != null) {
                INarrative narrative = resource instanceof IResource ? ((IResource)resource).getText() : (resource instanceof IDomainResource ? ((IDomainResource)resource).getText() : null);
                assert (narrative != null);
                if (narrative.isEmpty()) {
                    gen.populateResourceNarrative(this.getContext(), resource);
                } else {
                    RuntimeChildNarrativeDefinition child = (RuntimeChildNarrativeDefinition)nextChild;
                    Resource childResource = rdfModel.createResource();
                    String propertyName = this.constructPredicateName(resource, child, child.getElementName(), element);
                    rdfResource.addProperty(rdfModel.createProperty(propertyName), (RDFNode)childResource);
                    String childName = nextChild.getChildNameByDatatype(child.getDatatype());
                    BaseRuntimeElementDefinition<?> type = child.getChildByName(childName);
                    rdfModel = this.encodeChildElementToStreamWriter(resource, element, rdfModel, childResource, nextChild, narrative, childName, type, containedResource, nextChildElem, encodeContext, null);
                    continue;
                }
            }
            if (nextChild instanceof RuntimeChildDirectResource) {
                values = nextChild.getAccessor().getValues(element);
                if (values == null || values.isEmpty()) continue;
                IBaseResource directChildResource = (IBaseResource)values.get(0);
                Resource childResource = this.encodeResourceToRDFStreamWriter(directChildResource, rdfModel, false, directChildResource.getIdElement(), encodeContext, false, null);
                String propertyName = this.constructPredicateName(resource, nextChild, nextChild.getElementName(), element);
                rdfResource.addProperty(rdfModel.createProperty(propertyName), (RDFNode)childResource);
                continue;
            }
            if (nextChild instanceof RuntimeChildContainedResources) {
                values = nextChild.getAccessor().getValues(element);
                int i = 0;
                for (IBase containedResourceEntity : values) {
                    rdfModel = this.encodeChildElementToStreamWriter(resource, element, rdfModel, rdfResource, nextChild, containedResourceEntity, nextChild.getChildNameByDatatype(null), nextChild.getChildElementDefinitionByDatatype(null), containedResource, nextChildElem, encodeContext, i);
                    ++i;
                }
                continue;
            }
            values = nextChild.getAccessor().getValues(element);
            if ((values = super.preProcessValues(nextChild, resource, values, nextChildElem, encodeContext)) == null || values.isEmpty()) continue;
            Integer cardinalityIndex = null;
            int indexCounter = 0;
            for (IBase nextValue : values) {
                BaseParser.ChildNameAndDef childNameAndDef;
                if (nextChild.getMax() != 1) {
                    cardinalityIndex = indexCounter;
                    ++indexCounter;
                }
                if (nextValue == null || nextValue.isEmpty() || (childNameAndDef = super.getChildNameAndDef(nextChild, nextValue)) == null) continue;
                String childName = childNameAndDef.getChildName();
                BaseRuntimeElementDefinition<?> childDef = childNameAndDef.getChildDef();
                String extensionUrl = this.getExtensionUrl(nextChild.getExtensionUrl());
                if (extensionUrl != null && !childName.equals(EXTENSION)) {
                    rdfModel = this.encodeExtension(resource, rdfModel, rdfResource, containedResource, nextChildElem, nextChild, nextValue, childName, childDef, encodeContext, cardinalityIndex);
                    continue;
                }
                if (nextChild instanceof RuntimeChildExtension) {
                    IBaseExtension extension = (IBaseExtension)nextValue;
                    if ((extension.getValue() == null || extension.getValue().isEmpty()) && extension.getExtension().isEmpty()) continue;
                    rdfModel = this.encodeExtension(resource, rdfModel, rdfResource, containedResource, nextChildElem, nextChild, nextValue, childName, childDef, encodeContext, cardinalityIndex);
                    continue;
                }
                if (nextChild instanceof RuntimeChildNarrativeDefinition && containedResource) continue;
                if (childDef.getChildType() != BaseRuntimeElementDefinition.ChildTypeEnum.PRIMITIVE_DATATYPE && childDef.getChildType() != BaseRuntimeElementDefinition.ChildTypeEnum.PRIMITIVE_XHTML_HL7ORG && childDef.getChildType() != BaseRuntimeElementDefinition.ChildTypeEnum.PRIMITIVE_XHTML && childDef.getChildType() != BaseRuntimeElementDefinition.ChildTypeEnum.ID_DATATYPE) {
                    Resource childResource = rdfModel.createResource();
                    String propertyName = this.constructPredicateName(resource, nextChild, childName, nextValue);
                    rdfResource.addProperty(rdfModel.createProperty(propertyName), (RDFNode)childResource);
                    if (cardinalityIndex != null && cardinalityIndex > -1) {
                        childResource.addProperty(rdfModel.createProperty("http://hl7.org/fhir/index"), cardinalityIndex.toString(), (RDFDatatype)XSDDatatype.XSDinteger);
                    }
                    rdfModel = this.encodeChildElementToStreamWriter(resource, element, rdfModel, childResource, nextChild, nextValue, childName, childDef, containedResource, nextChildElem, encodeContext, cardinalityIndex);
                    continue;
                }
                rdfModel = this.encodeChildElementToStreamWriter(resource, element, rdfModel, rdfResource, nextChild, nextValue, childName, childDef, containedResource, nextChildElem, encodeContext, cardinalityIndex);
            }
        }
        return rdfModel;
    }

    private <T extends IBaseResource> T parseResource(Class<T> resourceType, Model rdfModel) {
        ParserState<T> parserState = ParserState.getPreResourceInstance(this, resourceType, this.getContext(), true, this.getErrorHandler());
        return (T)((IBaseResource)this.parseRootResource(rdfModel, parserState, resourceType));
    }

    private <T> T parseRootResource(Model rdfModel, ParserState<T> parserState, Class<T> resourceType) {
        logger.trace("Entering parseRootResource with state: {}", parserState);
        StmtIterator rootStatementIterator = rdfModel.listStatements(null, rdfModel.getProperty("http://hl7.org/fhir/nodeRole"), (RDFNode)rdfModel.getProperty("http://hl7.org/fhir/treeRoot"));
        while (rootStatementIterator.hasNext()) {
            String fhirTypeString;
            Statement rootStatement = (Statement)rootStatementIterator.next();
            Resource rootResource = rootStatement.getSubject();
            if (resourceType == null) {
                Statement resourceTypeStatement = rootResource.getProperty(RDF.type);
                fhirTypeString = resourceTypeStatement.getObject().toString();
                if (fhirTypeString.startsWith(FHIR_NS)) {
                    fhirTypeString = fhirTypeString.replace(FHIR_NS, "");
                }
            } else {
                fhirTypeString = resourceType.getSimpleName();
            }
            RuntimeResourceDefinition definition = this.getContext().getResourceDefinition(fhirTypeString);
            String fhirResourceType = definition.getName();
            this.parseResource(parserState, fhirResourceType, (RDFNode)rootResource);
            parserState.endingElement();
        }
        return parserState.getObject();
    }

    private <T> void parseResource(ParserState<T> parserState, String resourceType, RDFNode rootNode) {
        parserState.enteringNewElement(FHIR_NS, resourceType);
        if (rootNode instanceof Resource) {
            Resource rootResource = rootNode.asResource();
            List statements = rootResource.listProperties().toList();
            statements.sort(new FhirIndexStatementComparator());
            for (Statement statement : statements) {
                String predicateAttributeName = this.extractAttributeNameFromPredicate(statement);
                if (predicateAttributeName == null) continue;
                if (predicateAttributeName.equals(MODIFIER_EXTENSION)) {
                    this.processExtension(parserState, statement.getObject(), true);
                    continue;
                }
                if (predicateAttributeName.equals(EXTENSION)) {
                    this.processExtension(parserState, statement.getObject(), false);
                    continue;
                }
                this.processStatementObject(parserState, predicateAttributeName, statement.getObject());
            }
        } else if (rootNode instanceof Literal) {
            parserState.attributeValue(VALUE, rootNode.asLiteral().getString());
        }
        parserState.endingElement();
    }

    private String extractAttributeNameFromPredicate(Statement statement) {
        String predicateUri = statement.getPredicate().getURI();
        if (ignoredPredicates.contains(predicateUri)) {
            return null;
        }
        String predicateObjectAttribute = predicateUri.substring(predicateUri.lastIndexOf("/") + 1);
        String predicateAttributeName = predicateObjectAttribute.contains(".") ? predicateObjectAttribute.substring(predicateObjectAttribute.lastIndexOf(".") + 1) : predicateObjectAttribute;
        return predicateAttributeName;
    }

    private <T> void processStatementObject(ParserState<T> parserState, String predicateAttributeName, RDFNode statementObject) {
        logger.trace("Entering processStatementObject with state: {}, for attribute {}", parserState, (Object)predicateAttributeName);
        parserState.enteringNewElement(FHIR_NS, predicateAttributeName);
        if (statementObject != null) {
            if (statementObject.isLiteral()) {
                parserState.attributeValue(VALUE, statementObject.asLiteral().getLexicalForm());
            } else if (statementObject.isAnon()) {
                Resource resourceObject = statementObject.asResource();
                boolean containedResource = false;
                if (predicateAttributeName.equals(CONTAINED)) {
                    containedResource = true;
                    parserState.enteringNewElement(FHIR_NS, resourceObject.getProperty(resourceObject.getModel().createProperty(RDF.type.getURI())).getObject().toString().replace(FHIR_NS, ""));
                }
                List objectStatements = resourceObject.listProperties().toList();
                objectStatements.sort(new FhirIndexStatementComparator());
                for (Statement objectProperty : objectStatements) {
                    if (objectProperty.getPredicate().hasURI("http://hl7.org/fhir/value")) {
                        predicateAttributeName = VALUE;
                        parserState.attributeValue(predicateAttributeName, objectProperty.getObject().asLiteral().getLexicalForm());
                        continue;
                    }
                    predicateAttributeName = this.extractAttributeNameFromPredicate(objectProperty);
                    if (predicateAttributeName == null) continue;
                    if (predicateAttributeName.equals(EXTENSION)) {
                        this.processExtension(parserState, objectProperty.getObject(), false);
                        continue;
                    }
                    if (predicateAttributeName.equals(MODIFIER_EXTENSION)) {
                        this.processExtension(parserState, objectProperty.getObject(), true);
                        continue;
                    }
                    this.processStatementObject(parserState, predicateAttributeName, objectProperty.getObject());
                }
                if (containedResource) {
                    parserState.endingElement();
                }
            } else if (statementObject.isResource()) {
                Resource innerResource = statementObject.asResource();
                Statement resourceTypeStatement = innerResource.getProperty(RDF.type);
                String fhirTypeString = resourceTypeStatement.getObject().toString();
                if (fhirTypeString.startsWith(FHIR_NS)) {
                    fhirTypeString = fhirTypeString.replace(FHIR_NS, "");
                }
                this.parseResource(parserState, fhirTypeString, (RDFNode)innerResource);
            }
        }
        parserState.endingElement();
    }

    private <T> void processExtension(ParserState<T> parserState, RDFNode statementObject, boolean isModifier) {
        String propertyUri;
        logger.trace("Entering processExtension with state: {}", parserState);
        Resource resource = statementObject.asResource();
        Statement urlProperty = resource.getProperty(resource.getModel().createProperty("http://hl7.org/fhir/Extension.url"));
        Resource urlPropertyResource = urlProperty.getObject().asResource();
        String extensionUrl = urlPropertyResource.getProperty(resource.getModel().createProperty("http://hl7.org/fhir/value")).getObject().asLiteral().getString();
        List extensionStatements = resource.listProperties().toList();
        String extensionValueType = null;
        Resource extensionValueResource = null;
        for (Statement statement : extensionStatements) {
            propertyUri = statement.getPredicate().getURI();
            if (!propertyUri.contains("Extension.value")) continue;
            extensionValueType = propertyUri.replace("http://hl7.org/fhir/Extension.", "");
            BaseRuntimeElementDefinition<?> target = this.getContext().getRuntimeChildUndeclaredExtensionDefinition().getChildByName(extensionValueType);
            if (target.getChildType().equals((Object)BaseRuntimeElementDefinition.ChildTypeEnum.ID_DATATYPE) || target.getChildType().equals((Object)BaseRuntimeElementDefinition.ChildTypeEnum.PRIMITIVE_DATATYPE)) {
                extensionValueResource = statement.getObject().asResource().getProperty(resource.getModel().createProperty("http://hl7.org/fhir/value")).getObject().asLiteral();
                break;
            }
            extensionValueResource = statement.getObject().asResource();
            break;
        }
        parserState.enteringNewElementExtension(null, extensionUrl, isModifier, null);
        if (extensionValueType != null) {
            this.parseResource(parserState, extensionValueType, (RDFNode)extensionValueResource);
        }
        for (Statement statement : extensionStatements) {
            propertyUri = statement.getPredicate().getURI();
            if (!propertyUri.equals("http://hl7.org/fhir/Element.extension")) continue;
            this.processExtension(parserState, statement.getObject(), false);
        }
        parserState.endingElement();
    }

    static {
        JenaSystem.init();
        ignoredPredicates = Arrays.asList(RDF.type.getURI(), "http://hl7.org/fhir/index", "http://hl7.org/fhir/nodeRole");
    }

    static class FhirIndexStatementComparator
    implements Comparator<Statement> {
        FhirIndexStatementComparator() {
        }

        @Override
        public int compare(Statement arg0, Statement arg1) {
            int result = arg0.getPredicate().getURI().compareTo(arg1.getPredicate().getURI());
            if (result == 0 && arg0.getObject().isResource() && arg1.getObject().isResource()) {
                Resource resource0 = arg0.getObject().asResource();
                Resource resource1 = arg1.getObject().asResource();
                result = Integer.compare(this.getFhirIndex(resource0), this.getFhirIndex(resource1));
            }
            return result;
        }

        private int getFhirIndex(Resource resource) {
            if (resource.hasProperty(resource.getModel().createProperty("http://hl7.org/fhir/index"))) {
                return resource.getProperty(resource.getModel().createProperty("http://hl7.org/fhir/index")).getInt();
            }
            return -1;
        }
    }
}

