/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.narrative2;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.narrative2.INarrativeTemplate;
import ca.uhn.fhir.narrative2.INarrativeTemplateManifest;
import ca.uhn.fhir.narrative2.NarrativeTemplate;
import ca.uhn.fhir.narrative2.TemplateTypeEnum;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.util.ClasspathUtil;
import com.google.common.base.Charsets;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NarrativeTemplateManifest
implements INarrativeTemplateManifest {
    private static final Logger ourLog = LoggerFactory.getLogger(NarrativeTemplateManifest.class);
    private final ListMultimap<String, NarrativeTemplate> myResourceTypeToTemplate;
    private final ListMultimap<String, NarrativeTemplate> myDatatypeToTemplate;
    private final ListMultimap<String, NarrativeTemplate> myNameToTemplate;
    private final ListMultimap<String, NarrativeTemplate> myFragmentNameToTemplate;
    private final ListMultimap<String, NarrativeTemplate> myClassToTemplate;
    private final int myTemplateCount;

    private NarrativeTemplateManifest(Collection<NarrativeTemplate> theTemplates) {
        ArrayListMultimap resourceTypeToTemplate = ArrayListMultimap.create();
        ArrayListMultimap datatypeToTemplate = ArrayListMultimap.create();
        ArrayListMultimap nameToTemplate = ArrayListMultimap.create();
        ArrayListMultimap classToTemplate = ArrayListMultimap.create();
        ArrayListMultimap fragmentNameToTemplate = ArrayListMultimap.create();
        for (NarrativeTemplate nextTemplate : theTemplates) {
            nameToTemplate.put((Object)nextTemplate.getTemplateName(), (Object)nextTemplate);
            for (String string : nextTemplate.getAppliesToResourceTypes()) {
                resourceTypeToTemplate.put((Object)string.toUpperCase(), (Object)nextTemplate);
            }
            for (String string : nextTemplate.getAppliesToDataTypes()) {
                datatypeToTemplate.put((Object)string.toUpperCase(), (Object)nextTemplate);
            }
            for (Class clazz : nextTemplate.getAppliesToClasses()) {
                classToTemplate.put((Object)clazz.getName(), (Object)nextTemplate);
            }
            for (String string : nextTemplate.getAppliesToFragmentNames()) {
                fragmentNameToTemplate.put((Object)string, (Object)nextTemplate);
            }
        }
        this.myTemplateCount = theTemplates.size();
        this.myClassToTemplate = Multimaps.unmodifiableListMultimap((ListMultimap)classToTemplate);
        this.myNameToTemplate = Multimaps.unmodifiableListMultimap((ListMultimap)nameToTemplate);
        this.myResourceTypeToTemplate = Multimaps.unmodifiableListMultimap((ListMultimap)resourceTypeToTemplate);
        this.myDatatypeToTemplate = Multimaps.unmodifiableListMultimap((ListMultimap)datatypeToTemplate);
        this.myFragmentNameToTemplate = Multimaps.unmodifiableListMultimap((ListMultimap)fragmentNameToTemplate);
    }

    public int getNamedTemplateCount() {
        return this.myTemplateCount;
    }

    @Override
    public List<INarrativeTemplate> getTemplateByResourceName(@Nonnull FhirContext theFhirContext, @Nonnull EnumSet<TemplateTypeEnum> theStyles, @Nonnull String theResourceName, @Nonnull Collection<String> theProfiles, @Nonnull Collection<String> theCodes) {
        return NarrativeTemplateManifest.getFromMap(theStyles, theResourceName.toUpperCase(), this.myResourceTypeToTemplate, theProfiles, theCodes);
    }

    @Override
    public List<INarrativeTemplate> getTemplateByName(@Nonnull FhirContext theFhirContext, @Nonnull EnumSet<TemplateTypeEnum> theStyles, @Nonnull String theName) {
        return NarrativeTemplateManifest.getFromMap(theStyles, theName, this.myNameToTemplate);
    }

    @Override
    public List<INarrativeTemplate> getTemplateByFragmentName(@Nonnull FhirContext theFhirContext, @Nonnull EnumSet<TemplateTypeEnum> theStyles, @Nonnull String theFragmentName) {
        return NarrativeTemplateManifest.getFromMap(theStyles, theFragmentName, this.myFragmentNameToTemplate);
    }

    @Override
    public List<INarrativeTemplate> getTemplateByElement(@Nonnull FhirContext theFhirContext, @Nonnull EnumSet<TemplateTypeEnum> theStyles, @Nonnull IBase theElement) {
        List<INarrativeTemplate> retVal = Collections.emptyList();
        if (theElement instanceof IBaseResource) {
            IBaseResource resource = (IBaseResource)theElement;
            String resourceName = theFhirContext.getResourceDefinition(resource).getName();
            List<String> profiles = resource.getMeta().getProfile().stream().filter(Objects::nonNull).map(IPrimitiveType::getValueAsString).filter(StringUtils::isNotBlank).collect(Collectors.toList());
            List<String> codes = resource.getMeta().getTag().stream().filter(Objects::nonNull).filter(f -> StringUtils.isNotBlank((CharSequence)f.getSystem()) && StringUtils.isNotBlank((CharSequence)f.getCode())).map(t -> t.getSystem() + "|" + t.getCode()).collect(Collectors.toList());
            retVal = this.getTemplateByResourceName(theFhirContext, theStyles, resourceName, profiles, codes);
        }
        if (retVal.isEmpty()) {
            retVal = NarrativeTemplateManifest.getFromMap(theStyles, theElement.getClass().getName(), this.myClassToTemplate);
        }
        if (retVal.isEmpty()) {
            String datatypeName = theFhirContext.getElementDefinition(theElement.getClass()).getName();
            retVal = NarrativeTemplateManifest.getFromMap(theStyles, datatypeName.toUpperCase(), this.myDatatypeToTemplate);
        }
        return retVal;
    }

    public static NarrativeTemplateManifest forManifestFileLocation(String ... thePropertyFilePaths) {
        return NarrativeTemplateManifest.forManifestFileLocation(Arrays.asList(thePropertyFilePaths));
    }

    public static NarrativeTemplateManifest forManifestFileLocation(Collection<String> thePropertyFilePaths) {
        ourLog.debug("Loading narrative properties file(s): {}", thePropertyFilePaths);
        ArrayList<String> manifestFileContents = new ArrayList<String>(thePropertyFilePaths.size());
        for (String next : thePropertyFilePaths) {
            String resource = NarrativeTemplateManifest.loadResource(next);
            manifestFileContents.add(resource);
        }
        return NarrativeTemplateManifest.forManifestFileContents(manifestFileContents);
    }

    public static NarrativeTemplateManifest forManifestFileContents(String ... theResources) {
        return NarrativeTemplateManifest.forManifestFileContents(Arrays.asList(theResources));
    }

    public static NarrativeTemplateManifest forManifestFileContents(Collection<String> theResources) {
        try {
            ArrayList<NarrativeTemplate> templates = new ArrayList<NarrativeTemplate>();
            for (String next : theResources) {
                templates.addAll(NarrativeTemplateManifest.loadProperties(next));
            }
            return new NarrativeTemplateManifest(templates);
        }
        catch (IOException e) {
            throw new InternalErrorException(Msg.code(1808) + String.valueOf(e));
        }
    }

    private static Collection<NarrativeTemplate> loadProperties(String theManifestText) throws IOException {
        HashMap<String, NarrativeTemplate> nameToTemplate = new HashMap<String, NarrativeTemplate>();
        Properties file = new Properties();
        file.load(new StringReader(theManifestText));
        for (Object nextKeyObj : file.keySet()) {
            String resourceType;
            String nextKey = (String)nextKeyObj;
            Validate.isTrue((StringUtils.countMatches((CharSequence)nextKey, (CharSequence)".") == 1 ? 1 : 0) != 0, (String)"Invalid narrative property file key: %s", (Object[])new Object[]{nextKey});
            String name = nextKey.substring(0, nextKey.indexOf(46));
            Validate.notBlank((CharSequence)name, (String)"Invalid narrative property file key: %s", (Object[])new Object[]{nextKey});
            NarrativeTemplate nextTemplate = nameToTemplate.computeIfAbsent(name, t -> new NarrativeTemplate().setTemplateName(name));
            if (nextKey.endsWith(".class")) {
                String className = file.getProperty(nextKey);
                if (!StringUtils.isNotBlank((CharSequence)className)) continue;
                try {
                    nextTemplate.addAppliesToClass(Class.forName(className));
                    continue;
                }
                catch (ClassNotFoundException theE) {
                    throw new InternalErrorException(Msg.code(1867) + "Could not find class " + className + " declared in narrative manifest");
                }
            }
            if (nextKey.endsWith(".profile")) {
                String profile = file.getProperty(nextKey);
                if (!StringUtils.isNotBlank((CharSequence)profile)) continue;
                nextTemplate.addAppliesToProfile(profile);
                continue;
            }
            if (nextKey.endsWith(".tag")) {
                String tag = file.getProperty(nextKey);
                if (!StringUtils.isNotBlank((CharSequence)tag)) continue;
                nextTemplate.addAppliesToCode(tag);
                continue;
            }
            if (nextKey.endsWith(".resourceType")) {
                resourceType = file.getProperty(nextKey);
                NarrativeTemplateManifest.parseValuesAndAddToMap(resourceType, nextTemplate::addAppliesToResourceType);
                continue;
            }
            if (nextKey.endsWith(".fragmentName")) {
                resourceType = file.getProperty(nextKey);
                NarrativeTemplateManifest.parseValuesAndAddToMap(resourceType, nextTemplate::addAppliesToFragmentName);
                continue;
            }
            if (nextKey.endsWith(".dataType")) {
                String dataType = file.getProperty(nextKey);
                NarrativeTemplateManifest.parseValuesAndAddToMap(dataType, nextTemplate::addAppliesToDatatype);
                continue;
            }
            if (nextKey.endsWith(".style")) {
                String templateTypeName = file.getProperty(nextKey).toUpperCase();
                TemplateTypeEnum templateType = TemplateTypeEnum.valueOf(templateTypeName);
                nextTemplate.setTemplateType(templateType);
                continue;
            }
            if (nextKey.endsWith(".contextPath")) {
                String contextPath = file.getProperty(nextKey);
                nextTemplate.setContextPath(contextPath);
                continue;
            }
            if (nextKey.endsWith(".narrative")) {
                String narrativePropName = name + ".narrative";
                String narrativeName = file.getProperty(narrativePropName);
                if (!StringUtils.isNotBlank((CharSequence)narrativeName)) continue;
                nextTemplate.setTemplateFileName(narrativeName);
                continue;
            }
            if (nextKey.endsWith(".title")) {
                ourLog.debug("Ignoring title property as narrative generator no longer generates titles: {}", (Object)nextKey);
                continue;
            }
            throw new ConfigurationException(Msg.code(1868) + "Invalid property name: " + nextKey + " - the key must end in one of the expected extensions '.profile', '.resourceType', '.dataType', '.style', '.contextPath', '.narrative', '.title'");
        }
        return nameToTemplate.values();
    }

    private static void parseValuesAndAddToMap(String resourceType, Consumer<String> addAppliesToResourceType) {
        Arrays.stream(resourceType.split(",")).map(String::trim).filter(StringUtils::isNotBlank).forEach(addAppliesToResourceType);
    }

    static String loadResource(String theName) {
        if (theName.startsWith("classpath:")) {
            return ClasspathUtil.loadResource(theName);
        }
        if (theName.startsWith("file:")) {
            String string;
            File file = new File(theName.substring("file:".length()));
            if (!file.exists()) {
                throw new InternalErrorException(Msg.code(1870) + "File not found: " + file.getAbsolutePath());
            }
            FileInputStream inputStream = new FileInputStream(file);
            try {
                string = IOUtils.toString((InputStream)inputStream, (Charset)Charsets.UTF_8);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new InternalErrorException(Msg.code(1869) + e.getMessage(), (Throwable)e);
                }
            }
            inputStream.close();
            return string;
        }
        throw new InternalErrorException(Msg.code(1871) + "Invalid resource name: '" + theName + "' (must start with classpath: or file: )");
    }

    private static <T> List<INarrativeTemplate> getFromMap(EnumSet<TemplateTypeEnum> theStyles, T theKey, ListMultimap<T, NarrativeTemplate> theMap) {
        return NarrativeTemplateManifest.getFromMap(theStyles, theKey, theMap, Collections.emptyList(), Collections.emptyList());
    }

    private static <T> List<INarrativeTemplate> getFromMap(EnumSet<TemplateTypeEnum> theStyles, T theKey, ListMultimap<T, NarrativeTemplate> theMap, Collection<String> theProfiles, Collection<String> theCodes) {
        return theMap.get(theKey).stream().filter(t -> theStyles.contains((Object)t.getTemplateType())).filter(t -> {
            if (theProfiles.isEmpty()) return true;
            if (!t.getAppliesToProfiles().stream().anyMatch(theProfiles::contains)) return false;
            return true;
        }).filter(t -> {
            if (theCodes.isEmpty()) return true;
            if (!t.getAppliesToCode().stream().anyMatch(theCodes::contains)) return false;
            return true;
        }).collect(Collectors.toList());
    }
}

