/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.interceptor.auth;

import jakarta.annotation.Nonnull;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CompartmentSearchParameterModifications {
    private final Map<String, Set<String>> myAdditionalResourceTypeToParameterCodeMap = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> myOmittedResourceTypeToParameterCodeMap = new HashMap<String, Set<String>>();

    public static CompartmentSearchParameterModifications fromAdditionalAndOmittedSPNames(@Nonnull String theResourceType, @Nonnull Set<String> theAdditionalSPs, @Nonnull Set<String> theOmittedSps) {
        CompartmentSearchParameterModifications modifications = new CompartmentSearchParameterModifications();
        theAdditionalSPs.forEach(spName -> modifications.addSPToIncludeInCompartment(theResourceType, (String)spName));
        theOmittedSps.forEach(spName -> modifications.addSPToOmitFromCompartment(theResourceType, (String)spName));
        return modifications;
    }

    public static CompartmentSearchParameterModifications fromAdditionalCompartmentParamNames(String theResourceType, @Nonnull Set<String> theAdditionalCompartmentParamNames) {
        return CompartmentSearchParameterModifications.fromAdditionalAndOmittedSPNames(theResourceType, theAdditionalCompartmentParamNames, Set.of());
    }

    public void addSPToOmitFromCompartment(String theResourceType, String theSPName) {
        this.myOmittedResourceTypeToParameterCodeMap.computeIfAbsent(theResourceType.toLowerCase(), key -> new HashSet()).add(theSPName);
    }

    public void addSPToIncludeInCompartment(String theResourceType, String theSPName) {
        this.myAdditionalResourceTypeToParameterCodeMap.computeIfAbsent(theResourceType.toLowerCase(), key -> new HashSet()).add(theSPName);
    }

    public Set<String> getAdditionalSearchParamNamesForResourceType(@Nonnull String theResourceType) {
        return this.myAdditionalResourceTypeToParameterCodeMap.computeIfAbsent(theResourceType.toLowerCase(), key -> new HashSet());
    }

    public Set<String> getOmittedSPNamesForResourceType(String theResourceType) {
        return this.myOmittedResourceTypeToParameterCodeMap.computeIfAbsent(theResourceType.toLowerCase(), key -> new HashSet());
    }
}

