/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeChildChoiceDefinition;
import ca.uhn.fhir.context.RuntimeChildDirectResource;
import ca.uhn.fhir.context.RuntimeExtensionDtDefinition;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.auth.CompartmentSearchParameterModifications;
import ca.uhn.fhir.model.api.ExtensionDt;
import ca.uhn.fhir.model.api.IIdentifiableElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.ISupportsUndeclaredExtensions;
import ca.uhn.fhir.model.base.composite.BaseContainedDt;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.util.IModelVisitor;
import ca.uhn.fhir.util.IModelVisitor2;
import ca.uhn.fhir.util.ReflectionUtil;
import ca.uhn.fhir.util.ResourceReferenceInfo;
import com.google.common.collect.Lists;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.function.Consumers;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseElement;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IBaseHasModifierExtensions;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FhirTerser {
    private static final Pattern COMPARTMENT_MATCHER_PATH = Pattern.compile("([a-zA-Z.]+)\\.where\\(resolve\\(\\) is ([a-zA-Z]+)\\)");
    private static final String USER_DATA_KEY_CONTAIN_RESOURCES_COMPLETED = FhirTerser.class.getName() + "_CONTAIN_RESOURCES_COMPLETED";
    private final FhirContext myContext;
    private static final Logger ourLog = LoggerFactory.getLogger(FhirTerser.class);
    private static final Comparator<IBaseReference> REFERENCES_WITH_IDS_FIRST = Comparator.nullsLast(Comparator.comparing(ref -> {
        if (ref.getResource() == null) {
            return true;
        }
        if (ref.getResource().getIdElement() == null) {
            return true;
        }
        if (ref.getResource().getIdElement().getValue() == null) {
            return true;
        }
        return false;
    }));

    public FhirTerser(FhirContext theContext) {
        this.myContext = theContext;
    }

    private List<String> addNameToList(List<String> theCurrentList, BaseRuntimeChildDefinition theChildDefinition) {
        if (theChildDefinition == null) {
            return null;
        }
        if (theCurrentList == null || theCurrentList.isEmpty()) {
            return new ArrayList<String>(Collections.singletonList(theChildDefinition.getElementName()));
        }
        ArrayList<String> newList = new ArrayList<String>(theCurrentList);
        newList.add(theChildDefinition.getElementName());
        return newList;
    }

    private ExtensionDt createEmptyExtensionDt(IBaseExtension<?, ?> theBaseExtension, String theUrl) {
        return this.createEmptyExtensionDt(theBaseExtension, false, theUrl);
    }

    private ExtensionDt createEmptyExtensionDt(IBaseExtension theBaseExtension, boolean theIsModifier, String theUrl) {
        ExtensionDt retVal = new ExtensionDt(theIsModifier, theUrl);
        theBaseExtension.getExtension().add(retVal);
        return retVal;
    }

    private ExtensionDt createEmptyExtensionDt(ISupportsUndeclaredExtensions theSupportsUndeclaredExtensions, String theUrl) {
        return this.createEmptyExtensionDt(theSupportsUndeclaredExtensions, false, theUrl);
    }

    private ExtensionDt createEmptyExtensionDt(ISupportsUndeclaredExtensions theSupportsUndeclaredExtensions, boolean theIsModifier, String theUrl) {
        return theSupportsUndeclaredExtensions.addUndeclaredExtension(theIsModifier, theUrl);
    }

    private IBaseExtension<?, ?> createEmptyExtension(IBaseHasExtensions theBaseHasExtensions, String theUrl) {
        return (IBaseExtension)theBaseHasExtensions.addExtension().setUrl(theUrl);
    }

    private IBaseExtension<?, ?> createEmptyModifierExtension(IBaseHasModifierExtensions theBaseHasModifierExtensions, String theUrl) {
        return (IBaseExtension)theBaseHasModifierExtensions.addModifierExtension().setUrl(theUrl);
    }

    private ExtensionDt createEmptyModifierExtensionDt(ISupportsUndeclaredExtensions theSupportsUndeclaredExtensions, String theUrl) {
        return this.createEmptyExtensionDt(theSupportsUndeclaredExtensions, true, theUrl);
    }

    public IBase cloneInto(IBase theSource, IBase theTarget, boolean theIgnoreMissingFields) {
        Object target;
        Object source;
        Validate.notNull((Object)theSource, (String)"theSource must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)theTarget, (String)"theTarget must not be null", (Object[])new Object[0]);
        if (theSource instanceof IBaseElement) {
            source = (IBaseElement)((Object)theSource);
            target = (IBaseElement)((Object)theTarget);
            target.setId(source.getId());
        }
        if (theSource instanceof IIdentifiableElement) {
            source = (IIdentifiableElement)theSource;
            target = (IIdentifiableElement)theTarget;
            target.setElementSpecificId(source.getElementSpecificId());
        }
        if (theSource instanceof IResource) {
            source = (IResource)theSource;
            target = (IResource)theTarget;
            target.setId(source.getId());
            target.getResourceMetadata().putAll(source.getResourceMetadata());
        }
        if (theSource instanceof IPrimitiveType) {
            if (theTarget instanceof IPrimitiveType) {
                String valueAsString = ((IPrimitiveType)theSource).getValueAsString();
                if (StringUtils.isNotBlank((CharSequence)valueAsString)) {
                    ((IPrimitiveType)theTarget).setValueAsString(valueAsString);
                }
                if (theSource instanceof IBaseHasExtensions && theTarget instanceof IBaseHasExtensions) {
                    List<IBaseExtension<?, ?>> extensions = ((IBaseHasExtensions)theSource).getExtension();
                    for (IBaseExtension<?, ?> nextSource : extensions) {
                        IBaseExtension<?, ?> nextTarget = ((IBaseHasExtensions)theTarget).addExtension();
                        this.cloneInto(nextSource, nextTarget, theIgnoreMissingFields);
                    }
                }
                return theSource;
            }
            if (theIgnoreMissingFields) {
                return theSource;
            }
            throw new DataFormatException(Msg.code(1788) + "Can not copy value from primitive of type " + theSource.getClass().getName() + " into type " + theTarget.getClass().getName());
        }
        if (theSource instanceof IBaseReference && theTarget instanceof IBaseReference) {
            IBaseReference sourceReference = (IBaseReference)theSource;
            IBaseReference targetReference = (IBaseReference)theTarget;
            if (sourceReference.getResource() != null) {
                targetReference.setResource(sourceReference.getResource());
            }
        }
        BaseRuntimeElementCompositeDefinition sourceDef = (BaseRuntimeElementCompositeDefinition)this.myContext.getElementDefinition(theSource.getClass());
        BaseRuntimeElementCompositeDefinition targetDef = (BaseRuntimeElementCompositeDefinition)this.myContext.getElementDefinition(theTarget.getClass());
        List<BaseRuntimeChildDefinition> children = sourceDef.getChildren();
        if (sourceDef instanceof RuntimeExtensionDtDefinition) {
            children = ((RuntimeExtensionDtDefinition)sourceDef).getChildrenIncludingUrl();
        }
        for (BaseRuntimeChildDefinition nextChild : children) {
            for (IBase nextValue : nextChild.getAccessor().getValues(theSource)) {
                Object target2;
                Class<?> valueType = nextValue.getClass();
                String elementName = nextChild.getChildNameByDatatype(valueType);
                BaseRuntimeChildDefinition targetChild = targetDef.getChildByName(elementName);
                if (targetChild == null) {
                    if (theIgnoreMissingFields) continue;
                    throw new DataFormatException(Msg.code(1789) + "Type " + theTarget.getClass().getName() + " does not have a child with name " + elementName);
                }
                BaseRuntimeElementDefinition<?> element = this.myContext.getElementDefinition(valueType);
                Object instanceConstructorArg = targetChild.getInstanceConstructorArguments();
                if (element == null && BaseContainedDt.class.isAssignableFrom(valueType)) {
                    BaseContainedDt containedTarget = (BaseContainedDt)ReflectionUtil.newInstance(valueType);
                    BaseContainedDt containedSource = (BaseContainedDt)nextValue;
                    for (IResource iResource : containedSource.getContainedResources()) {
                        List<? extends IResource> containedResources = containedTarget.getContainedResources();
                        containedResources.add(iResource);
                    }
                    targetChild.getMutator().addValue(theTarget, containedTarget);
                    continue;
                }
                if (instanceConstructorArg != null) {
                    Object target3 = element.newInstance(instanceConstructorArg);
                } else {
                    target2 = element.newInstance();
                }
                targetChild.getMutator().addValue(theTarget, (IBase)target2);
                this.cloneInto(nextValue, (IBase)target2, theIgnoreMissingFields);
            }
        }
        return theTarget;
    }

    public <T extends IBase> List<T> getAllPopulatedChildElementsOfType(IBaseResource theResource, final Class<T> theType) {
        final ArrayList retVal = new ArrayList();
        RuntimeResourceDefinition def = this.myContext.getResourceDefinition(theResource);
        this.visit(this.newMap(), theResource, theResource, null, null, def, new IModelVisitor(){

            @Override
            public void acceptElement(IBaseResource theOuterResource, IBase theElement, List<String> thePathToElement, BaseRuntimeChildDefinition theChildDefinition, BaseRuntimeElementDefinition<?> theDefinition) {
                if (theElement == null || theElement.isEmpty()) {
                    return;
                }
                if (theType.isAssignableFrom(theElement.getClass())) {
                    retVal.add(theElement);
                }
            }
        });
        return retVal;
    }

    public List<ResourceReferenceInfo> getAllResourceReferences(IBaseResource theResource) {
        return this.getAllResourceReferencesExcluding(theResource, Lists.newArrayList());
    }

    public List<ResourceReferenceInfo> getAllResourceReferencesExcluding(IBaseResource theResource, List<String> thePathsToExclude) {
        final ArrayList<ResourceReferenceInfo> retVal = new ArrayList<ResourceReferenceInfo>();
        RuntimeResourceDefinition def = this.myContext.getResourceDefinition(theResource);
        final List tokenizedPathsToExclude = thePathsToExclude.stream().map(path -> StringUtils.split((String)path, (String)".")).map(Lists::newArrayList).collect(Collectors.toList());
        this.visit(this.newMap(), theResource, theResource, null, null, def, new IModelVisitor(){

            @Override
            public void acceptElement(IBaseResource theOuterResource, IBase theElement, List<String> thePathToElement, BaseRuntimeChildDefinition theChildDefinition, BaseRuntimeElementDefinition<?> theDefinition) {
                if (theElement == null || theElement.isEmpty()) {
                    return;
                }
                if (thePathToElement != null && FhirTerser.this.pathShouldBeExcluded(tokenizedPathsToExclude, thePathToElement)) {
                    return;
                }
                if (IBaseReference.class.isAssignableFrom(theElement.getClass())) {
                    retVal.add(new ResourceReferenceInfo(FhirTerser.this.myContext, theOuterResource, thePathToElement, (IBaseReference)theElement));
                }
            }
        });
        return retVal;
    }

    private boolean pathShouldBeExcluded(List<List<String>> theTokenizedPathsToExclude, List<String> thePathToElement) {
        return theTokenizedPathsToExclude.stream().anyMatch(p -> {
            if (p.size() > thePathToElement.size()) {
                return false;
            }
            List prefix = thePathToElement.subList(0, p.size());
            return Objects.equals(p, prefix);
        });
    }

    private BaseRuntimeChildDefinition getDefinition(BaseRuntimeElementCompositeDefinition<?> theCurrentDef, List<String> theSubList) {
        BaseRuntimeChildDefinition nextDef = theCurrentDef.getChildByNameOrThrowDataFormatException(theSubList.get(0));
        if (theSubList.size() == 1) {
            return nextDef;
        }
        BaseRuntimeElementCompositeDefinition cmp = (BaseRuntimeElementCompositeDefinition)nextDef.getChildByName(theSubList.get(0));
        return this.getDefinition(cmp, theSubList.subList(1, theSubList.size()));
    }

    public BaseRuntimeChildDefinition getDefinition(Class<? extends IBaseResource> theResourceType, String thePath) {
        RuntimeResourceDefinition def = this.myContext.getResourceDefinition(theResourceType);
        List<String> parts = Arrays.asList(thePath.split("\\."));
        List<String> subList = parts.subList(1, parts.size());
        if (subList.size() < 1) {
            throw new ConfigurationException(Msg.code(1790) + "Invalid path: " + thePath);
        }
        return this.getDefinition(def, subList);
    }

    public Object getSingleValueOrNull(IBase theTarget, String thePath) {
        Class<IBase> wantedType = IBase.class;
        return this.getSingleValueOrNull(theTarget, thePath, wantedType);
    }

    public <T extends IBase> T getSingleValueOrNull(IBase theTarget, String thePath, Class<T> theWantedType) {
        Validate.notNull((Object)theTarget, (String)"theTarget must not be null", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)thePath, (String)"thePath must not be empty", (Object[])new Object[0]);
        BaseRuntimeElementDefinition<?> def = this.myContext.getElementDefinition(theTarget.getClass());
        if (!(def instanceof BaseRuntimeElementCompositeDefinition)) {
            throw new IllegalArgumentException(Msg.code(1791) + "Target is not a composite type: " + theTarget.getClass().getName());
        }
        BaseRuntimeElementCompositeDefinition currentDef = (BaseRuntimeElementCompositeDefinition)def;
        List<String> parts = this.parsePath(currentDef, thePath);
        List<T> retVal = this.getValues(currentDef, theTarget, parts, theWantedType);
        if (retVal.isEmpty()) {
            return null;
        }
        return (T)((IBase)retVal.get(0));
    }

    public Optional<String> getSinglePrimitiveValue(IBase theTarget, String thePath) {
        return this.getSingleValue(theTarget, thePath, IPrimitiveType.class).map(t -> t.getValueAsString());
    }

    public String getSinglePrimitiveValueOrNull(IBase theTarget, String thePath) {
        return this.getSingleValue(theTarget, thePath, IPrimitiveType.class).map(IPrimitiveType::getValueAsString).orElse(null);
    }

    public <T extends IBase> Optional<T> getSingleValue(IBase theTarget, String thePath, Class<T> theWantedType) {
        return Optional.ofNullable(this.getSingleValueOrNull(theTarget, thePath, theWantedType));
    }

    private <T extends IBase> List<T> getValues(BaseRuntimeElementCompositeDefinition<?> theCurrentDef, IBase theCurrentObj, List<String> theSubList, Class<T> theWantedClass) {
        return this.getValues(theCurrentDef, theCurrentObj, theSubList, theWantedClass, false, false);
    }

    /*
     * WARNING - void declaration
     */
    private <T extends IBase> List<T> getValues(BaseRuntimeElementCompositeDefinition<?> theCurrentDef, IBase theCurrentObj, List<String> theSubList, Class<T> theWantedClass, boolean theCreate, boolean theAddExtension) {
        BaseRuntimeElementDefinition<?> list;
        if (theSubList.isEmpty()) {
            return Collections.emptyList();
        }
        String name = theSubList.get(0);
        ArrayList<IBase> retVal = new ArrayList<IBase>();
        if (name.startsWith("extension('")) {
            String extensionUrl = name.substring("extension('".length());
            int endIndex = extensionUrl.indexOf(39);
            if (endIndex != -1) {
                extensionUrl = extensionUrl.substring(0, endIndex);
            }
            if (this.myContext.getVersion().getVersion().isOlderThan(FhirVersionEnum.DSTU3)) {
                String extensionDtUrlForLambda = extensionUrl;
                List extensionDts = Collections.emptyList();
                if (theCurrentObj instanceof ISupportsUndeclaredExtensions) {
                    extensionDts = ((ISupportsUndeclaredExtensions)theCurrentObj).getUndeclaredExtensions().stream().filter(t -> t.getUrl().equals(extensionDtUrlForLambda)).collect(Collectors.toList());
                    if (theAddExtension && (!(theCurrentObj instanceof IBaseExtension) || extensionDts.isEmpty() && theSubList.size() == 1)) {
                        extensionDts.add(this.createEmptyExtensionDt((ISupportsUndeclaredExtensions)theCurrentObj, extensionUrl));
                    }
                    if (extensionDts.isEmpty() && theCreate) {
                        extensionDts.add(this.createEmptyExtensionDt((ISupportsUndeclaredExtensions)theCurrentObj, extensionUrl));
                    }
                } else if (theCurrentObj instanceof IBaseExtension) {
                    extensionDts = ((IBaseExtension)theCurrentObj).getExtension();
                    if (theAddExtension && extensionDts.isEmpty() && theSubList.size() == 1) {
                        extensionDts.add(this.createEmptyExtensionDt((IBaseExtension)theCurrentObj, extensionUrl));
                    }
                    if (extensionDts.isEmpty() && theCreate) {
                        extensionDts.add(this.createEmptyExtensionDt((IBaseExtension)theCurrentObj, extensionUrl));
                    }
                }
                for (IBaseExtension next : extensionDts) {
                    if (!theWantedClass.isAssignableFrom(next.getClass())) continue;
                    retVal.add(next);
                }
            } else {
                String extensionUrlForLambda = extensionUrl;
                Object extensions = Collections.emptyList();
                if (theCurrentObj instanceof IBaseHasExtensions) {
                    extensions = ((IBaseHasExtensions)theCurrentObj).getExtension().stream().filter(t -> t.getUrl().equals(extensionUrlForLambda)).collect(Collectors.toList());
                    if (theAddExtension && (!(theCurrentObj instanceof IBaseExtension) || extensions.isEmpty() && theSubList.size() == 1)) {
                        extensions.add(this.createEmptyExtension((IBaseHasExtensions)theCurrentObj, extensionUrl));
                    }
                    if (extensions.isEmpty() && theCreate) {
                        extensions.add(this.createEmptyExtension((IBaseHasExtensions)theCurrentObj, extensionUrl));
                    }
                }
                Iterator iterator = extensions.iterator();
                while (iterator.hasNext()) {
                    IBaseExtension next;
                    next = (IBaseExtension)iterator.next();
                    if (!theWantedClass.isAssignableFrom(next.getClass())) continue;
                    retVal.add(next);
                }
            }
            if (theSubList.size() > 1) {
                ArrayList<IBase> values = retVal;
                retVal = new ArrayList();
                for (IBase iBase : values) {
                    BaseRuntimeElementCompositeDefinition nextChildDef = (BaseRuntimeElementCompositeDefinition)this.myContext.getElementDefinition(iBase.getClass());
                    List<T> foundValues = this.getValues(nextChildDef, iBase, theSubList.subList(1, theSubList.size()), theWantedClass, theCreate, theAddExtension);
                    retVal.addAll(foundValues);
                }
            }
            return retVal;
        }
        if (name.startsWith("modifierExtension('")) {
            String extensionUrl = name.substring("modifierExtension('".length());
            int endIndex = extensionUrl.indexOf(39);
            if (endIndex != -1) {
                extensionUrl = extensionUrl.substring(0, endIndex);
            }
            if (this.myContext.getVersion().getVersion().isOlderThan(FhirVersionEnum.DSTU3)) {
                String extensionDtUrlForLambda = extensionUrl;
                List extensionDts = Collections.emptyList();
                if (theCurrentObj instanceof ISupportsUndeclaredExtensions) {
                    extensionDts = ((ISupportsUndeclaredExtensions)theCurrentObj).getUndeclaredModifierExtensions().stream().filter(t -> t.getUrl().equals(extensionDtUrlForLambda)).collect(Collectors.toList());
                    if (theAddExtension && (!(theCurrentObj instanceof IBaseExtension) || extensionDts.isEmpty() && theSubList.size() == 1)) {
                        extensionDts.add(this.createEmptyModifierExtensionDt((ISupportsUndeclaredExtensions)theCurrentObj, extensionUrl));
                    }
                    if (extensionDts.isEmpty() && theCreate) {
                        extensionDts.add(this.createEmptyModifierExtensionDt((ISupportsUndeclaredExtensions)theCurrentObj, extensionUrl));
                    }
                } else if (theCurrentObj instanceof IBaseExtension) {
                    extensionDts = ((IBaseExtension)theCurrentObj).getExtension();
                    if (theAddExtension && extensionDts.isEmpty() && theSubList.size() == 1) {
                        extensionDts.add(this.createEmptyExtensionDt((IBaseExtension)theCurrentObj, extensionUrl));
                    }
                    if (extensionDts.isEmpty() && theCreate) {
                        extensionDts.add(this.createEmptyExtensionDt((IBaseExtension)theCurrentObj, extensionUrl));
                    }
                }
                for (IBaseExtension next : extensionDts) {
                    if (!theWantedClass.isAssignableFrom(next.getClass())) continue;
                    retVal.add(next);
                }
            } else {
                String extensionUrlForLambda = extensionUrl;
                Object extensions = Collections.emptyList();
                if (theCurrentObj instanceof IBaseHasModifierExtensions) {
                    extensions = ((IBaseHasModifierExtensions)((Object)theCurrentObj)).getModifierExtension().stream().filter(t -> t.getUrl().equals(extensionUrlForLambda)).collect(Collectors.toList());
                    if (theAddExtension && (!(theCurrentObj instanceof IBaseExtension) || extensions.isEmpty() && theSubList.size() == 1)) {
                        extensions.add(this.createEmptyModifierExtension((IBaseHasModifierExtensions)((Object)theCurrentObj), extensionUrl));
                    }
                    if (extensions.isEmpty() && theCreate) {
                        extensions.add(this.createEmptyModifierExtension((IBaseHasModifierExtensions)((Object)theCurrentObj), extensionUrl));
                    }
                }
                Iterator iterator = extensions.iterator();
                while (iterator.hasNext()) {
                    IBaseExtension next;
                    next = (IBaseExtension)iterator.next();
                    if (!theWantedClass.isAssignableFrom(next.getClass())) continue;
                    retVal.add(next);
                }
            }
            if (theSubList.size() > 1) {
                ArrayList<IBase> values = retVal;
                retVal = new ArrayList();
                for (IBase iBase : values) {
                    BaseRuntimeElementCompositeDefinition nextChildDef = (BaseRuntimeElementCompositeDefinition)this.myContext.getElementDefinition(iBase.getClass());
                    List<T> foundValues = this.getValues(nextChildDef, iBase, theSubList.subList(1, theSubList.size()), theWantedClass, theCreate, theAddExtension);
                    retVal.addAll(foundValues);
                }
            }
            return retVal;
        }
        BaseRuntimeChildDefinition nextDef = theCurrentDef.getChildByNameOrThrowDataFormatException(name);
        List<IBase> values = nextDef.getAccessor().getValues(theCurrentObj);
        if (values.isEmpty() && theCreate) {
            void var13_33;
            BaseRuntimeElementDefinition<?> childByName = nextDef.getChildByName(name);
            Object arg = nextDef.getInstanceConstructorArguments();
            if (arg != null) {
                Object obj = childByName.newInstance(arg);
            } else {
                Object obj = childByName.newInstance();
            }
            nextDef.getMutator().addValue(theCurrentObj, (IBase)var13_33);
            list = new ArrayList();
            list.add(var13_33);
            values = list;
        }
        if (theSubList.size() == 1) {
            if (nextDef instanceof RuntimeChildChoiceDefinition) {
                for (IBase next : values) {
                    if (next == null) continue;
                    if (name.endsWith("[x]")) {
                        if (theWantedClass != null && !theWantedClass.isAssignableFrom(next.getClass())) continue;
                        retVal.add(next);
                        continue;
                    }
                    String string = nextDef.getChildNameByDatatype(next.getClass());
                    if (!theSubList.get(0).equals(string) || theWantedClass != null && !theWantedClass.isAssignableFrom(next.getClass())) continue;
                    retVal.add(next);
                }
            } else {
                for (IBase next : values) {
                    if (next == null || theWantedClass != null && !theWantedClass.isAssignableFrom(next.getClass())) continue;
                    retVal.add(next);
                }
            }
        } else {
            for (IBase nextElement : values) {
                list = this.myContext.getElementDefinition(nextElement.getClass());
                if (!(list instanceof BaseRuntimeElementCompositeDefinition)) continue;
                BaseRuntimeElementCompositeDefinition baseRuntimeElementCompositeDefinition = (BaseRuntimeElementCompositeDefinition)list;
                List<T> foundValues = this.getValues(baseRuntimeElementCompositeDefinition, nextElement, theSubList.subList(1, theSubList.size()), theWantedClass, theCreate, theAddExtension);
                retVal.addAll(foundValues);
            }
        }
        return retVal;
    }

    public List<IBase> getValues(IBase theElement, String thePath) {
        Class<IBase> wantedClass = IBase.class;
        return this.getValues(theElement, thePath, wantedClass);
    }

    public List<IBase> getValues(IBase theElement, String thePath, boolean theCreate) {
        Class<IBase> wantedClass = IBase.class;
        return this.getValues(theElement, thePath, wantedClass, theCreate);
    }

    public List<IBase> getValues(IBase theElement, String thePath, boolean theCreate, boolean theAddExtension) {
        Class<IBase> wantedClass = IBase.class;
        return this.getValues(theElement, thePath, wantedClass, theCreate, theAddExtension);
    }

    public <T extends IBase> List<T> getValues(IBase theElement, String thePath, Class<T> theWantedClass) {
        BaseRuntimeElementCompositeDefinition def = (BaseRuntimeElementCompositeDefinition)this.myContext.getElementDefinition(theElement.getClass());
        List<String> parts = this.parsePath(def, thePath);
        return this.getValues(def, theElement, parts, theWantedClass);
    }

    public <T extends IBase> List<T> getValues(IBase theElement, String thePath, Class<T> theWantedClass, boolean theCreate) {
        BaseRuntimeElementCompositeDefinition def = (BaseRuntimeElementCompositeDefinition)this.myContext.getElementDefinition(theElement.getClass());
        List<String> parts = this.parsePath(def, thePath);
        return this.getValues(def, theElement, parts, theWantedClass, theCreate, false);
    }

    public <T extends IBase> List<T> getValues(IBase theElement, String thePath, Class<T> theWantedClass, boolean theCreate, boolean theAddExtension) {
        BaseRuntimeElementCompositeDefinition def = (BaseRuntimeElementCompositeDefinition)this.myContext.getElementDefinition(theElement.getClass());
        List<String> parts = this.parsePath(def, thePath);
        return this.getValues(def, theElement, parts, theWantedClass, theCreate, theAddExtension);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<String> parsePath(BaseRuntimeElementCompositeDefinition<?> theElementDef, String thePath) {
        void var3_7;
        ArrayList<String> arrayList = new ArrayList<String>();
        int currentStart = 0;
        boolean inSingleQuote = false;
        block4: for (int i = 0; i < thePath.length(); ++i) {
            switch (thePath.charAt(i)) {
                case '\'': {
                    inSingleQuote = !inSingleQuote;
                    continue block4;
                }
                case '.': {
                    if (inSingleQuote) continue block4;
                    arrayList.add(thePath.substring(currentStart, i));
                    currentStart = i + 1;
                }
            }
        }
        arrayList.add(thePath.substring(currentStart));
        String firstPart = (String)arrayList.get(0);
        if (Character.isUpperCase(firstPart.charAt(0)) && theElementDef instanceof RuntimeResourceDefinition) {
            if (!firstPart.equals(theElementDef.getName())) return Collections.emptyList();
            List list = arrayList.subList(1, arrayList.size());
        } else if (firstPart.equals(theElementDef.getName())) {
            List list = arrayList.subList(1, arrayList.size());
        }
        if (var3_7.size() >= 1) return var3_7;
        throw new ConfigurationException(Msg.code(1792) + "Invalid path: " + thePath);
    }

    public boolean isSourceInCompartmentForTarget(String theCompartmentName, IBaseResource theSource, IIdType theTarget) {
        return this.isSourceInCompartmentForTarget(theCompartmentName, theSource, theTarget, new CompartmentSearchParameterModifications());
    }

    @Deprecated
    public boolean isSourceInCompartmentForTarget(String theCompartmentName, IBaseResource theSource, IIdType theTarget, @Nullable Set<String> theAdditionalCompartmentParamNames) {
        return this.isSourceInCompartmentForTarget(theCompartmentName, theSource, theTarget, CompartmentSearchParameterModifications.fromAdditionalCompartmentParamNames(this.myContext.getResourceType(theSource), theAdditionalCompartmentParamNames == null ? Set.of() : theAdditionalCompartmentParamNames));
    }

    public boolean isSourceInCompartmentForTarget(String theCompartmentName, IBaseResource theSource, IIdType theTarget, CompartmentSearchParameterModifications theModifications) {
        Validate.notBlank((CharSequence)theCompartmentName, (String)"theCompartmentName must not be null or blank", (Object[])new Object[0]);
        Validate.notNull((Object)theSource, (String)"theSource must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)theTarget, (String)"theTarget must not be null", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)StringUtils.defaultString((String)theTarget.getResourceType()), (String)"theTarget must have a populated resource type (theTarget.getResourceType() does not return a value)", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)StringUtils.defaultString((String)theTarget.getIdPart()), (String)"theTarget must have a populated ID (theTarget.getIdPart() does not return a value)", (Object[])new Object[0]);
        String wantRef = theTarget.toUnqualifiedVersionless().getValue();
        RuntimeResourceDefinition sourceDef = this.myContext.getResourceDefinition(theSource);
        if (theSource.getIdElement().hasIdPart() && wantRef.equals(sourceDef.getName() + "/" + theSource.getIdElement().getIdPart())) {
            return true;
        }
        class CompartmentOwnerVisitor
        implements ICompartmentOwnerVisitor {
            private final String myWantRef;
            private boolean myFound;

            public boolean isFound() {
                return this.myFound;
            }

            public CompartmentOwnerVisitor(String theWantRef) {
                this.myWantRef = theWantRef;
            }

            @Override
            public boolean consume(IIdType theCompartmentOwner) {
                if (this.myWantRef.equals(theCompartmentOwner.toUnqualifiedVersionless().getValue())) {
                    this.myFound = true;
                }
                return !this.myFound;
            }
        }
        CompartmentOwnerVisitor consumer = new CompartmentOwnerVisitor(wantRef);
        this.visitCompartmentOwnersForResource(theCompartmentName, theSource, theModifications, consumer);
        return consumer.isFound();
    }

    public List<IIdType> getCompartmentOwnersForResource(String theCompartmentName, IBaseResource theSource, @Nullable Set<String> theAdditionalCompartmentParamNames) {
        return this.getCompartmentOwnersForResource(theCompartmentName, theSource, CompartmentSearchParameterModifications.fromAdditionalCompartmentParamNames(this.myContext.getResourceType(theCompartmentName), theAdditionalCompartmentParamNames == null ? Set.of() : theAdditionalCompartmentParamNames));
    }

    @Nonnull
    public List<IIdType> getCompartmentOwnersForResource(String theCompartmentName, IBaseResource theSource, CompartmentSearchParameterModifications theModifications) {
        Validate.notBlank((CharSequence)theCompartmentName, (String)"theCompartmentName must not be null or blank", (Object[])new Object[0]);
        Validate.notNull((Object)theSource, (String)"theSource must not be null", (Object[])new Object[0]);
        class CompartmentOwnerVisitor
        implements ICompartmentOwnerVisitor {
            private final Set<String> myOwnersAdded = new HashSet<String>();
            private final List<IIdType> myOwners = new ArrayList<IIdType>(2);

            CompartmentOwnerVisitor() {
            }

            public List<IIdType> getOwners() {
                return this.myOwners;
            }

            @Override
            public boolean consume(IIdType theCompartmentOwner) {
                if (this.myOwnersAdded.add(theCompartmentOwner.getValue())) {
                    this.myOwners.add(theCompartmentOwner);
                }
                return true;
            }
        }
        CompartmentOwnerVisitor consumer = new CompartmentOwnerVisitor();
        this.visitCompartmentOwnersForResource(theCompartmentName, theSource, theModifications, consumer);
        return consumer.getOwners();
    }

    public Stream<IBaseReference> getCompartmentReferencesForResource(String theCompartmentName, IBaseResource theSource, @Nullable Set<String> theAdditionalCompartmentParamNames) {
        return this.getCompartmentReferencesForResource(theCompartmentName, theSource, CompartmentSearchParameterModifications.fromAdditionalCompartmentParamNames(this.myContext.getResourceType(theCompartmentName), theAdditionalCompartmentParamNames == null ? Set.of() : theAdditionalCompartmentParamNames));
    }

    @Nonnull
    public Stream<IBaseReference> getCompartmentReferencesForResource(String theCompartmentName, IBaseResource theSource, @Nullable CompartmentSearchParameterModifications theModifications) {
        Set<Object> omittedSPNames;
        Set<Object> additionalSPNames;
        Validate.notBlank((CharSequence)theCompartmentName, (String)"theCompartmentName must not be null or blank", (Object[])new Object[0]);
        Validate.notNull((Object)theSource, (String)"theSource must not be null", (Object[])new Object[0]);
        if (theModifications != null) {
            String resourceType = this.myContext.getResourceType(theSource);
            additionalSPNames = theModifications.getAdditionalSearchParamNamesForResourceType(resourceType);
            omittedSPNames = theModifications.getOmittedSPNamesForResourceType(resourceType);
        } else {
            additionalSPNames = new HashSet();
            omittedSPNames = new HashSet();
        }
        RuntimeResourceDefinition sourceDef = this.myContext.getResourceDefinition(theSource);
        List params = sourceDef.getSearchParamsForCompartmentName(theCompartmentName).stream().filter(p -> !omittedSPNames.contains(p.getName())).collect(Collectors.toList());
        additionalSPNames.stream().map(sourceDef::getSearchParam).filter(Objects::nonNull).forEach(params::add);
        return params.stream().flatMap(nextParam -> nextParam.getPathsSplit().stream()).filter(StringUtils::isNotBlank).flatMap(nextPath -> {
            String wantType;
            Matcher matcher = COMPARTMENT_MATCHER_PATH.matcher((CharSequence)nextPath);
            if (matcher.matches()) {
                nextPath = matcher.group(1);
                wantType = matcher.group(2);
            } else {
                wantType = null;
            }
            return this.getValues((IBase)theSource, (String)nextPath, (Class)IBaseReference.class).stream().filter(nextValue -> StringUtils.isEmpty((CharSequence)wantType) || wantType.equals(this.getTypeFromReference((IBaseReference)nextValue)));
        });
    }

    private String getTypeFromReference(IBaseReference theReference) {
        IIdType nextTargetId = theReference.getReferenceElement().toUnqualifiedVersionless();
        if (StringUtils.isNotBlank((CharSequence)nextTargetId.getResourceType())) {
            return nextTargetId.getResourceType();
        }
        if (theReference.getResource() != null) {
            return this.myContext.getResourceType(theReference.getResource());
        }
        return "No type on reference";
    }

    private void visitCompartmentOwnersForResource(String theCompartmentName, IBaseResource theSource, CompartmentSearchParameterModifications theCompartmentModifications, ICompartmentOwnerVisitor theConsumer) {
        this.getCompartmentReferencesForResource(theCompartmentName, theSource, theCompartmentModifications).flatMap(nextValue -> {
            IBaseResource nextTarget;
            IIdType nextTargetId = nextValue.getReferenceElement().toUnqualifiedVersionless();
            if (StringUtils.isBlank((CharSequence)nextTargetId.getValue()) && nextValue.getResource() != null && !(nextTargetId = (nextTarget = nextValue.getResource()).getIdElement().toUnqualifiedVersionless()).hasResourceType()) {
                String resourceType = this.myContext.getResourceType(nextTarget);
                nextTargetId.setParts(null, resourceType, nextTargetId.getIdPart(), null);
            }
            if (StringUtils.isNotBlank((CharSequence)nextTargetId.getValue())) {
                return Stream.of(nextTargetId);
            }
            return Stream.empty();
        }).takeWhile(theConsumer::consume).forEach(Consumers.nop());
    }

    private void visit(IBase theElement, BaseRuntimeChildDefinition theChildDefinition, BaseRuntimeElementDefinition<?> theDefinition, IModelVisitor2 theCallback, List<IBase> theContainingElementPath, List<BaseRuntimeChildDefinition> theChildDefinitionPath, List<BaseRuntimeElementDefinition<?>> theElementDefinitionPath) {
        if (theChildDefinition != null) {
            theChildDefinitionPath.add(theChildDefinition);
        }
        theContainingElementPath.add(theElement);
        theElementDefinitionPath.add(theDefinition);
        boolean recurse = theCallback.acceptElement(theElement, Collections.unmodifiableList(theContainingElementPath), Collections.unmodifiableList(theChildDefinitionPath), Collections.unmodifiableList(theElementDefinitionPath));
        if (recurse) {
            if (theElement instanceof ISupportsUndeclaredExtensions) {
                ISupportsUndeclaredExtensions containingElement = (ISupportsUndeclaredExtensions)theElement;
                for (ExtensionDt extensionDt : containingElement.getUndeclaredExtensions()) {
                    theContainingElementPath.add(extensionDt);
                    theCallback.acceptUndeclaredExtension(extensionDt, theContainingElementPath, theChildDefinitionPath, theElementDefinitionPath);
                    theContainingElementPath.remove(theContainingElementPath.size() - 1);
                }
            }
            switch (theDefinition.getChildType()) {
                case ID_DATATYPE: 
                case PRIMITIVE_XHTML_HL7ORG: 
                case PRIMITIVE_XHTML: 
                case PRIMITIVE_DATATYPE: {
                    break;
                }
                case RESOURCE: 
                case RESOURCE_BLOCK: 
                case COMPOSITE_DATATYPE: {
                    BaseRuntimeElementCompositeDefinition childDef = (BaseRuntimeElementCompositeDefinition)theDefinition;
                    for (BaseRuntimeChildDefinition baseRuntimeChildDefinition : childDef.getChildrenAndExtension()) {
                        List<IBase> values = baseRuntimeChildDefinition.getAccessor().getValues(theElement);
                        if (values == null) continue;
                        for (IBase nextValue : values) {
                            if (nextValue == null || nextValue.isEmpty()) continue;
                            Class<?> valueType = nextValue.getClass();
                            BaseRuntimeElementDefinition<?> childElementDef = baseRuntimeChildDefinition.getChildElementDefinitionByDatatype(valueType);
                            while (childElementDef == null && IBase.class.isAssignableFrom(valueType)) {
                                childElementDef = baseRuntimeChildDefinition.getChildElementDefinitionByDatatype(valueType);
                                valueType = valueType.getSuperclass();
                            }
                            Class<?> typeClass = nextValue.getClass();
                            while (childElementDef == null && IBase.class.isAssignableFrom(typeClass)) {
                                typeClass = typeClass.getSuperclass();
                                childElementDef = baseRuntimeChildDefinition.getChildElementDefinitionByDatatype(typeClass);
                            }
                            Validate.notNull(childElementDef, (String)"Found value of type[%s] which is not valid for field[%s] in %s", (Object[])new Object[]{nextValue.getClass(), baseRuntimeChildDefinition.getElementName(), childDef.getName()});
                            this.visit(nextValue, baseRuntimeChildDefinition, childElementDef, theCallback, theContainingElementPath, theChildDefinitionPath, theElementDefinitionPath);
                        }
                    }
                    break;
                }
                case CONTAINED_RESOURCES: {
                    BaseContainedDt value = (BaseContainedDt)theElement;
                    for (IResource iResource : value.getContainedResources()) {
                        RuntimeResourceDefinition def = this.myContext.getResourceDefinition(iResource);
                        this.visit(iResource, null, def, theCallback, theContainingElementPath, theChildDefinitionPath, theElementDefinitionPath);
                    }
                    break;
                }
                case EXTENSION_DECLARED: 
                case UNDECL_EXT: {
                    throw new IllegalStateException(Msg.code(1793) + "state should not happen: " + String.valueOf((Object)theDefinition.getChildType()));
                }
                case CONTAINED_RESOURCE_LIST: {
                    if (theElement == null) break;
                    BaseRuntimeElementDefinition<?> def = this.myContext.getElementDefinition(theElement.getClass());
                    this.visit(theElement, null, def, theCallback, theContainingElementPath, theChildDefinitionPath, theElementDefinitionPath);
                }
            }
        }
        if (theChildDefinition != null) {
            theChildDefinitionPath.remove(theChildDefinitionPath.size() - 1);
        }
        theContainingElementPath.remove(theContainingElementPath.size() - 1);
        theElementDefinitionPath.remove(theElementDefinitionPath.size() - 1);
    }

    public void visit(IBaseResource theResource, IModelVisitor theVisitor) {
        RuntimeResourceDefinition def = this.myContext.getResourceDefinition(theResource);
        this.visit(this.newMap(), theResource, theResource, null, null, def, theVisitor);
    }

    public Map<Object, Object> newMap() {
        return new IdentityHashMap<Object, Object>();
    }

    public void visit(IBase theElement, IModelVisitor2 theVisitor) {
        BaseRuntimeElementDefinition<?> def = this.myContext.getElementDefinition(theElement.getClass());
        if (def instanceof BaseRuntimeElementCompositeDefinition) {
            this.visit(theElement, null, def, theVisitor, new ArrayList<IBase>(), new ArrayList<BaseRuntimeChildDefinition>(), new ArrayList());
        } else if (theElement instanceof IBaseExtension) {
            theVisitor.acceptUndeclaredExtension((IBaseExtension)theElement, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        } else {
            theVisitor.acceptElement(theElement, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        }
    }

    private void visit(Map<Object, Object> theStack, IBaseResource theResource, IBase theElement, List<String> thePathToElement, BaseRuntimeChildDefinition theChildDefinition, BaseRuntimeElementDefinition<?> theDefinition, IModelVisitor theCallback) {
        IBaseResource target;
        List<String> pathToElement = this.addNameToList(thePathToElement, theChildDefinition);
        if (theStack.put(theElement, theElement) != null) {
            return;
        }
        theCallback.acceptElement(theResource, theElement, pathToElement, theChildDefinition, theDefinition);
        BaseRuntimeElementDefinition def = theDefinition;
        if (def.getChildType() == BaseRuntimeElementDefinition.ChildTypeEnum.CONTAINED_RESOURCE_LIST) {
            Class<?> clazz = theElement.getClass();
            def = this.myContext.getElementDefinition(clazz);
            Validate.notNull((Object)def, (String)"Unable to find element definition for class: %s", (Object[])new Object[]{clazz});
        }
        if (theElement instanceof IBaseReference && (target = ((IBaseReference)theElement).getResource()) != null && (!target.getIdElement().hasIdPart() || target.getIdElement().isLocal())) {
            RuntimeResourceDefinition targetDef = this.myContext.getResourceDefinition(target);
            this.visit(theStack, target, target, pathToElement, null, targetDef, theCallback);
        }
        switch (def.getChildType()) {
            case ID_DATATYPE: 
            case PRIMITIVE_XHTML_HL7ORG: 
            case PRIMITIVE_XHTML: 
            case PRIMITIVE_DATATYPE: {
                break;
            }
            case RESOURCE: 
            case RESOURCE_BLOCK: 
            case COMPOSITE_DATATYPE: {
                BaseRuntimeElementCompositeDefinition childDef = (BaseRuntimeElementCompositeDefinition)def;
                List<BaseRuntimeChildDefinition> childrenAndExtensionDefs = childDef.getChildrenAndExtension();
                for (BaseRuntimeChildDefinition nextChild : childrenAndExtensionDefs) {
                    List<IBase> values = nextChild.getAccessor().getValues(theElement);
                    if (values == null) continue;
                    for (IBase nextValueObject : values) {
                        IBase nextValue;
                        try {
                            nextValue = nextValueObject;
                        }
                        catch (ClassCastException e) {
                            String s = "Found instance of " + String.valueOf(nextValueObject.getClass()) + " - Did you set a field value to the incorrect type? Expected " + IBase.class.getName();
                            throw new ClassCastException(Msg.code(1794) + s);
                        }
                        if (nextValue == null || nextValue.isEmpty()) continue;
                        Class<?> clazz = nextValue.getClass();
                        BaseRuntimeElementDefinition<?> childElementDef = nextChild.getChildElementDefinitionByDatatype(clazz);
                        if (childElementDef == null) {
                            childElementDef = this.myContext.getElementDefinition(clazz);
                            Validate.notNull(childElementDef, (String)"Unable to find element definition for class: %s", (Object[])new Object[]{clazz});
                        }
                        if (nextChild instanceof RuntimeChildDirectResource) {
                            theCallback.acceptElement(theResource, nextValue, null, nextChild, childElementDef);
                            continue;
                        }
                        this.visit(theStack, theResource, nextValue, pathToElement, nextChild, childElementDef, theCallback);
                    }
                }
                break;
            }
            case CONTAINED_RESOURCES: {
                BaseContainedDt value = (BaseContainedDt)theElement;
                for (IResource iResource : value.getContainedResources()) {
                    def = this.myContext.getResourceDefinition(iResource);
                    this.visit(theStack, iResource, iResource, pathToElement, null, def, theCallback);
                }
                break;
            }
            case EXTENSION_DECLARED: 
            case UNDECL_EXT: 
            case CONTAINED_RESOURCE_LIST: {
                throw new IllegalStateException(Msg.code(1795) + "state should not happen: " + String.valueOf((Object)def.getChildType()));
            }
        }
        theStack.remove(theElement);
    }

    public Collection<IBaseResource> getAllEmbeddedResources(final IBaseResource theResource, final boolean theRecurse) {
        Validate.notNull((Object)theResource, (String)"theResource must not be null", (Object[])new Object[0]);
        final ArrayList<IBaseResource> retVal = new ArrayList<IBaseResource>();
        this.visit((IBase)theResource, new IModelVisitor2(){

            @Override
            public boolean acceptElement(IBase theElement, List<IBase> theContainingElementPath, List<BaseRuntimeChildDefinition> theChildDefinitionPath, List<BaseRuntimeElementDefinition<?>> theElementDefinitionPath) {
                if (theElement == theResource) {
                    return true;
                }
                if (theElement instanceof IBaseResource) {
                    retVal.add((IBaseResource)theElement);
                    return theRecurse;
                }
                return true;
            }

            @Override
            public boolean acceptUndeclaredExtension(IBaseExtension<?, ?> theNextExt, List<IBase> theContainingElementPath, List<BaseRuntimeChildDefinition> theChildDefinitionPath, List<BaseRuntimeElementDefinition<?>> theElementDefinitionPath) {
                return true;
            }
        });
        return retVal;
    }

    public void clear(IBaseResource theInput) {
        this.visit((IBase)theInput, new IModelVisitor2(){

            @Override
            public boolean acceptElement(IBase theElement, List<IBase> theContainingElementPath, List<BaseRuntimeChildDefinition> theChildDefinitionPath, List<BaseRuntimeElementDefinition<?>> theElementDefinitionPath) {
                if (theElement instanceof IPrimitiveType) {
                    ((IPrimitiveType)theElement).setValueAsString(null);
                }
                return true;
            }

            @Override
            public boolean acceptUndeclaredExtension(IBaseExtension<?, ?> theNextExt, List<IBase> theContainingElementPath, List<BaseRuntimeChildDefinition> theChildDefinitionPath, List<BaseRuntimeElementDefinition<?>> theElementDefinitionPath) {
                theNextExt.setUrl(null);
                theNextExt.setValue(null);
                return true;
            }
        });
    }

    private void containResourcesForEncoding(ContainedResources theContained, IBaseResource theResource) {
        IBaseResource resource;
        List<IBaseReference> allReferences = this.getAllPopulatedChildElementsOfType(theResource, IBaseReference.class);
        allReferences.sort(REFERENCES_WITH_IDS_FIRST);
        for (IBaseReference next : allReferences) {
            IBaseResource potentialTarget;
            resource = next.getResource();
            if (resource != null || !next.getReferenceElement().isLocal() || !theContained.hasExistingIdToContainedResource() || (potentialTarget = theContained.getExistingIdToContainedResource().remove(next.getReferenceElement().getValue())) == null) continue;
            theContained.addContained(next.getReferenceElement(), potentialTarget);
            this.containResourcesForEncoding(theContained, potentialTarget);
        }
        for (IBaseReference next : allReferences) {
            resource = next.getResource();
            if (resource == null) continue;
            if (resource.getIdElement().isEmpty() || resource.getIdElement().isLocal()) {
                IIdType id = theContained.addContained(resource);
                if (id == null) continue;
                this.getContainedResourceList(theResource).add(resource);
                Object idString = id.getValue();
                if (!((String)idString).startsWith("#")) {
                    idString = "#" + (String)idString;
                }
                next.setReference((String)idString);
                next.setResource(null);
                if (!resource.getIdElement().isLocal() || !theContained.hasExistingIdToContainedResource()) continue;
                theContained.getExistingIdToContainedResource().remove(resource.getIdElement().getValue());
                continue;
            }
            IIdType previouslyContainedResourceId = theContained.getPreviouslyContainedResourceId(resource);
            if (previouslyContainedResourceId == null || theContained.getResourceId(resource) != null) continue;
            theContained.addContained(previouslyContainedResourceId, resource);
            this.getContainedResourceList(theResource).add(resource);
        }
    }

    public ContainedResources containResources(IBaseResource theResource, ContainedResources theParentContainedResources, boolean theStoreResults) {
        Object cachedValue;
        if (theStoreResults && (cachedValue = theResource.getUserData(USER_DATA_KEY_CONTAIN_RESOURCES_COMPLETED)) != null) {
            return (ContainedResources)cachedValue;
        }
        ContainedResources contained = new ContainedResources();
        List<IBaseResource> containedResources = this.getContainedResourceList(theResource);
        for (IBaseResource next : containedResources) {
            String nextId = next.getIdElement().getValue();
            if (StringUtils.isNotBlank((CharSequence)nextId)) {
                while (nextId.startsWith("#")) {
                    ourLog.warn("Found contained resource with ID starting with # character ({}). This form of ID is deprecated and will be dropped in a future release, preventing the current code from working correctly.", (Object)nextId);
                    nextId = nextId.substring(1);
                }
                next.getIdElement().setValue(nextId);
            }
            contained.addContained(next);
        }
        if (this.myContext.getParserOptions().isAutoContainReferenceTargetsWithNoId()) {
            if (theParentContainedResources != null) {
                if (theParentContainedResources.hasResourceToIdValues()) {
                    contained.getPreviouslyContainedResourceToIdMap().putAll(theParentContainedResources.getResourceToIdMap());
                }
                if (theParentContainedResources.hasPreviouslyContainedResourceToIdValues()) {
                    contained.getPreviouslyContainedResourceToIdMap().putAll(theParentContainedResources.getPreviouslyContainedResourceToIdMap());
                }
            }
            this.containResourcesForEncoding(contained, theResource);
        }
        if (theStoreResults) {
            theResource.setUserData(USER_DATA_KEY_CONTAIN_RESOURCES_COMPLETED, contained);
        }
        return contained;
    }

    private <T extends IBaseResource> List<T> getContainedResourceList(T theResource) {
        List<Object> containedResources = Collections.emptyList();
        if (theResource instanceof IResource) {
            containedResources = ((IResource)theResource).getContained().getContainedResources();
        } else if (theResource instanceof IDomainResource) {
            containedResources = ((IDomainResource)theResource).getContained();
        }
        return containedResources;
    }

    @Nonnull
    public <T extends IBase> T addElement(@Nonnull IBase theTarget, @Nonnull String thePath) {
        return (T)((IBase)this.doAddElement(theTarget, thePath, 1).get(0));
    }

    private <T extends IBase> List<T> doAddElement(IBase theTarget, String thePath, int theElementsToAdd) {
        if (theElementsToAdd == 0) {
            return Collections.emptyList();
        }
        IBase target = theTarget;
        BaseRuntimeElementCompositeDefinition def = (BaseRuntimeElementCompositeDefinition)this.myContext.getElementDefinition(target.getClass());
        List<String> parts = this.parsePath(def, thePath);
        int i = 0;
        int partsSize = parts.size();
        while (true) {
            IBase childValue;
            String nextPart = parts.get(i);
            boolean lastPart = i == partsSize - 1;
            BaseRuntimeChildDefinition nextChild = def.getChildByName(nextPart);
            if (nextChild == null) {
                throw new DataFormatException(Msg.code(1796) + "Invalid path " + thePath + ": Element of type " + def.getName() + " has no child named " + nextPart + ". Valid names: " + def.getChildrenAndExtension().stream().map(BaseRuntimeChildDefinition::getElementName).sorted().collect(Collectors.joining(", ")));
            }
            List<IBase> childValues = nextChild.getAccessor().getValues(target);
            if (childValues.size() > 0 && !lastPart) {
                childValue = childValues.get(0);
            } else {
                if (lastPart && !childValues.isEmpty()) {
                    if (theElementsToAdd == -1) {
                        return Collections.singletonList(childValues.get(0));
                    }
                    if (nextChild.getMax() == 1 && !childValues.get(0).isEmpty()) {
                        throw new DataFormatException(Msg.code(1797) + "Element at path " + thePath + " is not repeatable and not empty");
                    }
                    if (nextChild.getMax() == 1 && childValues.get(0).isEmpty()) {
                        return Collections.singletonList(childValues.get(0));
                    }
                }
                BaseRuntimeElementDefinition<?> elementDef = nextChild.getChildByName(nextPart);
                childValue = elementDef.newInstance(nextChild.getInstanceConstructorArguments());
                nextChild.getMutator().addValue(target, childValue);
                if (lastPart) {
                    if (theElementsToAdd == 1 || theElementsToAdd == -1) {
                        return Collections.singletonList(childValue);
                    }
                    if (nextChild.getMax() == 1) {
                        throw new DataFormatException(Msg.code(1798) + "Can not add multiple values at path " + thePath + ": Element does not repeat");
                    }
                    ArrayList values = Lists.newArrayList((Object[])new IBase[]{childValue});
                    for (int j = 1; j < theElementsToAdd; ++j) {
                        childValue = elementDef.newInstance(nextChild.getInstanceConstructorArguments());
                        nextChild.getMutator().addValue(target, childValue);
                        values.add(childValue);
                    }
                    return values;
                }
            }
            target = childValue;
            if (!lastPart) {
                BaseRuntimeElementDefinition<?> nextDef = this.myContext.getElementDefinition(target.getClass());
                if (!(nextDef instanceof BaseRuntimeElementCompositeDefinition)) {
                    throw new DataFormatException(Msg.code(1799) + "Invalid path " + thePath + ": Element of type " + def.getName() + " has no child named " + nextPart + " (this is a primitive type)");
                }
                def = (BaseRuntimeElementCompositeDefinition)nextDef;
            }
            ++i;
        }
    }

    @Nonnull
    public <T extends IBase> T addElement(@Nonnull IBase theTarget, @Nonnull String thePath, @Nullable String theValue) {
        IBase value = (IBase)this.doAddElement(theTarget, thePath, 1).get(0);
        if (!(value instanceof IPrimitiveType)) {
            throw new DataFormatException(Msg.code(1800) + "Element at path " + thePath + " is not a primitive datatype. Found: " + this.myContext.getElementDefinition(value.getClass()).getName());
        }
        ((IPrimitiveType)value).setValueAsString(theValue);
        return (T)value;
    }

    @Nonnull
    public <T extends IBase> T setElement(@Nonnull IBase theTarget, @Nonnull String thePath, @Nullable String theValue) {
        IBase value = (IBase)this.doAddElement(theTarget, thePath, -1).get(0);
        if (!(value instanceof IPrimitiveType)) {
            throw new DataFormatException(Msg.code(1801) + "Element at path " + thePath + " is not a primitive datatype. Found: " + this.myContext.getElementDefinition(value.getClass()).getName());
        }
        ((IPrimitiveType)value).setValueAsString(theValue);
        return (T)value;
    }

    public void addElements(IBase theTarget, String thePath, Collection<String> theValues) {
        List targets = this.doAddElement(theTarget, thePath, theValues.size());
        Iterator<String> valuesIter = theValues.iterator();
        for (IBase target : targets) {
            if (!(target instanceof IPrimitiveType)) {
                throw new DataFormatException(Msg.code(1802) + "Element at path " + thePath + " is not a primitive datatype. Found: " + this.myContext.getElementDefinition(target.getClass()).getName());
            }
            ((IPrimitiveType)target).setValueAsString(valuesIter.next());
        }
    }

    public boolean fieldExists(String theFieldName, IBaseResource theResource) {
        return this.myContext.getResourceDefinition(theResource).getChildByName(theFieldName) != null;
    }

    public <T extends IBaseResource> T clone(T theSource) {
        Validate.notNull(theSource, (String)"theSource must not be null", (Object[])new Object[0]);
        IBaseResource target = (IBaseResource)this.myContext.getResourceDefinition(theSource).newInstance();
        this.cloneInto(theSource, target, false);
        return (T)target;
    }

    @FunctionalInterface
    private static interface ICompartmentOwnerVisitor {
        public boolean consume(IIdType var1);
    }

    public static class ContainedResources {
        private List<IBaseResource> myResourceList;
        private IdentityHashMap<IBaseResource, IIdType> myResourceToIdMap;
        private IdentityHashMap<IBaseResource, IIdType> myPreviouslyContainedResourceToIdMap;
        private Map<String, IBaseResource> myExistingIdToContainedResourceMap;

        public Map<String, IBaseResource> getExistingIdToContainedResource() {
            if (this.myExistingIdToContainedResourceMap == null) {
                this.myExistingIdToContainedResourceMap = new HashMap<String, IBaseResource>();
            }
            return this.myExistingIdToContainedResourceMap;
        }

        public boolean referenceMatchesAContainedResource(IIdType theRefId) {
            assert (theRefId.getValue().startsWith("#"));
            String expectedResourceId = theRefId.getValue().substring(1);
            return this.getContainedResources().stream().anyMatch(res -> res.getIdElement().getIdPart().equals(expectedResourceId));
        }

        public IIdType addContained(IBaseResource theResource) {
            if (this.getResourceId(theResource) != null) {
                return null;
            }
            IIdType existing = this.getResourceToIdMap().get(theResource);
            if (existing != null) {
                return existing;
            }
            IIdType newId = theResource.getIdElement();
            if (StringUtils.isBlank((CharSequence)newId.getValue())) {
                newId.setValue(UUID.randomUUID().toString());
            } else if (newId.getValue().startsWith("#")) {
                newId.setValue(newId.getValueAsString().substring(1));
            }
            this.getResourceToIdMap().put(theResource, newId);
            this.getOrCreateResourceList().add(theResource);
            return newId;
        }

        public void addContained(IIdType theId, IBaseResource theResource) {
            if (!this.getResourceToIdMap().containsKey(theResource)) {
                this.getResourceToIdMap().put(theResource, theId);
                this.getOrCreateResourceList().add(theResource);
            }
        }

        public List<IBaseResource> getContainedResources() {
            if (this.getResourceToIdMap() == null) {
                return Collections.emptyList();
            }
            return this.getOrCreateResourceList();
        }

        public IIdType getResourceId(IBaseResource theNext) {
            if (this.getResourceToIdMap() == null) {
                return null;
            }
            IIdType idFromMap = this.getResourceToIdMap().get(theNext);
            if (idFromMap != null) {
                return idFromMap;
            }
            if (theNext.getIdElement().getIdPart() != null) {
                return this.getResourceToIdMap().values().stream().filter(id -> theNext.getIdElement().getIdPart().equals(id.getIdPart())).findAny().orElse(null);
            }
            return null;
        }

        private List<IBaseResource> getOrCreateResourceList() {
            if (this.myResourceList == null) {
                this.myResourceList = new ArrayList<IBaseResource>();
            }
            return this.myResourceList;
        }

        private boolean hasResourceToIdValues() {
            return this.myResourceToIdMap != null && !this.myResourceToIdMap.isEmpty();
        }

        private IdentityHashMap<IBaseResource, IIdType> getResourceToIdMap() {
            if (this.myResourceToIdMap == null) {
                this.myResourceToIdMap = new IdentityHashMap();
            }
            return this.myResourceToIdMap;
        }

        public boolean isEmpty() {
            if (this.myResourceToIdMap == null) {
                return true;
            }
            return this.myResourceToIdMap.isEmpty();
        }

        public boolean hasExistingIdToContainedResource() {
            return this.myExistingIdToContainedResourceMap != null;
        }

        public IdentityHashMap<IBaseResource, IIdType> getPreviouslyContainedResourceToIdMap() {
            if (this.myPreviouslyContainedResourceToIdMap == null) {
                this.myPreviouslyContainedResourceToIdMap = new IdentityHashMap();
            }
            return this.myPreviouslyContainedResourceToIdMap;
        }

        public boolean hasPreviouslyContainedResourceToIdValues() {
            return this.myPreviouslyContainedResourceToIdMap != null && !this.myPreviouslyContainedResourceToIdMap.isEmpty();
        }

        public IIdType getPreviouslyContainedResourceId(IBaseResource theResource) {
            if (this.hasPreviouslyContainedResourceToIdValues()) {
                return this.getPreviouslyContainedResourceToIdMap().get(theResource);
            }
            return null;
        }
    }
}

