/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.param;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.api.IQueryParameterOr;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.primitive.BaseDateTimeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.rest.api.QualifiedParamList;
import ca.uhn.fhir.rest.param.BaseParamWithPrefix;
import ca.uhn.fhir.rest.param.ParamPrefixEnum;
import ca.uhn.fhir.rest.param.ParameterUtil;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.util.ValidateUtil;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class DateParam
extends BaseParamWithPrefix<DateParam>
implements IQueryParameterOr<DateParam> {
    private static final long serialVersionUID = 1L;
    private final DateParamDateTimeHolder myValue = new DateParamDateTimeHolder();

    public DateParam() {
    }

    public DateParam(ParamPrefixEnum thePrefix, Date theDate) {
        this.setPrefix(thePrefix);
        this.setValue(theDate);
    }

    public DateParam(ParamPrefixEnum thePrefix, DateTimeDt theDate) {
        this.setPrefix(thePrefix);
        this.myValue.setValueAsString(theDate != null ? theDate.getValueAsString() : null);
    }

    public DateParam(ParamPrefixEnum thePrefix, IPrimitiveType<Date> theDate) {
        this.setPrefix(thePrefix);
        this.myValue.setValueAsString(theDate != null ? theDate.getValueAsString() : null);
    }

    public DateParam(ParamPrefixEnum thePrefix, long theDate) {
        ValidateUtil.isGreaterThan(theDate, 0L, "theDate must not be 0 or negative");
        this.setPrefix(thePrefix);
        this.setValue(new Date(theDate));
    }

    public DateParam(ParamPrefixEnum thePrefix, String theDate) {
        this.setPrefix(thePrefix);
        this.setValueAsString(theDate);
    }

    public DateParam(String theString) {
        this.setValueAsQueryToken(null, null, null, theString);
    }

    @Override
    String doGetQueryParameterQualifier() {
        return null;
    }

    @Override
    String doGetValueAsQueryToken(FhirContext theContext) {
        StringBuilder b = new StringBuilder();
        if (this.getPrefix() != null) {
            b.append(ParameterUtil.escapeWithDefault(this.getPrefix().getValue()));
        }
        b.append(ParameterUtil.escapeWithDefault(this.myValue.getValueAsString()));
        return b.toString();
    }

    @Override
    void doSetValueAsQueryToken(FhirContext theContext, String theParamName, String theQualifier, String theValue) {
        this.setValueAsString(theValue);
    }

    public TemporalPrecisionEnum getPrecision() {
        return this.myValue.getPrecision();
    }

    public Date getValue() {
        return (Date)this.myValue.getValue();
    }

    public String getValueAsString() {
        return this.myValue.getValueAsString();
    }

    @Override
    public List<DateParam> getValuesAsQueryTokens() {
        return Collections.singletonList(this);
    }

    public boolean isEmpty() {
        return this.myValue.isEmpty();
    }

    public DateParam setValue(Date theValue) {
        this.myValue.setValue(theValue, TemporalPrecisionEnum.MILLI);
        return this;
    }

    public void setValue(IPrimitiveType<Date> theValue) {
        if (theValue != null) {
            this.myValue.setValueAsString(theValue.getValueAsString());
        } else {
            this.myValue.setValue(null);
        }
    }

    public void setValueAsString(String theDate) {
        if (StringUtils.isNotBlank((CharSequence)theDate)) {
            ParamPrefixEnum existingPrefix = this.getPrefix();
            this.myValue.setValueAsString(super.extractPrefixAndReturnRest(theDate));
            if (this.getPrefix() == null) {
                this.setPrefix(existingPrefix);
            }
        } else {
            this.myValue.setValue(null);
        }
    }

    @Override
    public void setValuesAsQueryTokens(FhirContext theContext, String theParamName, QualifiedParamList theParameters) {
        this.setMissing(null);
        this.setPrefix(null);
        this.setValueAsString(null);
        if (theParameters.size() == 1) {
            this.setValueAsString((String)theParameters.get(0));
        } else if (theParameters.size() > 1) {
            throw new InvalidRequestException(Msg.code(1939) + "This server does not support multi-valued dates for this parameter: " + String.valueOf(theParameters));
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DateParam)) {
            return false;
        }
        DateParam other = (DateParam)obj;
        return Objects.equals(this.getValue(), other.getValue()) && Objects.equals((Object)this.getPrefix(), (Object)other.getPrefix());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getValue(), this.getPrefix()});
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        b.append("prefix", (Object)this.getPrefix());
        b.append("value", (Object)this.getValueAsString());
        return b.build();
    }

    public static class DateParamDateTimeHolder
    extends BaseDateTimeDt {
        @Override
        protected TemporalPrecisionEnum getDefaultPrecisionForDatatype() {
            return TemporalPrecisionEnum.SECOND;
        }

        @Override
        protected boolean isPrecisionAllowed(TemporalPrecisionEnum thePrecision) {
            return true;
        }
    }
}

