/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.parser;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;

public class PreserveStringReader
extends Reader {
    private final Reader myReader;
    private final StringWriter myWriter;

    public PreserveStringReader(Reader theReader) {
        super((Object)theReader);
        this.myReader = theReader;
        this.myWriter = new StringWriter();
    }

    @Override
    public int read(@Nonnull char[] theBuffer, int theOffset, int theLength) throws IOException {
        int out = this.myReader.read(theBuffer, theOffset, theLength);
        if (out >= 0) {
            this.myWriter.write(theBuffer, theOffset, out);
        }
        return out;
    }

    @Override
    public void close() throws IOException {
        this.myReader.close();
        this.myWriter.close();
    }

    public boolean hasString() {
        return this.myWriter.getBuffer().length() > 0;
    }

    public String toString() {
        return this.myWriter.toString();
    }
}

