/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.narrative2;

import ca.uhn.fhir.narrative2.INarrativeTemplate;
import ca.uhn.fhir.narrative2.NarrativeTemplateManifest;
import ca.uhn.fhir.narrative2.TemplateTypeEnum;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hl7.fhir.instance.model.api.IBase;

public class NarrativeTemplate
implements INarrativeTemplate {
    private final Set<String> myAppliesToProfiles = new HashSet<String>();
    private final Set<String> myAppliesToResourceTypes = new HashSet<String>();
    private final Set<String> myAppliesToDataTypes = new HashSet<String>();
    private final Set<Class<? extends IBase>> myAppliesToClasses = new HashSet<Class<? extends IBase>>();
    private final Set<String> myAppliesToFragmentNames = new HashSet<String>();
    private final Set<String> myAppliesToCode = new HashSet<String>();
    private String myTemplateFileName;
    private TemplateTypeEnum myTemplateType = TemplateTypeEnum.THYMELEAF;
    private String myContextPath;
    private String myTemplateName;

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SIMPLE_STYLE).append("name", (Object)this.myTemplateName).append("fileName", (Object)this.myTemplateFileName).toString();
    }

    public Set<String> getAppliesToDataTypes() {
        return Collections.unmodifiableSet(this.myAppliesToDataTypes);
    }

    public Set<String> getAppliesToFragmentNames() {
        return Collections.unmodifiableSet(this.myAppliesToFragmentNames);
    }

    void addAppliesToFragmentName(String theAppliesToFragmentName) {
        this.myAppliesToFragmentNames.add(theAppliesToFragmentName);
    }

    @Override
    public String getContextPath() {
        return this.myContextPath;
    }

    public void setContextPath(String theContextPath) {
        this.myContextPath = theContextPath;
    }

    private String getTemplateFileName() {
        return this.myTemplateFileName;
    }

    void setTemplateFileName(String theTemplateFileName) {
        this.myTemplateFileName = theTemplateFileName;
    }

    @Override
    public Set<String> getAppliesToProfiles() {
        return Collections.unmodifiableSet(this.myAppliesToProfiles);
    }

    @Override
    public Set<String> getAppliesToCode() {
        return Collections.unmodifiableSet(this.myAppliesToCode);
    }

    void addAppliesToProfile(String theAppliesToProfile) {
        this.myAppliesToProfiles.add(theAppliesToProfile);
    }

    void addAppliesToCode(String theAppliesToCode) {
        this.myAppliesToCode.add(theAppliesToCode);
    }

    @Override
    public Set<String> getAppliesToResourceTypes() {
        return Collections.unmodifiableSet(this.myAppliesToResourceTypes);
    }

    void addAppliesToResourceType(String theAppliesToResourceType) {
        this.myAppliesToResourceTypes.add(theAppliesToResourceType);
    }

    @Override
    public Set<Class<? extends IBase>> getAppliesToClasses() {
        return Collections.unmodifiableSet(this.myAppliesToClasses);
    }

    void addAppliesToClass(Class<? extends IBase> theAppliesToClass) {
        this.myAppliesToClasses.add(theAppliesToClass);
    }

    @Override
    public TemplateTypeEnum getTemplateType() {
        return this.myTemplateType;
    }

    void setTemplateType(TemplateTypeEnum theTemplateType) {
        this.myTemplateType = theTemplateType;
    }

    @Override
    public String getTemplateName() {
        return this.myTemplateName;
    }

    NarrativeTemplate setTemplateName(String theTemplateName) {
        this.myTemplateName = theTemplateName;
        return this;
    }

    @Override
    public String getTemplateText() {
        return NarrativeTemplateManifest.loadResource(this.getTemplateFileName());
    }

    void addAppliesToDatatype(String theDataType) {
        this.myAppliesToDataTypes.add(theDataType);
    }
}

