/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.narrative;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.fhirpath.IFhirPath;
import ca.uhn.fhir.fhirpath.IFhirPathEvaluationContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.narrative2.BaseNarrativeGenerator;
import ca.uhn.fhir.narrative2.INarrativeTemplate;
import ca.uhn.fhir.narrative2.NarrativeGeneratorTemplateUtils;
import ca.uhn.fhir.narrative2.TemplateTypeEnum;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.cache.AlwaysValidCacheEntryValidity;
import org.thymeleaf.cache.ICacheEntryValidity;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.dialect.IExpressionObjectDialect;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.expression.IExpressionObjectFactory;
import org.thymeleaf.messageresolver.IMessageResolver;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.processor.IProcessor;
import org.thymeleaf.processor.element.AbstractAttributeTagProcessor;
import org.thymeleaf.processor.element.AbstractElementTagProcessor;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.standard.StandardDialect;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.expression.IStandardExpressionParser;
import org.thymeleaf.standard.expression.StandardExpressions;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.DefaultTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresource.ITemplateResource;
import org.thymeleaf.templateresource.StringTemplateResource;

public abstract class BaseThymeleafNarrativeGenerator
extends BaseNarrativeGenerator {
    public static final String FHIRPATH = "fhirpath";
    private IMessageResolver myMessageResolver;
    private IFhirPathEvaluationContext myFhirPathEvaluationContext;

    protected BaseThymeleafNarrativeGenerator() {
    }

    public void setFhirPathEvaluationContext(IFhirPathEvaluationContext theFhirPathEvaluationContext) {
        this.myFhirPathEvaluationContext = theFhirPathEvaluationContext;
    }

    private TemplateEngine getTemplateEngine(final FhirContext theFhirContext) {
        TemplateEngine engine = new TemplateEngine();
        NarrativeTemplateResolver resolver = new NarrativeTemplateResolver(theFhirContext);
        engine.setTemplateResolver((ITemplateResolver)resolver);
        if (this.myMessageResolver != null) {
            engine.setMessageResolver(this.myMessageResolver);
        }
        StandardDialect dialect = new StandardDialect(){

            public Set<IProcessor> getProcessors(String theDialectPrefix) {
                Set retVal = super.getProcessors(theDialectPrefix);
                retVal.add(new NarrativeTagProcessor(theFhirContext, theDialectPrefix));
                retVal.add(new NarrativeAttributeProcessor(theDialectPrefix, theFhirContext));
                return retVal;
            }
        };
        engine.setDialect((IDialect)dialect);
        engine.addDialect((IDialect)new NarrativeGeneratorDialect(theFhirContext));
        return engine;
    }

    @Override
    protected String applyTemplate(FhirContext theFhirContext, INarrativeTemplate theTemplate, IBase theTargetContext) {
        Context context = new Context();
        context.setVariable("resource", (Object)theTargetContext);
        context.setVariable("context", (Object)theTargetContext);
        context.setVariable("narrativeUtil", (Object)NarrativeGeneratorTemplateUtils.INSTANCE);
        context.setVariable("fhirVersion", (Object)theFhirContext.getVersion().getVersion().name());
        return this.getTemplateEngine(theFhirContext).process(theTemplate.getTemplateName(), (IContext)context);
    }

    @Override
    protected EnumSet<TemplateTypeEnum> getStyle() {
        return EnumSet.of(TemplateTypeEnum.THYMELEAF);
    }

    private String applyTemplateWithinTag(FhirContext theFhirContext, ITemplateContext theTemplateContext, String theName, String theElement) {
        List<INarrativeTemplate> templateOpt;
        IEngineConfiguration configuration = theTemplateContext.getConfiguration();
        IStandardExpressionParser expressionParser = StandardExpressions.getExpressionParser((IEngineConfiguration)configuration);
        IStandardExpression expression = expressionParser.parseExpression((IExpressionContext)theTemplateContext, theElement);
        Object elementValueObj = expression.execute((IExpressionContext)theTemplateContext);
        IBase elementValue = (IBase)elementValueObj;
        if (elementValue == null) {
            return "";
        }
        if (StringUtils.isNotBlank((CharSequence)theName)) {
            templateOpt = this.getManifest().getTemplateByName(theFhirContext, this.getStyle(), theName);
            if (templateOpt.isEmpty()) {
                throw new InternalErrorException(Msg.code(1863) + "Unknown template name: " + theName);
            }
        } else {
            templateOpt = this.getManifest().getTemplateByElement(theFhirContext, this.getStyle(), elementValue);
            if (templateOpt.isEmpty()) {
                throw new InternalErrorException(Msg.code(1864) + "No template for type: " + String.valueOf(elementValue.getClass()));
            }
        }
        return this.applyTemplate(theFhirContext, templateOpt.get(0), elementValue);
    }

    public void setMessageResolver(IMessageResolver theMessageResolver) {
        this.myMessageResolver = theMessageResolver;
    }

    private class NarrativeTemplateResolver
    extends DefaultTemplateResolver {
        private final FhirContext myFhirContext;

        private NarrativeTemplateResolver(FhirContext theFhirContext) {
            this.myFhirContext = theFhirContext;
        }

        protected boolean computeResolvable(IEngineConfiguration theConfiguration, String theOwnerTemplate, String theTemplate, Map<String, Object> theTemplateResolutionAttributes) {
            if (theOwnerTemplate == null) {
                return BaseThymeleafNarrativeGenerator.this.getManifest().getTemplateByName(this.myFhirContext, BaseThymeleafNarrativeGenerator.this.getStyle(), theTemplate).size() > 0;
            }
            return BaseThymeleafNarrativeGenerator.this.getManifest().getTemplateByFragmentName(this.myFhirContext, BaseThymeleafNarrativeGenerator.this.getStyle(), theTemplate).size() > 0;
        }

        protected TemplateMode computeTemplateMode(IEngineConfiguration theConfiguration, String theOwnerTemplate, String theTemplate, Map<String, Object> theTemplateResolutionAttributes) {
            return TemplateMode.XML;
        }

        protected ITemplateResource computeTemplateResource(IEngineConfiguration theConfiguration, String theOwnerTemplate, String theTemplate, Map<String, Object> theTemplateResolutionAttributes) {
            if (theOwnerTemplate == null) {
                return (ITemplateResource)BaseThymeleafNarrativeGenerator.this.getManifest().getTemplateByName(this.myFhirContext, BaseThymeleafNarrativeGenerator.this.getStyle(), theTemplate).stream().findFirst().map(t -> new StringTemplateResource(t.getTemplateText())).orElseThrow(() -> new IllegalArgumentException("Unknown template: " + theTemplate));
            }
            return (ITemplateResource)BaseThymeleafNarrativeGenerator.this.getManifest().getTemplateByFragmentName(this.myFhirContext, BaseThymeleafNarrativeGenerator.this.getStyle(), theTemplate).stream().findFirst().map(t -> new StringTemplateResource(t.getTemplateText())).orElseThrow(() -> new IllegalArgumentException("Unknown template: " + theTemplate));
        }

        protected ICacheEntryValidity computeValidity(IEngineConfiguration theConfiguration, String theOwnerTemplate, String theTemplate, Map<String, Object> theTemplateResolutionAttributes) {
            return AlwaysValidCacheEntryValidity.INSTANCE;
        }
    }

    private class NarrativeGeneratorDialect
    implements IDialect,
    IExpressionObjectDialect {
        private final FhirContext myFhirContext;

        public NarrativeGeneratorDialect(FhirContext theFhirContext) {
            this.myFhirContext = theFhirContext;
        }

        public String getName() {
            return "NarrativeGeneratorDialect";
        }

        public IExpressionObjectFactory getExpressionObjectFactory() {
            return new NarrativeGeneratorExpressionObjectFactory(this.myFhirContext);
        }
    }

    private class NarrativeGeneratorFhirPathExpressionObject {
        private final FhirContext myFhirContext;

        public NarrativeGeneratorFhirPathExpressionObject(FhirContext theFhirContext) {
            this.myFhirContext = theFhirContext;
        }

        public IBase evaluateFirst(IBase theInput, String theExpression) {
            IFhirPath fhirPath = this.newFhirPath();
            Optional<IBase> output = fhirPath.evaluateFirst(theInput, theExpression, IBase.class);
            return output.orElse(null);
        }

        public List<IBase> evaluate(IBase theInput, String theExpression) {
            IFhirPath fhirPath = this.newFhirPath();
            return fhirPath.evaluate(theInput, theExpression, IBase.class);
        }

        private IFhirPath newFhirPath() {
            IFhirPath fhirPath = this.myFhirContext.newFhirPath();
            if (BaseThymeleafNarrativeGenerator.this.myFhirPathEvaluationContext != null) {
                fhirPath.setEvaluationContext(BaseThymeleafNarrativeGenerator.this.myFhirPathEvaluationContext);
            }
            return fhirPath;
        }
    }

    private class NarrativeGeneratorExpressionObjectFactory
    implements IExpressionObjectFactory {
        private final FhirContext myFhirContext;

        public NarrativeGeneratorExpressionObjectFactory(FhirContext theFhirContext) {
            this.myFhirContext = theFhirContext;
        }

        public Set<String> getAllExpressionObjectNames() {
            return Sets.newHashSet((Object[])new String[]{BaseThymeleafNarrativeGenerator.FHIRPATH});
        }

        public Object buildObject(IExpressionContext context, String expressionObjectName) {
            if (BaseThymeleafNarrativeGenerator.FHIRPATH.equals(expressionObjectName)) {
                return new NarrativeGeneratorFhirPathExpressionObject(this.myFhirContext);
            }
            return null;
        }

        public boolean isCacheable(String expressionObjectName) {
            return false;
        }
    }

    private class NarrativeAttributeProcessor
    extends AbstractAttributeTagProcessor {
        private final FhirContext myFhirContext;

        NarrativeAttributeProcessor(String theDialectPrefix, FhirContext theFhirContext) {
            super(TemplateMode.XML, theDialectPrefix, null, false, "narrative", true, 0, true);
            this.myFhirContext = theFhirContext;
        }

        protected void doProcess(ITemplateContext theContext, IProcessableElementTag theTag, AttributeName theAttributeName, String theAttributeValue, IElementTagStructureHandler theStructureHandler) {
            String text = BaseThymeleafNarrativeGenerator.this.applyTemplateWithinTag(this.myFhirContext, theContext, null, theAttributeValue);
            theStructureHandler.setBody((CharSequence)text, false);
        }
    }

    private class NarrativeTagProcessor
    extends AbstractElementTagProcessor {
        private final FhirContext myFhirContext;

        NarrativeTagProcessor(FhirContext theFhirContext, String dialectPrefix) {
            super(TemplateMode.XML, dialectPrefix, "narrative", true, null, true, 0);
            this.myFhirContext = theFhirContext;
        }

        protected void doProcess(ITemplateContext theTemplateContext, IProcessableElementTag theTag, IElementTagStructureHandler theStructureHandler) {
            String name = theTag.getAttributeValue("th:name");
            String element = theTag.getAttributeValue("th:element");
            String appliedTemplate = BaseThymeleafNarrativeGenerator.this.applyTemplateWithinTag(this.myFhirContext, theTemplateContext, name, element);
            theStructureHandler.replaceWith((CharSequence)appliedTemplate, false);
        }
    }
}

